/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.util.exif;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.coobird.thumbnailator.util.exif.IfdStructure;
import net.coobird.thumbnailator.util.exif.IfdType;
import net.coobird.thumbnailator.util.exif.Orientation;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ExifUtils {
    private static final String EXIF_MAGIC_STRING = "Exif";

    private ExifUtils() {
    }

    public static Orientation getExifOrientation(ImageReader reader, int imageIndex) throws IOException {
        IIOMetadata metadata = reader.getImageMetadata(imageIndex);
        Node rootNode = metadata.getAsTree("javax_imageio_jpeg_image_1.0");
        NodeList childNodes = rootNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if ("markerSequence".equals(childNodes.item(i).getNodeName())) {
                NodeList markerSequenceChildren = childNodes.item(i).getChildNodes();
                int j = 0;
                while (j < markerSequenceChildren.getLength()) {
                    IIOMetadataNode metadataNode = (IIOMetadataNode)markerSequenceChildren.item(j);
                    byte[] bytes = (byte[])metadataNode.getUserObject();
                    if (bytes != null) {
                        byte[] magicNumber = new byte[4];
                        ByteBuffer.wrap(bytes).get(magicNumber);
                        if (EXIF_MAGIC_STRING.equals(new String(magicNumber))) {
                            return ExifUtils.getOrientationFromExif(bytes);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private static Orientation getOrientationFromExif(byte[] exifData) {
        ByteBuffer buffer = ByteBuffer.wrap(exifData);
        byte[] exifId = new byte[4];
        buffer.get(exifId);
        if (!EXIF_MAGIC_STRING.equals(new String(exifId))) {
            return null;
        }
        buffer.get();
        buffer.get();
        byte[] tiffHeader = new byte[8];
        buffer.get(tiffHeader);
        ByteOrder bo = tiffHeader[0] == 73 && tiffHeader[1] == 73 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        byte[] numFields = new byte[2];
        buffer.get(numFields);
        int nFields = ByteBuffer.wrap(numFields).order(bo).getShort();
        byte[] ifd = new byte[12];
        int i = 0;
        while (i < nFields) {
            buffer.get(ifd);
            IfdStructure ifdStructure = ExifUtils.readIFD(ifd, bo);
            if (ifdStructure.getTag() == 274) {
                return Orientation.typeOf(ifdStructure.getOffsetValue());
            }
            ++i;
        }
        return null;
    }

    private static IfdStructure readIFD(byte[] ifd, ByteOrder bo) {
        ByteBuffer buffer = ByteBuffer.wrap(ifd).order(bo);
        short tag = buffer.getShort();
        short type = buffer.getShort();
        int count = buffer.getInt();
        IfdType ifdType = IfdType.typeOf(type);
        int offsetValue = 0;
        int byteSize = count * ifdType.size();
        if (byteSize <= 4) {
            if (ifdType == IfdType.SHORT) {
                int i = 0;
                while (i < count) {
                    offsetValue = buffer.getShort();
                    ++i;
                }
            } else if (ifdType == IfdType.BYTE || ifdType == IfdType.ASCII || ifdType == IfdType.UNDEFINED) {
                int i = 0;
                while (i < count) {
                    offsetValue = buffer.get();
                    ++i;
                }
            } else {
                offsetValue = buffer.getInt();
            }
        } else {
            offsetValue = buffer.getInt();
        }
        return new IfdStructure(tag, type, count, offsetValue);
    }
}

