/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.internal.ICommandHelpService;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.IUpdateService;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.renderers.swt.AbstractContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolItemUpdater;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;

public class HandledContributionItem
extends AbstractContributionItem {
    private static final String ORG_ECLIPSE_UI_COMMANDS_RADIO_STATE_PARAMETER = "org.eclipse.ui.commands.radioStateParameter";
    private static final String ORG_ECLIPSE_UI_COMMANDS_RADIO_STATE = "org.eclipse.ui.commands.radioState";
    private static final String ORG_ECLIPSE_UI_COMMANDS_TOGGLE_STATE = "org.eclipse.ui.commands.toggleState";
    private static final String WW_SUPPORT = "org.eclipse.ui.IWorkbenchWindow";
    private static final String HCI_STATIC_CONTEXT = "HCI-staticContext";
    @Inject
    private ECommandService commandService;
    @Inject
    private EBindingService bindingService;
    @Inject
    @Optional
    private IUpdateService updateService;
    @Inject
    @Optional
    private ICommandHelpService commandHelpService;
    private Runnable unreferenceRunnable;
    private IStateListener stateListener = new IStateListener(){

        public void handleStateChange(State state, Object oldValue) {
            HandledContributionItem.this.updateState();
        }
    };
    private IEclipseContext infoContext;
    private State styleState;
    private State toggleState;
    private State radioState;

    @Override
    public void setModel(MItem item) {
        if (!(item instanceof MHandledItem)) {
            throw new IllegalArgumentException("Only instances of MHandledItem are allowed");
        }
        super.setModel(item);
        this.generateCommand();
        if (this.getModel().getCommand() == null && this.logger != null) {
            this.logger.error("Element " + this.getModel().getElementId() + " invalid, no command defined.");
        }
    }

    public void setModel(MHandledItem item) {
        this.setModel((MItem)item);
    }

    private void generateCommand() {
        if (this.getModel().getCommand() != null && this.getModel().getWbCommand() == null) {
            String cmdId = this.getModel().getCommand().getElementId();
            if (cmdId == null) {
                Activator.log((int)4, (String)("Unable to generate parameterized command for " + this.getModel() + ". ElementId is not allowed to be null."));
                return;
            }
            List modelParms = this.getModel().getParameters();
            HashMap<String, String> parameters = new HashMap<String, String>(4);
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
            ParameterizedCommand parmCmd = this.commandService.createCommand(cmdId, parameters);
            Activator.trace((String)"/trace/menus", (String)("command: " + parmCmd), null);
            if (parmCmd == null) {
                Activator.log((int)4, (String)("Unable to generate parameterized command for " + this.getModel() + " with " + parameters));
                return;
            }
            this.getModel().setWbCommand(parmCmd);
            this.styleState = parmCmd.getCommand().getState("STYLE");
            this.toggleState = parmCmd.getCommand().getState(ORG_ECLIPSE_UI_COMMANDS_TOGGLE_STATE);
            this.radioState = parmCmd.getCommand().getState(ORG_ECLIPSE_UI_COMMANDS_RADIO_STATE);
            this.updateState();
            if (this.styleState != null) {
                this.styleState.addListener(this.stateListener);
            } else if (this.toggleState != null) {
                this.toggleState.addListener(this.stateListener);
            } else if (this.radioState != null) {
                this.radioState.addListener(this.stateListener);
            }
        }
    }

    private void updateState() {
        if (this.styleState != null) {
            this.getModel().setSelected(((Boolean)this.styleState.getValue()).booleanValue());
        } else if (this.toggleState != null) {
            this.getModel().setSelected(((Boolean)this.toggleState.getValue()).booleanValue());
        } else if (this.radioState != null && this.getModel().getWbCommand() != null) {
            ParameterizedCommand c = this.getModel().getWbCommand();
            Object parameter = c.getParameterMap().get(ORG_ECLIPSE_UI_COMMANDS_RADIO_STATE_PARAMETER);
            String value = (String)this.radioState.getValue();
            this.getModel().setSelected(value != null && value.equals(parameter));
        }
    }

    @Override
    protected void postMenuFill() {
        ParameterizedCommand wbCommand;
        if (this.updateService != null && (wbCommand = this.getModel().getWbCommand()) != null) {
            this.unreferenceRunnable = this.updateService.registerElementForUpdate(wbCommand, (MItem)this.getModel());
        }
    }

    @Override
    protected void postToolbarFill() {
        ParameterizedCommand wbCommand;
        this.hookCheckListener();
        if (this.updateService != null && (wbCommand = this.getModel().getWbCommand()) != null) {
            this.unreferenceRunnable = this.updateService.registerElementForUpdate(wbCommand, (MItem)this.getModel());
        }
    }

    private void hookCheckListener() {
        if (this.getModel().getType() != ItemType.CHECK) {
            return;
        }
        Object obj = this.getModel().getTransientData().get(ItemType.CHECK.toString());
        if (obj instanceof IContextFunction) {
            IEclipseContext context = this.getContext((MUIElement)this.getModel());
            IEclipseContext staticContext = this.getStaticContext(null);
            staticContext.set(MPart.class, (Object)((MPart)context.get(MPart.class)));
            staticContext.set(WW_SUPPORT, context.get(WW_SUPPORT));
            IContextFunction func = (IContextFunction)obj;
            obj = func.compute(staticContext, null);
            if (obj != null) {
                this.getModel().getTransientData().put("IDisposable", obj);
            }
        }
    }

    private void unhookCheckListener() {
        if (this.getModel().getType() != ItemType.CHECK) {
            return;
        }
        Object obj = this.getModel().getTransientData().remove("IDisposable");
        if (obj == null) {
            return;
        }
        ((Runnable)obj).run();
    }

    @Override
    protected void updateMenuItem() {
        MenuItem item = (MenuItem)this.widget;
        String text = this.getModel().getLocalizedLabel();
        ParameterizedCommand parmCmd = this.getModel().getWbCommand();
        String keyBindingText = null;
        if (parmCmd != null) {
            TriggerSequence binding;
            if (text == null || text.isEmpty()) {
                try {
                    text = parmCmd.getName(this.getModel().getCommand().getLocalizedCommandName());
                }
                catch (NotDefinedException e) {
                    e.printStackTrace();
                }
            }
            if (this.bindingService != null && (binding = this.bindingService.getBestSequenceFor(parmCmd)) != null) {
                keyBindingText = binding.format();
            }
        }
        if (text != null) {
            int idx;
            String mnemonics;
            if (this.getModel() instanceof MMenuElement && (mnemonics = ((MMenuElement)this.getModel()).getMnemonics()) != null && !mnemonics.isEmpty() && (idx = text.indexOf(mnemonics)) != -1) {
                text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
            }
            if (keyBindingText == null) {
                item.setText(text);
            } else {
                item.setText(String.valueOf(text) + '\t' + keyBindingText);
            }
        } else {
            item.setText("");
        }
        String tooltip = this.getToolTipText(false);
        item.setToolTipText(tooltip);
        item.setSelection(this.getModel().isSelected());
        item.setEnabled(this.getModel().isEnabled());
    }

    @Override
    protected void updateToolItem() {
        ToolItem item = (ToolItem)this.widget;
        if (item.getImage() == null || this.getModel().getTags().contains("FORCE_TEXT")) {
            String text = this.getModel().getLocalizedLabel();
            if (text == null || text.length() == 0) {
                MCommand command = this.getModel().getCommand();
                if (command == null) {
                    item.setText("UnLabled");
                } else {
                    item.setText(command.getLocalizedCommandName());
                }
            } else {
                item.setText(text);
            }
        } else {
            item.setText("");
        }
        String tooltip = this.getToolTipText(true);
        item.setToolTipText(tooltip);
        item.setSelection(this.getModel().isSelected());
        item.setEnabled(this.getModel().isEnabled());
    }

    private String getToolTipText(boolean attachKeybinding) {
        String text = this.getModel().getLocalizedTooltip();
        ParameterizedCommand parmCmd = this.getModel().getWbCommand();
        if (parmCmd == null) {
            this.generateCommand();
            parmCmd = this.getModel().getWbCommand();
        }
        if (parmCmd != null && text == null) {
            try {
                text = parmCmd.getName();
            }
            catch (NotDefinedException notDefinedException) {
                return null;
            }
        }
        TriggerSequence sequence = this.bindingService.getBestSequenceFor(parmCmd);
        if (attachKeybinding && sequence != null) {
            text = String.valueOf(text) + " (" + sequence.format() + ')';
        }
        return text;
    }

    @Override
    protected void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            if (this.unreferenceRunnable != null) {
                this.unreferenceRunnable.run();
                this.unreferenceRunnable = null;
            }
            this.unhookCheckListener();
            ToolItemUpdater updater = this.getUpdater();
            if (updater != null) {
                updater.removeItem(this);
            }
            if (this.infoContext != null) {
                this.infoContext.dispose();
                this.infoContext = null;
            }
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget.removeListener(14, this.getItemListener());
            this.widget.removeListener(28, this.getItemListener());
            this.widget = null;
            this.getModel().setWidget(null);
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.widget != null) {
            ParameterizedCommand command;
            if (this.unreferenceRunnable != null) {
                this.unreferenceRunnable.run();
                this.unreferenceRunnable = null;
            }
            if ((command = this.getModel().getWbCommand()) != null) {
                if (this.styleState != null) {
                    this.styleState.removeListener(this.stateListener);
                    this.styleState = null;
                }
                if (this.toggleState != null) {
                    this.toggleState.removeListener(this.stateListener);
                    this.toggleState = null;
                }
                if (this.radioState != null) {
                    this.radioState.removeListener(this.stateListener);
                    this.radioState = null;
                }
            }
            this.widget.dispose();
            this.widget = null;
            this.getModel().setWidget(null);
        }
    }

    @Override
    protected void handleHelpRequest() {
        if (this.helpService == null) {
            return;
        }
        String helpContextId = (String)this.getModel().getPersistedState().get("HelpContextId");
        if (helpContextId != null) {
            this.helpService.displayHelp(helpContextId);
            return;
        }
        MCommand command = this.getModel().getCommand();
        if (command == null || this.commandHelpService == null) {
            return;
        }
        String contextHelpId = this.commandHelpService.getHelpContextId(command.getElementId(), this.getContext((MUIElement)this.getModel()));
        if (contextHelpId != null) {
            this.helpService.displayHelp(contextHelpId);
        }
    }

    private IEclipseContext getStaticContext(Event event) {
        if (this.infoContext == null) {
            this.infoContext = EclipseContextFactory.create((String)HCI_STATIC_CONTEXT);
            ContributionsAnalyzer.populateModelInterfaces((Object)this.getModel(), (IEclipseContext)this.infoContext, (Class[])this.getModel().getClass().getInterfaces());
        }
        if (event == null) {
            this.infoContext.remove(Event.class);
        } else {
            this.infoContext.set(Event.class, (Object)event);
        }
        return this.infoContext;
    }

    @Override
    protected void executeItem(Event trigger) {
        ParameterizedCommand cmd = this.getModel().getWbCommand();
        if (cmd == null) {
            return;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)this.getModel());
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
        IEclipseContext staticContext = this.getStaticContext(trigger);
        service.executeHandler(cmd, staticContext);
    }

    @Override
    protected boolean canExecuteItem(Event trigger) {
        ParameterizedCommand cmd = this.getModel().getWbCommand();
        if (cmd == null) {
            return false;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)this.getModel());
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class);
        if (service == null) {
            return false;
        }
        IEclipseContext staticContext = this.getStaticContext(trigger);
        return service.canExecute(cmd, staticContext);
    }

    public MHandledItem getModel() {
        return (MHandledItem)super.getModel();
    }
}

