/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.security;

import java.security.MessageDigest;

public class PKCS12KeyGenerator {
    public static final int KEY_MATERIAL = 1;
    public static final int IV_MATERIAL = 2;
    public static final int MAC_MATERIAL = 3;
    protected byte[] password;
    protected byte[] salt;
    protected int iterationCount;
    private MessageDigest digest;
    private int u;
    private int v;

    public PKCS12KeyGenerator(MessageDigest digest) {
        this.digest = digest;
        this.u = digest.getDigestLength();
        this.v = 64;
    }

    public void init(byte[] password, byte[] salt, int iterationCount) {
        this.password = password;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    public byte[] getPassword() {
        return this.password;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public static byte[] PKCS12PasswordToBytes(char[] password) {
        if (password != null && password.length > 0) {
            byte[] bytes = new byte[(password.length + 1) * 2];
            int i = 0;
            while (i != password.length) {
                bytes[i * 2] = (byte)(password[i] >>> 8);
                bytes[i * 2 + 1] = (byte)password[i];
                ++i;
            }
            return bytes;
        }
        return new byte[0];
    }

    private void adjust(byte[] a, int aOff, byte[] b) {
        int x = (b[b.length - 1] & 0xFF) + (a[aOff + b.length - 1] & 0xFF) + 1;
        a[aOff + b.length - 1] = (byte)x;
        x >>>= 8;
        int i = b.length - 2;
        while (i >= 0) {
            a[aOff + i] = (byte)(x += (b[i] & 0xFF) + (a[aOff + i] & 0xFF));
            x >>>= 8;
            --i;
        }
    }

    private byte[] generateDerivedKey(int idByte, int n) {
        byte[] P;
        byte[] S;
        byte[] D = new byte[this.v];
        byte[] dKey = new byte[n];
        int i = 0;
        while (i != D.length) {
            D[i] = (byte)idByte;
            ++i;
        }
        if (this.salt != null && this.salt.length != 0) {
            S = new byte[this.v * ((this.salt.length + this.v - 1) / this.v)];
            int i2 = 0;
            while (i2 != S.length) {
                S[i2] = this.salt[i2 % this.salt.length];
                ++i2;
            }
        } else {
            S = new byte[]{};
        }
        if (this.password != null && this.password.length != 0) {
            P = new byte[this.v * ((this.password.length + this.v - 1) / this.v)];
            int i3 = 0;
            while (i3 != P.length) {
                P[i3] = this.password[i3 % this.password.length];
                ++i3;
            }
        } else {
            P = new byte[]{};
        }
        byte[] I = new byte[S.length + P.length];
        System.arraycopy(S, 0, I, 0, S.length);
        System.arraycopy(P, 0, I, S.length, P.length);
        byte[] B = new byte[this.v];
        int c = (n + this.u - 1) / this.u;
        int i4 = 1;
        while (i4 <= c) {
            this.digest.update(D, 0, D.length);
            this.digest.update(I, 0, I.length);
            byte[] A = this.digest.digest();
            int j = 1;
            while (j < this.iterationCount) {
                this.digest.update(A, 0, A.length);
                A = this.digest.digest();
                ++j;
            }
            j = 0;
            while (j != B.length) {
                B[j] = A[j % A.length];
                ++j;
            }
            j = 0;
            while (j != I.length / this.v) {
                this.adjust(I, j * this.v, B);
                ++j;
            }
            if (i4 == c) {
                System.arraycopy(A, 0, dKey, (i4 - 1) * this.u, dKey.length - (i4 - 1) * this.u);
            } else {
                System.arraycopy(A, 0, dKey, (i4 - 1) * this.u, A.length);
            }
            ++i4;
        }
        return dKey;
    }

    public byte[] generateDerivedKey(int keySize) {
        byte[] dKey = this.generateDerivedKey(1, keySize /= 8);
        byte[] key = new byte[keySize];
        System.arraycopy(dKey, 0, key, 0, keySize);
        return key;
    }
}

