/* ncRna.c was originally generated by the autoSql program, which also 
 * generated ncRna.h and ncRna.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "ncRna.h"


void ncRnaStaticLoad(char **row, struct ncRna *ret)
/* Load a row from ncRna table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->bin = sqlSigned(row[0]);
ret->chrom = row[1];
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->name = row[4];
ret->score = sqlSigned(row[5]);
strcpy(ret->strand, row[6]);
ret->thickStart = sqlUnsigned(row[7]);
ret->thickEnd = sqlUnsigned(row[8]);
ret->type = row[9];
ret->extGeneId = row[10];
}

struct ncRna *ncRnaLoad(char **row)
/* Load a ncRna from row fetched with select * from ncRna
 * from database.  Dispose of this with ncRnaFree(). */
{
struct ncRna *ret;

AllocVar(ret);
ret->bin = sqlSigned(row[0]);
ret->chrom = cloneString(row[1]);
ret->chromStart = sqlUnsigned(row[2]);
ret->chromEnd = sqlUnsigned(row[3]);
ret->name = cloneString(row[4]);
ret->score = sqlSigned(row[5]);
strcpy(ret->strand, row[6]);
ret->thickStart = sqlUnsigned(row[7]);
ret->thickEnd = sqlUnsigned(row[8]);
ret->type = cloneString(row[9]);
ret->extGeneId = cloneString(row[10]);
return ret;
}

struct ncRna *ncRnaLoadAll(char *fileName) 
/* Load all ncRna from a whitespace-separated file.
 * Dispose of this with ncRnaFreeList(). */
{
struct ncRna *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileRow(lf, row))
    {
    el = ncRnaLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ncRna *ncRnaLoadAllByChar(char *fileName, char chopper) 
/* Load all ncRna from a chopper separated file.
 * Dispose of this with ncRnaFreeList(). */
{
struct ncRna *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = ncRnaLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct ncRna *ncRnaCommaIn(char **pS, struct ncRna *ret)
/* Create a ncRna out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ncRna */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->bin = sqlSignedComma(&s);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlSignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->type = sqlStringComma(&s);
ret->extGeneId = sqlStringComma(&s);
*pS = s;
return ret;
}

void ncRnaFree(struct ncRna **pEl)
/* Free a single dynamically allocated ncRna such as created
 * with ncRnaLoad(). */
{
struct ncRna *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->type);
freeMem(el->extGeneId);
freez(pEl);
}

void ncRnaFreeList(struct ncRna **pList)
/* Free a list of dynamically allocated ncRna's */
{
struct ncRna *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    ncRnaFree(&el);
    }
*pList = NULL;
}

void ncRnaOutput(struct ncRna *el, FILE *f, char sep, char lastSep) 
/* Print out ncRna.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->bin);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->extGeneId);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

