/* cnpSharp2.c was originally generated by the autoSql program, which also 
 * generated cnpSharp2.h and cnpSharp2.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cnpSharp2.h"


void cnpSharp2StaticLoad(char **row, struct cnpSharp2 *ret)
/* Load a row from cnpSharp2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->variationType = row[4];
}

struct cnpSharp2 *cnpSharp2Load(char **row)
/* Load a cnpSharp2 from row fetched with select * from cnpSharp2
 * from database.  Dispose of this with cnpSharp2Free(). */
{
struct cnpSharp2 *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->variationType = cloneString(row[4]);
return ret;
}

struct cnpSharp2 *cnpSharp2LoadAll(char *fileName) 
/* Load all cnpSharp2 from a whitespace-separated file.
 * Dispose of this with cnpSharp2FreeList(). */
{
struct cnpSharp2 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = cnpSharp2Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpSharp2 *cnpSharp2LoadAllByChar(char *fileName, char chopper) 
/* Load all cnpSharp2 from a chopper separated file.
 * Dispose of this with cnpSharp2FreeList(). */
{
struct cnpSharp2 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cnpSharp2Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpSharp2 *cnpSharp2CommaIn(char **pS, struct cnpSharp2 *ret)
/* Create a cnpSharp2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpSharp2 */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->variationType = sqlStringComma(&s);
*pS = s;
return ret;
}

void cnpSharp2Free(struct cnpSharp2 **pEl)
/* Free a single dynamically allocated cnpSharp2 such as created
 * with cnpSharp2Load(). */
{
struct cnpSharp2 *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->variationType);
freez(pEl);
}

void cnpSharp2FreeList(struct cnpSharp2 **pList)
/* Free a list of dynamically allocated cnpSharp2's */
{
struct cnpSharp2 *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cnpSharp2Free(&el);
    }
*pList = NULL;
}

void cnpSharp2Output(struct cnpSharp2 *el, FILE *f, char sep, char lastSep) 
/* Print out cnpSharp2.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->variationType);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

