/* bed12wSeq.c was originally generated by the autoSql program, which also 
 * generated bed12wSeq.h and bed12wSeq.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bed12wSeq.h"


struct bed12wSeq *bed12wSeqLoad(char **row)
/* Load a bed12wSeq from row fetched with select * from bed12wSeq
 * from database.  Dispose of this with bed12wSeqFree(). */
{
struct bed12wSeq *ret;

AllocVar(ret);
ret->blockCount = sqlSigned(row[9]);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
safecpy(ret->strand, sizeof(ret->strand), row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->reserved = sqlUnsigned(row[8]);
{
int sizeOne;
sqlSignedDynamicArray(row[10], &ret->blockSizes, &sizeOne);
assert(sizeOne == ret->blockCount);
}
{
int sizeOne;
sqlSignedDynamicArray(row[11], &ret->chromStarts, &sizeOne);
assert(sizeOne == ret->blockCount);
}
ret->seq1 = cloneString(row[12]);
ret->seq2 = cloneString(row[13]);
return ret;
}

struct bed12wSeq *bed12wSeqLoadAll(char *fileName) 
/* Load all bed12wSeq from a whitespace-separated file.
 * Dispose of this with bed12wSeqFreeList(). */
{
struct bed12wSeq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileRow(lf, row))
    {
    el = bed12wSeqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bed12wSeq *bed12wSeqLoadAllByChar(char *fileName, char chopper) 
/* Load all bed12wSeq from a chopper separated file.
 * Dispose of this with bed12wSeqFreeList(). */
{
struct bed12wSeq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[14];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bed12wSeqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bed12wSeq *bed12wSeqLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all bed12wSeq from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with bed12wSeqFreeList(). */
{
struct bed12wSeq *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = bed12wSeqLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void bed12wSeqSaveToDb(struct sqlConnection *conn, struct bed12wSeq *el, char *tableName, int updateSize)
/* Save bed12wSeq as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use bed12wSeqSaveToDbEscaped() */
{
struct dyString *update = newDyString(updateSize);
char  *blockSizesArray, *chromStartsArray;
blockSizesArray = sqlSignedArrayToString(el->blockSizes, el->blockCount);
chromStartsArray = sqlSignedArrayToString(el->chromStarts, el->blockCount);
dyStringPrintf(update, "insert into %s values ( '%s',%u,%u,'%s',%u,'%s',%u,%u,%u,%d,'%s','%s','%s','%s')", 
	tableName,  el->chrom,  el->chromStart,  el->chromEnd,  el->name,  el->score,  el->strand,  el->thickStart,  el->thickEnd,  el->reserved,  el->blockCount,  blockSizesArray ,  chromStartsArray ,  el->seq1,  el->seq2);
sqlUpdate(conn, update->string);
freeDyString(&update);
freez(&blockSizesArray);
freez(&chromStartsArray);
}

void bed12wSeqSaveToDbEscaped(struct sqlConnection *conn, struct bed12wSeq *el, char *tableName, int updateSize)
/* Save bed12wSeq as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than bed12wSeqSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 
{
struct dyString *update = newDyString(updateSize);
char  *chrom, *name, *strand, *blockSizesArray, *chromStartsArray, *seq1, *seq2;
chrom = sqlEscapeString(el->chrom);
name = sqlEscapeString(el->name);
strand = sqlEscapeString(el->strand);
seq1 = sqlEscapeString(el->seq1);
seq2 = sqlEscapeString(el->seq2);

blockSizesArray = sqlSignedArrayToString(el->blockSizes, el->blockCount);
chromStartsArray = sqlSignedArrayToString(el->chromStarts, el->blockCount);
dyStringPrintf(update, "insert into %s values ( '%s',%u,%u,'%s',%u,'%s',%u,%u,%u,%d,'%s','%s','%s','%s')", 
	tableName,  chrom,  el->chromStart,  el->chromEnd,  name,  el->score,  strand,  el->thickStart,  el->thickEnd,  el->reserved,  el->blockCount,  blockSizesArray ,  chromStartsArray ,  seq1,  seq2);
sqlUpdate(conn, update->string);
freeDyString(&update);
freez(&chrom);
freez(&name);
freez(&strand);
freez(&blockSizesArray);
freez(&chromStartsArray);
freez(&seq1);
freez(&seq2);
}

struct bed12wSeq *bed12wSeqCommaIn(char **pS, struct bed12wSeq *ret)
/* Create a bed12wSeq out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bed12wSeq */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->reserved = sqlUnsignedComma(&s);
ret->blockCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->blockSizes, ret->blockCount);
for (i=0; i<ret->blockCount; ++i)
    {
    ret->blockSizes[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->chromStarts, ret->blockCount);
for (i=0; i<ret->blockCount; ++i)
    {
    ret->chromStarts[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
ret->seq1 = sqlStringComma(&s);
ret->seq2 = sqlStringComma(&s);
*pS = s;
return ret;
}

void bed12wSeqFree(struct bed12wSeq **pEl)
/* Free a single dynamically allocated bed12wSeq such as created
 * with bed12wSeqLoad(). */
{
struct bed12wSeq *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->blockSizes);
freeMem(el->chromStarts);
freeMem(el->seq1);
freeMem(el->seq2);
freez(pEl);
}

void bed12wSeqFreeList(struct bed12wSeq **pList)
/* Free a list of dynamically allocated bed12wSeq's */
{
struct bed12wSeq *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bed12wSeqFree(&el);
    }
*pList = NULL;
}

void bed12wSeqOutput(struct bed12wSeq *el, FILE *f, char sep, char lastSep) 
/* Print out bed12wSeq.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->reserved);
fputc(sep,f);
fprintf(f, "%d", el->blockCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->blockCount; ++i)
    {
    fprintf(f, "%d", el->blockSizes[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->blockCount; ++i)
    {
    fprintf(f, "%d", el->chromStarts[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->seq1);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->seq2);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

