/* agpGap.c was originally generated by the autoSql program, which also 
 * generated agpGap.h and agpGap.sql.  This module links the database and the RAM 
 * representation of objects. */

#include "common.h"
#include "jksql.h"
#include "agpGap.h"


void agpGapStaticLoad(char **row, struct agpGap *ret)
/* Load a row from agpGap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->ix = sqlSigned(row[3]);
strcpy(ret->n, row[4]);
ret->size = sqlUnsigned(row[5]);
ret->type = row[6];
ret->bridge = row[7];
}

struct agpGap *agpGapLoad(char **row)
/* Load a agpGap from row fetched with select * from agpGap
 * from database.  Dispose of this with agpGapFree(). */
{
struct agpGap *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->ix = sqlSigned(row[3]);
strcpy(ret->n, row[4]);
ret->size = sqlUnsigned(row[5]);
ret->type = cloneString(row[6]);
ret->bridge = cloneString(row[7]);
return ret;
}

struct agpGap *agpGapCommaIn(char **pS, struct agpGap *ret)
/* Create a agpGap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new agpGap */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->ix = sqlSignedComma(&s);
sqlFixedStringComma(&s, ret->n, sizeof(ret->n));
ret->size = sqlUnsignedComma(&s);
ret->type = sqlStringComma(&s);
ret->bridge = sqlStringComma(&s);
*pS = s;
return ret;
}

void agpGapFree(struct agpGap **pEl)
/* Free a single dynamically allocated agpGap such as created
 * with agpGapLoad(). */
{
struct agpGap *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->type);
freeMem(el->bridge);
freez(pEl);
}

void agpGapFreeList(struct agpGap **pList)
/* Free a list of dynamically allocated agpGap's */
{
struct agpGap *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    agpGapFree(&el);
    }
*pList = NULL;
}

void agpGapOutput(struct agpGap *el, FILE *f, char sep, char lastSep) 
/* Print out agpGap.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
fprintf(f, "%d", el->ix);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->n);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->size);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->bridge);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

