/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.config.spring;

import java.net.UnknownHostException;
import org.apache.ftpserver.DataConnectionConfiguration;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.config.spring.SpringUtil;
import org.apache.ftpserver.ipfilter.IpFilterType;
import org.apache.ftpserver.ipfilter.RemoteIpFilter;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ListenerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private final Logger LOG = LoggerFactory.getLogger(ListenerBeanDefinitionParser.class);

    protected Class<?> getBeanClass(Element element) {
        return null;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element remoteIpFilterElement;
        String localAddress;
        SslConfiguration ssl;
        BeanDefinitionBuilder factoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(ListenerFactory.class);
        if (StringUtils.hasText((String)element.getAttribute("port"))) {
            factoryBuilder.addPropertyValue("port", (Object)Integer.valueOf(element.getAttribute("port")));
        }
        if ((ssl = this.parseSsl(element)) != null) {
            factoryBuilder.addPropertyValue("sslConfiguration", (Object)ssl);
        }
        Element dataConElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "data-connection");
        DataConnectionConfiguration dc = this.parseDataConnection(dataConElm, ssl);
        factoryBuilder.addPropertyValue("dataConnectionConfiguration", (Object)dc);
        if (StringUtils.hasText((String)element.getAttribute("idle-timeout"))) {
            factoryBuilder.addPropertyValue("idleTimeout", (Object)SpringUtil.parseInt(element, "idle-timeout", 300));
        }
        if ((localAddress = SpringUtil.parseStringFromInetAddress(element, "local-address")) != null) {
            factoryBuilder.addPropertyValue("serverAddress", (Object)localAddress);
        }
        factoryBuilder.addPropertyValue("implicitSsl", (Object)SpringUtil.parseBoolean(element, "implicit-ssl", false));
        Element blacklistElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "blacklist");
        if (blacklistElm != null) {
            this.LOG.warn("Element 'blacklist' is deprecated, and may be removed in a future release. Please use 'remote-ip-filter' instead. ");
            try {
                RemoteIpFilter remoteIpFilter = new RemoteIpFilter(IpFilterType.DENY, blacklistElm.getTextContent());
                factoryBuilder.addPropertyValue("sessionFilter", (Object)remoteIpFilter);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid IP address or subnet in the 'blacklist' element", e);
            }
        }
        if ((remoteIpFilterElement = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "remote-ip-filter")) != null) {
            if (blacklistElm != null) {
                throw new FtpServerConfigurationException("Element 'remote-ip-filter' may not be used when 'blacklist' element is specified. ");
            }
            String filterType = remoteIpFilterElement.getAttribute("type");
            try {
                RemoteIpFilter remoteIpFilter = new RemoteIpFilter(IpFilterType.parse(filterType), remoteIpFilterElement.getTextContent());
                factoryBuilder.addPropertyValue("sessionFilter", (Object)remoteIpFilter);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid IP address or subnet in the 'remote-ip-filter' element");
            }
        }
        AbstractBeanDefinition factoryDefinition = factoryBuilder.getBeanDefinition();
        String listenerFactoryName = parserContext.getReaderContext().generateBeanName((BeanDefinition)factoryDefinition);
        BeanDefinitionHolder factoryHolder = new BeanDefinitionHolder((BeanDefinition)factoryDefinition, listenerFactoryName);
        this.registerBeanDefinition(factoryHolder, parserContext.getRegistry());
        builder.getRawBeanDefinition().setFactoryBeanName(listenerFactoryName);
        builder.getRawBeanDefinition().setFactoryMethodName("createListener");
    }

    private SslConfiguration parseSsl(Element parent) {
        Element sslElm = SpringUtil.getChildElement(parent, "http://mina.apache.org/ftpserver/spring/v1", "ssl");
        if (sslElm != null) {
            String protocol;
            String enabledCiphersuites;
            String clientAuthStr;
            Element trustStoreElm;
            SslConfigurationFactory ssl = new SslConfigurationFactory();
            Element keyStoreElm = SpringUtil.getChildElement(sslElm, "http://mina.apache.org/ftpserver/spring/v1", "keystore");
            if (keyStoreElm != null) {
                String algorithm;
                String keyPassword;
                String keyAlias;
                ssl.setKeystoreFile(SpringUtil.parseFile(keyStoreElm, "file"));
                ssl.setKeystorePassword(SpringUtil.parseString(keyStoreElm, "password"));
                String type = SpringUtil.parseString(keyStoreElm, "type");
                if (type != null) {
                    ssl.setKeystoreType(type);
                }
                if ((keyAlias = SpringUtil.parseString(keyStoreElm, "key-alias")) != null) {
                    ssl.setKeyAlias(keyAlias);
                }
                if ((keyPassword = SpringUtil.parseString(keyStoreElm, "key-password")) != null) {
                    ssl.setKeyPassword(keyPassword);
                }
                if ((algorithm = SpringUtil.parseString(keyStoreElm, "algorithm")) != null) {
                    ssl.setKeystoreAlgorithm(algorithm);
                }
            }
            if ((trustStoreElm = SpringUtil.getChildElement(sslElm, "http://mina.apache.org/ftpserver/spring/v1", "truststore")) != null) {
                String algorithm;
                ssl.setTruststoreFile(SpringUtil.parseFile(trustStoreElm, "file"));
                ssl.setTruststorePassword(SpringUtil.parseString(trustStoreElm, "password"));
                String type = SpringUtil.parseString(trustStoreElm, "type");
                if (type != null) {
                    ssl.setTruststoreType(type);
                }
                if ((algorithm = SpringUtil.parseString(trustStoreElm, "algorithm")) != null) {
                    ssl.setTruststoreAlgorithm(algorithm);
                }
            }
            if ((clientAuthStr = SpringUtil.parseString(sslElm, "client-authentication")) != null) {
                ssl.setClientAuthentication(clientAuthStr);
            }
            if ((enabledCiphersuites = SpringUtil.parseString(sslElm, "enabled-ciphersuites")) != null) {
                ssl.setEnabledCipherSuites(enabledCiphersuites.split(" "));
            }
            if ((protocol = SpringUtil.parseString(sslElm, "protocol")) != null) {
                ssl.setSslProtocol(protocol);
            }
            return ssl.createSslConfiguration();
        }
        return null;
    }

    private DataConnectionConfiguration parseDataConnection(Element element, SslConfiguration listenerSslConfiguration) {
        DataConnectionConfigurationFactory dc = new DataConnectionConfigurationFactory();
        if (element != null) {
            Element passiveElm;
            dc.setImplicitSsl(SpringUtil.parseBoolean(element, "implicit-ssl", false));
            SslConfiguration ssl = this.parseSsl(element);
            if (ssl != null) {
                this.LOG.debug("SSL configuration found for the data connection");
                dc.setSslConfiguration(ssl);
            }
            dc.setIdleTime(SpringUtil.parseInt(element, "idle-timeout", dc.getIdleTime()));
            Element activeElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "active");
            if (activeElm != null) {
                dc.setActiveEnabled(SpringUtil.parseBoolean(activeElm, "enabled", true));
                dc.setActiveIpCheck(SpringUtil.parseBoolean(activeElm, "ip-check", false));
                dc.setActiveLocalPort(SpringUtil.parseInt(activeElm, "local-port", 0));
                String localAddress = SpringUtil.parseStringFromInetAddress(activeElm, "local-address");
                if (localAddress != null) {
                    dc.setActiveLocalAddress(localAddress);
                }
            }
            if ((passiveElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "passive")) != null) {
                String ports;
                String externalAddress;
                String address = SpringUtil.parseStringFromInetAddress(passiveElm, "address");
                if (address != null) {
                    dc.setPassiveAddress(address);
                }
                if ((externalAddress = SpringUtil.parseStringFromInetAddress(passiveElm, "external-address")) != null) {
                    dc.setPassiveExternalAddress(externalAddress);
                }
                if ((ports = SpringUtil.parseString(passiveElm, "ports")) != null) {
                    dc.setPassivePorts(ports);
                }
                dc.setPassiveIpCheck(SpringUtil.parseBoolean(passiveElm, "ip-check", false));
            }
        } else if (listenerSslConfiguration != null) {
            this.LOG.debug("SSL configuration found for the listener, falling back for that for the data connection");
            dc.setSslConfiguration(listenerSslConfiguration);
        }
        return dc.createDataConnectionConfiguration();
    }
}

