/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.PrefPackage;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERCAntenna;
import com.sun.electric.tool.erc.ERCWellCheck;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.io.output.GenerateVHDL;
import com.sun.electric.tool.placement.Placement;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.sandbox.DummyPreferencesFactory;
import com.sun.electric.tool.sc.SilComp;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ComponentMenu;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.tool.user.ui.LayerVisibility;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PrefTest
extends AbstractTest {
    public PrefTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new PrefTest("Preferences"));
        list.add(new PrefTest("SettingsGroup"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Database/output/";
    }

    public Boolean Preferences() {
        Pref.forbidPreferences();
        boolean result2 = PrefTest.basicPrefTest(this.getRegressionPath());
        Pref.allowPreferences();
        return result2;
    }

    private static boolean basicPrefTest(String rootPath) {
        String trueRootPath = rootPath != null ? rootPath + "/tools/Database/" : "";
        String outputDir = trueRootPath + "output/";
        PrefTest.ensureOutputDirectory(outputDir);
        boolean good = false;
        try {
            TreeMap<String, String> m = new TreeMap<String, String>();
            for (Pref.Group group : Pref.getAllGroups()) {
                PrefTest.putPrefs(group, m);
            }
            TechPool techPool = TechPool.getThreadTechPool();
            PrefTest.putPrefs(new EditingPreferences(true, techPool), m, true);
            PrefTest.putPrefs(new GraphicsPreferences(true, techPool), m, true);
            PrefTest.putPrefs(new LayerVisibility(true), m, true);
            PrefTest.putPrefs(new ComponentMenu.ComponentMenuPreferences(true), m, true);
            PrefTest.putPrefs(new GenerateVHDL.VHDLPreferences(true), m, false);
            PrefTest.putPrefs(new DRC.DRCPreferences(true), m, true);
            PrefTest.putPrefs(new LayerCoverageTool.LayerCoveragePreferences(true), m, true);
            PrefTest.putPrefs(new SilComp.SilCompPrefs(true), m, false);
            PrefTest.putPrefs(new ERCWellCheck.WellCheckPreferences(true), m, false);
            PrefTest.putPrefs(new ERCAntenna.AntennaPreferences(true, techPool), m, true);
            PrefTest.putPrefs(new Placement.PlacementPreferences(true), m, false);
            PrefTest.putPrefs(new RoutingFrame.RoutingPrefs(true), m, false);
            String resultPrefs = outputDir + "AllPrefs.txt";
            HashSet<String> excludeSet = new HashSet<String>();
            excludeSet.addAll(Arrays.asList("tool/routing/AllNodesAsTargets", "tool/routing/CutFile", "tool/routing/MaxBadEdges", "tool/routing/MaxLapCount", "tool/routing/MaxPinCount", "tool/user/WorkingDirectory"));
            ArrayList<String> excludePrefix = new ArrayList<String>();
            excludePrefix.addAll(Arrays.asList("plugins/menus", "tool/io/FileTypeGroup"));
            PrintWriter out = new PrintWriter(resultPrefs);
            for (Map.Entry e : m.entrySet()) {
                String key = (String)e.getKey();
                if (excludeSet.contains(key) || key.startsWith("tool/user/ComponentMenuEntry")) continue;
                boolean exclude = false;
                for (String eKey : excludePrefix) {
                    if (!key.startsWith(eKey)) continue;
                    exclude = true;
                    break;
                }
                if (exclude) continue;
                out.println(e.toString());
            }
            out.close();
            String expectedPrefs = trueRootPath + "data/expected/AllPrefs.txt";
            good = PrefTest.compareResults(resultPrefs, expectedPrefs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return good;
    }

    private static void putPrefs(Pref.Group group, Map<String, String> m) {
        for (Pref pref : group.getPrefs()) {
            String old = m.put(pref.getPrefPath(), pref.getFactoryValue().toString());
            assert (old == null);
        }
    }

    private static void putPrefs(PrefPackage pp, Map<String, String> m, boolean skipNonstandardTechs) throws BackingStoreException {
        Preferences root = new DummyPreferencesFactory().userRoot();
        root.clear();
        for (String child : root.childrenNames()) {
            root.node(child).removeNode();
        }
        PrefPackage.lowLevelPutPrefs(pp, root, false);
        PrefTest.putPrefs(root, m, skipNonstandardTechs);
    }

    private static void putPrefs(Preferences p, Map<String, String> m, boolean skipNonstandardTechs) throws BackingStoreException {
        assert (p.absolutePath().charAt(0) == '/');
        String relativePath = p.absolutePath().substring(1) + "/";
        for (String key : p.keys()) {
            String entry = relativePath + key;
            if (skipNonstandardTechs) {
                List<String> sensitiveTechNames = TechFactory.getSensitiveTechNames();
                boolean sensitive = false;
                for (String stn : sensitiveTechNames) {
                    String poss1 = "In" + stn;
                    String poss2 = "IN" + stn;
                    String poss3 = "for" + stn;
                    String poss4 = "For" + stn;
                    if (entry.indexOf(poss1) < 0 && entry.indexOf(poss2) < 0 && entry.indexOf(poss3) < 0 && entry.indexOf(poss4) < 0) continue;
                    sensitive = true;
                    break;
                }
                if (sensitive) continue;
            }
            String old = m.put(entry, p.get(key, null));
            assert (old == null);
        }
        for (String child : p.childrenNames()) {
            PrefTest.putPrefs(p.node(child), m, skipNonstandardTechs);
        }
    }

    public Boolean SettingsGroup() {
        for (Setting setting : this.getDatabase().getSettings().keySet()) {
            Setting s2;
            String xmlPath = setting.getXmlPath();
            int pos = xmlPath.indexOf(46);
            String pathHead = xmlPath.substring(0, pos + 1);
            String pathTail = xmlPath.substring(pos + 1);
            int n = 0;
            Iterator<Comparable> it = Tool.getTools();
            while (it.hasNext()) {
                Tool tool = it.next();
                if (!pathHead.equals(tool.getProjectSettings().getXmlPath()) || (s2 = tool.getProjectSettings().getSetting(pathTail)) == null) continue;
                if (s2 != setting) {
                    System.out.println("ERROR: Setting duplicate: " + xmlPath);
                    return Boolean.FALSE;
                }
                ++n;
            }
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology tech = (Technology)it.next();
                if (!pathHead.equals(tech.getProjectSettings().getXmlPath()) || (s2 = tech.getProjectSettings().getSetting(pathTail)) == null) continue;
                if (s2 != setting) {
                    System.out.println("ERROR: Setting duplicate: " + xmlPath);
                    return Boolean.FALSE;
                }
                ++n;
            }
            if (n <= true) continue;
            System.out.println("ERROR: Setting count " + xmlPath + " is " + n);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

