/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellRevisionProviderDefault;
import com.sun.electric.database.CellUsageInfo;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.util.collections.ArrayIterator;
import com.sun.electric.util.collections.ImmutableArrayList;
import com.sun.electric.util.collections.ImmutableList;
import com.sun.electric.util.memory.ObjSize;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CellRevisionConn0
extends CellRevision {
    private static final int LOW_BITS = 6;
    private static final int LOW_SIZE = 64;
    private static final int LOW_MASK = 63;
    private static final Object[] emptyBlock = new Object[64];
    private static final Object[][] emptyBlocks = new Object[0][];
    private volatile SoftReference<Object[][]> nodeConnectionsRef = new SoftReference<Object>(null);
    private static final Comparator<ImmutableExport> ExpComparator = new Comparator<ImmutableExport>(){

        @Override
        public int compare(ImmutableExport e1, ImmutableExport e2) {
            assert (e1.originalNodeId == e2.originalNodeId);
            if (e1.originalPortId.chronIndex < e2.originalPortId.chronIndex) {
                return -1;
            }
            if (e1.originalPortId.chronIndex > e2.originalPortId.chronIndex) {
                return 1;
            }
            if (e1.exportId.chronIndex < e2.exportId.chronIndex) {
                return -1;
            }
            if (e1.exportId.chronIndex > e2.exportId.chronIndex) {
                return 1;
            }
            return 0;
        }
    };

    private CellRevisionConn0(ImmutableCell d, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        super(d, nodes, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
    }

    private CellRevisionConn0(ImmutableCell d) {
        this(d, CellRevision.getProvider().createNodeList(ImmutableNodeInst.NULL_ARRAY, null), CellRevision.getProvider().createArcList(ImmutableArcInst.NULL_ARRAY, null), CellRevision.NULL_INT_ARRAY, CellRevision.getProvider().createExportList(ImmutableExport.NULL_ARRAY, null), CellRevision.NULL_INT_ARRAY, CellRevision.makeTechUsages(d.techId), CellRevision.NULL_CELL_USAGE_INFO_ARRAY, CellRevision.EMPTY_BITSET, 0, CellRevision.EMPTY_BITSET);
        if (d.techId == null) {
            throw new NullPointerException("techId");
        }
    }

    @Override
    public boolean hasConnectionsOnNode(ImmutableNodeInst n) {
        Object nodeInfo = this.getNodeInfo(n);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).hasConnectionsOnNode();
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            return true;
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).hasConnections();
        }
        return false;
    }

    @Override
    public int getNumConnectionsOnNode(ImmutableNodeInst n) {
        Object nodeInfo = this.getNodeInfo(n);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getNumConnectionsOnNode();
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            return 1;
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).getNumConnections();
        }
        return 0;
    }

    @Override
    public List<ImmutableArcInst> getConnectionsOnNode(BitSet headEnds, ImmutableNodeInst n) {
        Object nodeInfo = this.getNodeInfo(n);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getConnectionsOnNode(headEnds);
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            ImmutableArcInst a = (ImmutableArcInst)nodeInfo;
            if (headEnds != null) {
                headEnds.clear();
                if (a.headNodeId == n.nodeId) {
                    assert (a.headPortId.externalId.isEmpty());
                    headEnds.set(0);
                } else assert (a.tailNodeId == n.nodeId);
            }
            return Collections.singletonList(a);
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).getConnections(headEnds, n.nodeId, n.protoId.newPortId(""));
        }
        if (headEnds != null) {
            headEnds.clear();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasConnectionsOnPort(ImmutableNodeInst n, PortProtoId portId) {
        if (portId.parentId != n.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(n);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).hasConnectionsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            return portId.externalId.isEmpty();
        }
        if (nodeInfo instanceof PortConns) {
            return portId.externalId.isEmpty() && ((PortConns)nodeInfo).hasConnections();
        }
        return false;
    }

    @Override
    public int getNumConnectionsOnPort(ImmutableNodeInst n, PortProtoId portId) {
        if (portId.parentId != n.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(n);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getNumConnectionsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            return portId.externalId.isEmpty() ? 1 : 0;
        }
        if (nodeInfo instanceof PortConns) {
            return portId.externalId.isEmpty() ? ((PortConns)nodeInfo).getNumConnections() : 0;
        }
        return 0;
    }

    @Override
    public List<ImmutableArcInst> getConnectionsOnPort(BitSet headEnds, ImmutableNodeInst n, PortProtoId portId) {
        if (portId.parentId != n.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(n);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getConnectionsOnPort(headEnds, portId);
        }
        if (nodeInfo instanceof ImmutableArcInst) {
            ImmutableArcInst a = (ImmutableArcInst)nodeInfo;
            if (portId.externalId.isEmpty()) {
                if (headEnds != null) {
                    headEnds.clear();
                    if (a.headNodeId == n.nodeId) {
                        assert (a.headPortId == portId);
                        assert (a.tailNodeId != n.nodeId);
                        headEnds.set(0);
                    } else {
                        assert (a.tailNodeId == n.nodeId);
                        assert (a.tailPortId == portId);
                        assert (a.headNodeId != n.nodeId);
                    }
                }
                return Collections.singletonList(a);
            }
        } else if (nodeInfo instanceof PortConns) {
            PortConns pc = (PortConns)nodeInfo;
            if (portId.externalId.isEmpty()) {
                return pc.getConnections(headEnds, n.nodeId, portId);
            }
        }
        if (headEnds != null) {
            headEnds.clear();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasExportsOnNode(ImmutableNodeInst originalNode) {
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).hasExportsOnNode();
        }
        if (nodeInfo instanceof ImmutableExport) {
            return true;
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).hasExportsOnPort();
        }
        return false;
    }

    @Override
    public int getNumExportsOnNode(ImmutableNodeInst originalNode) {
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getNumExportsOnNode();
        }
        if (nodeInfo instanceof ImmutableExport) {
            return 1;
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).getNumExportsOnPort();
        }
        return 0;
    }

    @Override
    public Iterator<ImmutableExport> getExportsOnNode(ImmutableNodeInst originalNode) {
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getExportsOnNode();
        }
        if (nodeInfo instanceof ImmutableExport) {
            return ArrayIterator.singletonIterator((ImmutableExport)nodeInfo);
        }
        if (nodeInfo instanceof PortConns) {
            return ((PortConns)nodeInfo).getExportsOnPort();
        }
        return ArrayIterator.emptyIterator();
    }

    @Override
    public boolean hasExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        if (portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).hasExportsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableExport) {
            return portId.externalId.isEmpty();
        }
        if (nodeInfo instanceof PortConns) {
            return portId.externalId.isEmpty() && ((PortConns)nodeInfo).hasExportsOnPort();
        }
        return false;
    }

    @Override
    public int getNumExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        if (portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getNumExportsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableExport) {
            return portId.externalId.isEmpty() ? 1 : 0;
        }
        if (nodeInfo instanceof PortConns) {
            return portId.externalId.isEmpty() ? ((PortConns)nodeInfo).getNumExportsOnPort() : 0;
        }
        return 0;
    }

    @Override
    public Iterator<ImmutableExport> getExportsOnPort(ImmutableNodeInst originalNode, PortProtoId portId) {
        if (portId.parentId != originalNode.protoId) {
            throw new IllegalArgumentException();
        }
        Object nodeInfo = this.getNodeInfo(originalNode);
        if (nodeInfo instanceof NodeConnections) {
            return ((NodeConnections)nodeInfo).getExportsOnPort(portId);
        }
        if (nodeInfo instanceof ImmutableExport) {
            if (portId.externalId.isEmpty()) {
                return ArrayIterator.singletonIterator((ImmutableExport)nodeInfo);
            }
        } else if (nodeInfo instanceof PortConns && portId.externalId.isEmpty()) {
            return ((PortConns)nodeInfo).getExportsOnPort();
        }
        return ArrayIterator.emptyIterator();
    }

    private Object getNodeInfo(ImmutableNodeInst n) {
        int nodeId = n.nodeId;
        if (this.getNodeById(nodeId) != n) {
            throw new IllegalArgumentException();
        }
        Object[][] connections = this.nodeConnectionsRef.get();
        if (connections != null) {
            return connections[nodeId >> 6][nodeId & 0x3F];
        }
        return this.makeNodeInfo(nodeId);
    }

    private Object makeNodeInfo(int nodeId) {
        BlockBuffer[] blockBuffers = CellRevisionConn0.allocBlockBuffers(this.getMaxNodeId());
        for (ImmutableArcInst a : this.arcs) {
            CellRevisionConn0.newArc(blockBuffers, a);
        }
        for (ImmutableExport e : this.exports) {
            CellRevisionConn0.newExport(blockBuffers, e);
        }
        return this.updateBlocks(null, blockBuffers, emptyBlocks)[nodeId >> 6][nodeId & 0x3F];
    }

    private static void putKilled(BlockBuffer[] blockBuffers, Map<Integer, List<ImmutableElectricObject>> killedConnectivity, CellRevisionConn0 newCellRevision, int nodeId, ImmutableElectricObject obj) {
        BlockBuffer buf = CellRevisionConn0.getBuffer(blockBuffers, nodeId);
        if (newCellRevision.getNodeById(nodeId) != null) {
            List<ImmutableElectricObject> list = killedConnectivity.get(nodeId);
            if (list == null) {
                list = new ArrayList<ImmutableElectricObject>();
                killedConnectivity.put(nodeId, list);
            }
            list.add(obj);
            buf.hasKilledObjs = true;
        }
    }

    @Override
    CellRevision lowLevelWith(ImmutableCell d, ImmutableNodeInst.Iterable nodes, ImmutableArcInst.Iterable arcs, int[] arcIndex, ImmutableExport.Iterable exports, int[] exportIndex, BitSet techUsages, CellUsageInfo[] cellUsages, BitSet definedExports, int definedExportsLength, BitSet deletedExports) {
        CellRevisionConn0 newCellRevision = new CellRevisionConn0(d, nodes, arcs, arcIndex, exports, exportIndex, techUsages, cellUsages, definedExports, definedExportsLength, deletedExports);
        Object[][] oldBlocks = this.nodeConnectionsRef.get();
        if (oldBlocks != null && d.cellId == this.d.cellId) {
            HashMap<Integer, List<ImmutableElectricObject>> killedConnectivity = new HashMap<Integer, List<ImmutableElectricObject>>();
            int maxNodeId = newCellRevision.getMaxNodeId();
            BlockBuffer[] blockBuffers = CellRevisionConn0.allocBlockBuffers(maxNodeId);
            int maxArcId = Math.max(this.getMaxArcId(), newCellRevision.getMaxArcId());
            for (int arcId = 0; arcId <= maxArcId; ++arcId) {
                ImmutableArcInst newA;
                ImmutableArcInst oldA = this.getArcById(arcId);
                if (oldA == (newA = newCellRevision.getArcById(arcId))) continue;
                if (oldA != null) {
                    CellRevisionConn0.putKilled(blockBuffers, killedConnectivity, newCellRevision, oldA.tailNodeId, oldA);
                    if (oldA.headNodeId != oldA.tailNodeId) {
                        CellRevisionConn0.putKilled(blockBuffers, killedConnectivity, newCellRevision, oldA.headNodeId, oldA);
                    }
                }
                CellRevisionConn0.newArc(blockBuffers, newA);
            }
            int maxChronIndex = Math.max(this.getMaxExportChronIndex(), newCellRevision.getMaxExportChronIndex());
            CellId cellId = d.cellId;
            assert (newCellRevision.d.cellId == cellId);
            for (int chronIndex = 0; chronIndex <= maxChronIndex; ++chronIndex) {
                ImmutableExport newE;
                ExportId exportId = cellId.getPortId(chronIndex);
                ImmutableExport oldE = this.getExport(exportId);
                if (oldE == (newE = newCellRevision.getExport(exportId))) continue;
                if (oldE != null) {
                    CellRevisionConn0.putKilled(blockBuffers, killedConnectivity, newCellRevision, oldE.originalNodeId, oldE);
                }
                CellRevisionConn0.newExport(blockBuffers, newE);
            }
            newCellRevision.updateBlocks(killedConnectivity, blockBuffers, oldBlocks);
        }
        return newCellRevision;
    }

    private Object[][] updateBlocks(Map<Integer, List<ImmutableElectricObject>> killedConnectivity, BlockBuffer[] blockBuffers, Object[][] oldBlocks) {
        Object[][] newBlocks = new Object[blockBuffers.length][];
        for (int bi = 0; bi < newBlocks.length; ++bi) {
            Object[] oldBlock = bi < oldBlocks.length ? oldBlocks[bi] : emptyBlock;
            BlockBuffer bb = blockBuffers[bi];
            if (bb == null) {
                newBlocks[bi] = oldBlock;
                continue;
            }
            Object[] newBlock = new Object[64];
            boolean newBlockIsEmpty = true;
            for (int i = 0; i < 64; ++i) {
                HashSet<ImmutableElectricObject> killed;
                ImmutableNodeInst n;
                int nodeId = (bi << 6) + i;
                Object nodeInfo = oldBlock[i];
                ImmutableList newObjs = bb.newObjs[i];
                List<ImmutableElectricObject> killedList = null;
                if (bb.hasKilledObjs) {
                    killedList = killedConnectivity.get(nodeId);
                }
                if ((n = this.getNodeById(nodeId)) == null) continue;
                if (newObjs == null && killedList == null) {
                    if (nodeInfo != null) {
                        newBlockIsEmpty = false;
                    }
                    newBlock[i] = nodeInfo;
                    continue;
                }
                ArrayList<Integer> newCons = new ArrayList<Integer>();
                ArrayList<ImmutableExport> newExports = new ArrayList<ImmutableExport>();
                HashSet<ImmutableElectricObject> hashSet = killed = killedList != null ? new HashSet<ImmutableElectricObject>(killedList) : Collections.emptySet();
                if (nodeInfo instanceof NodeConnections) {
                    NodeConnections nc = (NodeConnections)nodeInfo;
                    ImmutableArcInst[] arcs = nc.getArcs();
                    BitSet arcEnds = nc.getArcEnds();
                    for (int connIndex = 0; connIndex < arcs.length; ++connIndex) {
                        ImmutableArcInst a = arcs[connIndex];
                        if (killed.contains(a)) continue;
                        int arcId = a.arcId;
                        newCons.add(arcEnds.get(connIndex) ? arcId << 1 | 1 : arcId << 1);
                    }
                    for (ImmutableExport e : nc.getExports()) {
                        if (killed.contains(e)) continue;
                        newExports.add(e);
                    }
                } else if (nodeInfo instanceof ImmutableArcInst) {
                    ImmutableArcInst a = (ImmutableArcInst)nodeInfo;
                    if (killed.isEmpty()) {
                        int arcId = a.arcId;
                        boolean end = a.headNodeId == nodeId && a.headPortId.externalId.isEmpty();
                        newCons.add(end ? arcId << 1 | 1 : arcId << 1);
                    } else assert (killed.contains(a) && killed.size() == 1);
                } else if (nodeInfo instanceof ImmutableExport) {
                    ImmutableExport e = (ImmutableExport)nodeInfo;
                    if (killed.isEmpty()) {
                        newExports.add(e);
                    } else assert (killed.contains(e) && killed.size() == 1);
                } else if (nodeInfo instanceof PortConns) {
                    PortConns pc = (PortConns)nodeInfo;
                    if (pc.hasConnections()) {
                        BitSet arcHeads = new BitSet();
                        List<ImmutableArcInst> arcs = pc.getConnections(arcHeads, nodeId, n.protoId.newPortId(""));
                        for (int connIndex = 0; connIndex < arcs.size(); ++connIndex) {
                            ImmutableArcInst a = arcs.get(connIndex);
                            if (killed.contains(a)) continue;
                            int arcId = a.arcId;
                            newCons.add(arcHeads.get(connIndex) ? arcId << 1 | 1 : arcId << 1);
                        }
                    }
                    if (pc.hasExportsOnPort()) {
                        Iterator<ImmutableExport> eit = pc.getExportsOnPort();
                        while (eit.hasNext()) {
                            ImmutableExport e = eit.next();
                            if (killed.contains(e)) continue;
                            newExports.add(e);
                        }
                    }
                } else assert (nodeInfo == null);
                while (newObjs != null) {
                    ImmutableElectricObject o = (ImmutableElectricObject)newObjs.getFirst();
                    if (o instanceof ImmutableArcInst) {
                        ImmutableArcInst a = (ImmutableArcInst)o;
                        if (a.tailNodeId == nodeId) {
                            newCons.add(a.arcId << 1);
                        }
                        if (a.headNodeId == nodeId) {
                            newCons.add(a.arcId << 1 | 1);
                        }
                    } else if (o instanceof ImmutableExport) {
                        newExports.add((ImmutableExport)o);
                    }
                    newObjs = newObjs.getTail();
                }
                boolean onEmptyPort = true;
                boolean withoutLoops = true;
                Object newNodeInfo = null;
                if (!newCons.isEmpty() || !newExports.isEmpty()) {
                    ImmutableExport[] bExports;
                    BitSet bArcHeads;
                    ImmutableArcInst[] bArcs;
                    newBlockIsEmpty = false;
                    if (newCons.isEmpty()) {
                        bArcs = ImmutableArcInst.NULL_ARRAY;
                        bArcHeads = CellRevision.EMPTY_BITSET;
                    } else if (newCons.size() == 1) {
                        int con = (Integer)newCons.get(0);
                        ImmutableArcInst a = this.getArcById(con >> 1);
                        boolean bl = withoutLoops = withoutLoops && (a.tailNodeId != a.headNodeId || a.tailPortId != a.headPortId);
                        if ((con & 1) != 0) {
                            onEmptyPort = onEmptyPort && a.headPortId.externalId.isEmpty();
                            bArcHeads = new BitSet();
                            bArcHeads.set(0);
                            bArcs = new ImmutableArcInst[]{a};
                        } else {
                            onEmptyPort = onEmptyPort && a.tailPortId.externalId.isEmpty();
                            bArcs = new ImmutableArcInst[]{a};
                            bArcHeads = CellRevision.EMPTY_BITSET;
                        }
                    } else {
                        Collections.sort(newCons, new ConComparator());
                        ImmutableArcInst[] arr = new ImmutableArcInst[newCons.size()];
                        BitSet bs = new BitSet();
                        for (int j = 0; j < newCons.size(); ++j) {
                            ImmutableArcInst a;
                            int con = (Integer)newCons.get(j);
                            arr[j] = a = this.getArcById(con >> 1);
                            boolean bl = withoutLoops = withoutLoops && (a.tailNodeId != a.headNodeId || a.tailPortId != a.headPortId);
                            if ((con & 1) != 0) {
                                bs.set(j);
                                onEmptyPort = onEmptyPort && a.headPortId.externalId.isEmpty();
                                continue;
                            }
                            onEmptyPort = onEmptyPort && a.tailPortId.externalId.isEmpty();
                        }
                        bArcs = arr;
                        BitSet bitSet = bArcHeads = bs.isEmpty() ? CellRevision.EMPTY_BITSET : bs;
                    }
                    if (newExports.isEmpty()) {
                        bExports = ImmutableExport.NULL_ARRAY;
                    } else if (newExports.size() == 1) {
                        ImmutableExport e;
                        e = (ImmutableExport)newExports.get(0);
                        onEmptyPort = onEmptyPort && e.originalPortId.externalId.isEmpty();
                        bExports = new ImmutableExport[]{e};
                    } else {
                        Collections.sort(newExports, ExpComparator);
                        for (ImmutableExport e : newExports) {
                            onEmptyPort = onEmptyPort && e.originalPortId.externalId.isEmpty();
                        }
                        bExports = newExports.toArray(ImmutableExport.NULL_ARRAY);
                    }
                    if (!onEmptyPort) {
                        newNodeInfo = new NodeConnections(bArcs, bArcHeads, bExports);
                    } else if (withoutLoops) {
                        block0 : switch (bExports.length) {
                            case 0: {
                                switch (bArcs.length) {
                                    case 1: {
                                        newNodeInfo = bArcs[0];
                                        break block0;
                                    }
                                    case 2: {
                                        newNodeInfo = new PortConA2E0(bArcs[0], bArcs[1]);
                                        break block0;
                                    }
                                    case 3: {
                                        newNodeInfo = new PortConA3E0(bArcs[0], bArcs[1], bArcs[2]);
                                        break block0;
                                    }
                                }
                                newNodeInfo = new PortConANE0(bArcs);
                                break;
                            }
                            case 1: {
                                switch (bArcs.length) {
                                    case 0: {
                                        newNodeInfo = bExports[0];
                                        break block0;
                                    }
                                    case 1: {
                                        newNodeInfo = new PortConA1E1(bArcs[0], bExports[0]);
                                        break block0;
                                    }
                                    case 2: {
                                        newNodeInfo = new PortConA2E1(bArcs[0], bArcs[1], bExports[0]);
                                        break block0;
                                    }
                                    case 3: {
                                        newNodeInfo = new PortConA3E1(bArcs[0], bArcs[1], bArcs[2], bExports[0]);
                                        break block0;
                                    }
                                }
                                newNodeInfo = new PortConANE1(bArcs, bExports[0]);
                                break;
                            }
                            default: {
                                newNodeInfo = new PortConANEN(bArcs, bExports);
                                break;
                            }
                        }
                    } else {
                        newNodeInfo = new PortConALEN(bArcs, bArcHeads, bExports);
                    }
                }
                newBlock[i] = newNodeInfo;
            }
            newBlocks[bi] = newBlockIsEmpty ? emptyBlock : newBlock;
        }
        this.nodeConnectionsRef = new SoftReference<Object[][]>(newBlocks);
        return newBlocks;
    }

    private static BlockBuffer[] allocBlockBuffers(int maxNodeId) {
        return new BlockBuffer[(maxNodeId >> 6) + 1];
    }

    private static void newArc(BlockBuffer[] blockBuffers, ImmutableArcInst newA) {
        if (newA != null) {
            CellRevisionConn0.getBuffer(blockBuffers, newA.tailNodeId).putObj(newA.tailNodeId, newA);
            if (newA.headNodeId != newA.tailNodeId) {
                CellRevisionConn0.getBuffer(blockBuffers, newA.headNodeId).putObj(newA.headNodeId, newA);
            }
        }
    }

    private static void newExport(BlockBuffer[] blockBuffers, ImmutableExport newE) {
        if (newE != null) {
            CellRevisionConn0.getBuffer(blockBuffers, newE.originalNodeId).putObj(newE.originalNodeId, newE);
        }
    }

    private static BlockBuffer getBuffer(BlockBuffer[] blockBuffers, int nodeId) {
        BlockBuffer newB;
        int bi = nodeId >> 6;
        BlockBuffer b = blockBuffers[bi];
        if (b != null) {
            return b;
        }
        blockBuffers[bi] = newB = new BlockBuffer();
        return newB;
    }

    @Override
    public long getConnectivityMemorySize(ObjSize objSize, boolean restore) {
        Object[][] connections;
        long s2 = 0L;
        if (restore && !this.nodes.isEmpty()) {
            this.makeNodeInfo(0);
        }
        if ((connections = this.nodeConnectionsRef.get()) != null) {
            s2 += objSize.sizeOf(connections);
            for (Object[] block : connections) {
                if (block == emptyBlock) continue;
                s2 += objSize.sizeOf(block);
                for (Object nodeInfo : block) {
                    if (nodeInfo instanceof NodeConnections) {
                        s2 += ((NodeConnections)nodeInfo).getMemorySize(objSize);
                        continue;
                    }
                    if (!(nodeInfo instanceof PortConns)) continue;
                    s2 += ((PortConns)nodeInfo).getMemorySize(objSize);
                }
            }
        }
        return s2;
    }

    @Override
    public void check() {
        super.check();
        Object[][] blocks = this.nodeConnectionsRef.get();
        if (blocks == null) {
            return;
        }
        assert (blocks.length == (this.getMaxNodeId() >> 6) + 1);
        for (int bi = 0; bi < blocks.length; ++bi) {
            Object[] b = blocks[bi];
            if (b == emptyBlock) continue;
            boolean nonNull = false;
            for (int i = 0; i < 64; ++i) {
                Object nodeInfo = b[i];
                if (nodeInfo == null) continue;
                int nodeId = (bi << 6) + i;
                ImmutableNodeInst n = this.getNodeById(nodeId);
                assert (n != null);
                nonNull = true;
                if (nodeInfo instanceof NodeConnections) {
                    NodeConnections nc = (NodeConnections)nodeInfo;
                    nc.check(n);
                    continue;
                }
                if (nodeInfo instanceof ImmutableArcInst) {
                    ImmutableArcInst a = (ImmutableArcInst)nodeInfo;
                    assert (a.tailNodeId == nodeId && a.headNodeId != nodeId && a.tailPortId.parentId == n.protoId && a.tailPortId.externalId.isEmpty() || a.headNodeId == nodeId && a.tailNodeId != nodeId && a.headPortId.parentId == n.protoId && a.headPortId.externalId.isEmpty());
                    continue;
                }
                if (nodeInfo instanceof ImmutableExport) {
                    ImmutableExport e = (ImmutableExport)nodeInfo;
                    assert (e.originalNodeId == nodeId && e.originalPortId.parentId == n.protoId && e.originalPortId.externalId.isEmpty());
                    continue;
                }
                if (nodeInfo instanceof PortConns) {
                    PortConns pc = (PortConns)nodeInfo;
                    pc.check(n);
                    continue;
                }
                assert (false);
            }
            assert (nonNull);
        }
        this.checkConnectivity();
    }

    private static void checkArcs(ImmutableArcInst[] arcs, BitSet arcEnds, ImmutableNodeInst n, PortProtoId checkPortId) {
        if (checkPortId != null) assert (checkPortId.parentId == n.protoId);
        for (int connIndex = 0; connIndex < arcs.length; ++connIndex) {
            PortProtoId oldPortId;
            PortProtoId portId;
            ImmutableArcInst a = arcs[connIndex];
            boolean end = arcEnds.get(connIndex);
            if (end) {
                assert (a.headNodeId == n.nodeId);
                portId = a.headPortId;
            } else {
                assert (a.tailNodeId == n.nodeId);
                portId = a.tailPortId;
            }
            assert (checkPortId == null ? portId.parentId == n.protoId : portId == checkPortId);
            if (connIndex <= 0) continue;
            ImmutableArcInst oldA = arcs[connIndex - 1];
            boolean oldEnd = arcEnds.get(connIndex - 1);
            PortProtoId portProtoId = oldPortId = oldEnd ? oldA.headPortId : oldA.tailPortId;
            assert (oldPortId.chronIndex <= portId.chronIndex);
            if (oldPortId.chronIndex != portId.chronIndex) continue;
            assert (oldA.arcId <= a.arcId);
            if (oldA.arcId == a.arcId) assert (!oldEnd && end);
        }
    }

    private static class PortConALEN
    extends PortConns {
        private final ImmutableArcInst[] arcs;
        private final BitSet arcEnds;
        private final ImmutableExport[] exports;

        private PortConALEN(ImmutableArcInst[] arcs, BitSet arcEnds, ImmutableExport[] exports) {
            assert (arcs.length > 0);
            this.arcs = arcs;
            this.arcEnds = arcEnds;
            this.exports = exports;
        }

        @Override
        List<ImmutableArcInst> getConnections(BitSet headEnds, int nodeId, PortProtoId portId) {
            assert (portId.externalId.isEmpty());
            if (headEnds != null) {
                headEnds.clear();
                headEnds.or(this.arcEnds);
            }
            return this.getConnections();
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(this.arcs);
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return this.arcs.length;
        }

        @Override
        boolean hasExportsOnPort() {
            return this.exports.length != 0;
        }

        @Override
        int getNumExportsOnPort() {
            return this.exports.length;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.iterator(this.exports);
        }

        @Override
        long getMemorySize(ObjSize objSize) {
            long s2 = super.getMemorySize(objSize);
            if (this.arcs != ImmutableArcInst.NULL_ARRAY) {
                s2 += objSize.sizeOf(this.arcs);
            }
            s2 += CellRevision.sizeOfBitSet(objSize, this.arcEnds);
            if (this.exports != ImmutableExport.NULL_ARRAY) {
                s2 += objSize.sizeOf(this.exports);
            }
            return s2;
        }

        @Override
        void checkArcs(ImmutableNodeInst n) {
            CellRevisionConn0.checkArcs(this.arcs, this.arcEnds, n, n.protoId.newPortId(""));
        }
    }

    private static class PortConANEN
    extends PortConns {
        private final ImmutableArcInst[] arcs;
        private final ImmutableExport[] exports;

        private PortConANEN(ImmutableArcInst[] arcs, ImmutableExport[] exports) {
            assert (exports.length > 0);
            this.arcs = arcs;
            this.exports = exports;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(this.arcs);
        }

        @Override
        boolean hasConnections() {
            return this.arcs.length > 0;
        }

        @Override
        int getNumConnections() {
            return this.arcs.length;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return this.exports.length;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.iterator(this.exports);
        }

        @Override
        long getMemorySize(ObjSize objSize) {
            long s2 = super.getMemorySize(objSize);
            if (this.arcs != ImmutableArcInst.NULL_ARRAY) {
                s2 += objSize.sizeOf(this.arcs);
            }
            if (this.exports != ImmutableExport.NULL_ARRAY) {
                s2 += objSize.sizeOf(this.exports);
            }
            return s2;
        }
    }

    private static class PortConANE1
    extends PortConns {
        private final ImmutableArcInst[] arcs;
        private final ImmutableExport e;

        private PortConANE1(ImmutableArcInst[] arcs, ImmutableExport e) {
            assert (arcs.length > 0);
            this.arcs = arcs;
            this.e = e;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(this.arcs);
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return this.arcs.length;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return 1;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.singletonIterator(this.e);
        }

        @Override
        long getMemorySize(ObjSize objSize) {
            assert (this.arcs.length > 0);
            return super.getMemorySize(objSize) + objSize.sizeOf(this.arcs);
        }
    }

    private static class PortConA3E1
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableArcInst a1;
        private final ImmutableArcInst a2;
        private final ImmutableExport e;

        private PortConA3E1(ImmutableArcInst a0, ImmutableArcInst a1, ImmutableArcInst a2, ImmutableExport e) {
            this.a0 = a0;
            this.a1 = a1;
            this.a2 = a2;
            this.e = e;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(new ImmutableArcInst[]{this.a0, this.a1, this.a2});
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 3;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return 1;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.singletonIterator(this.e);
        }
    }

    private static class PortConA2E1
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableArcInst a1;
        private final ImmutableExport e;

        private PortConA2E1(ImmutableArcInst a0, ImmutableArcInst a1, ImmutableExport e) {
            this.a0 = a0;
            this.a1 = a1;
            this.e = e;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(new ImmutableArcInst[]{this.a0, this.a1});
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 2;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return 1;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.singletonIterator(this.e);
        }
    }

    private static class PortConA1E1
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableExport e;

        private PortConA1E1(ImmutableArcInst a0, ImmutableExport e) {
            this.a0 = a0;
            this.e = e;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return Collections.singletonList(this.a0);
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 1;
        }

        @Override
        boolean hasExportsOnPort() {
            return true;
        }

        @Override
        int getNumExportsOnPort() {
            return 1;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.singletonIterator(this.e);
        }
    }

    private static class PortConANE0
    extends PortConns {
        private final ImmutableArcInst[] arcs;

        PortConANE0(ImmutableArcInst[] arcs) {
            assert (arcs.length > 0);
            this.arcs = arcs;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(this.arcs);
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return this.arcs.length;
        }

        @Override
        boolean hasExportsOnPort() {
            return false;
        }

        @Override
        int getNumExportsOnPort() {
            return 0;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.emptyIterator();
        }

        @Override
        long getMemorySize(ObjSize objSize) {
            assert (this.arcs.length > 0);
            return super.getMemorySize(objSize) + objSize.sizeOf(this.arcs);
        }
    }

    private static class PortConA3E0
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableArcInst a1;
        private final ImmutableArcInst a2;

        PortConA3E0(ImmutableArcInst a0, ImmutableArcInst a1, ImmutableArcInst a2) {
            this.a0 = a0;
            this.a1 = a1;
            this.a2 = a2;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(new ImmutableArcInst[]{this.a0, this.a1, this.a2});
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 3;
        }

        @Override
        boolean hasExportsOnPort() {
            return false;
        }

        @Override
        int getNumExportsOnPort() {
            return 0;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.emptyIterator();
        }
    }

    private static class PortConA2E0
    extends PortConns {
        private final ImmutableArcInst a0;
        private final ImmutableArcInst a1;

        PortConA2E0(ImmutableArcInst a0, ImmutableArcInst a1) {
            this.a0 = a0;
            this.a1 = a1;
        }

        @Override
        List<ImmutableArcInst> getConnections() {
            return ImmutableArrayList.of(new ImmutableArcInst[]{this.a0, this.a1});
        }

        @Override
        boolean hasConnections() {
            return true;
        }

        @Override
        int getNumConnections() {
            return 2;
        }

        @Override
        boolean hasExportsOnPort() {
            return false;
        }

        @Override
        int getNumExportsOnPort() {
            return 0;
        }

        @Override
        Iterator<ImmutableExport> getExportsOnPort() {
            return ArrayIterator.emptyIterator();
        }
    }

    private static abstract class PortConns {
        private PortConns() {
        }

        List<ImmutableArcInst> getConnections(BitSet headEnds, int nodeId, PortProtoId portId) {
            assert (portId.externalId.isEmpty());
            List<ImmutableArcInst> list = this.getConnections();
            if (headEnds != null) {
                headEnds.clear();
                for (int i = 0; i < list.size(); ++i) {
                    ImmutableArcInst a = list.get(i);
                    if (a.headNodeId == nodeId) {
                        assert (a.tailNodeId != nodeId && a.headPortId == portId);
                        headEnds.set(i);
                        continue;
                    }
                    assert (a.tailNodeId == nodeId);
                    assert (a.headNodeId != nodeId && a.tailPortId == portId);
                }
            }
            return list;
        }

        abstract List<ImmutableArcInst> getConnections();

        abstract boolean hasConnections();

        abstract int getNumConnections();

        abstract boolean hasExportsOnPort();

        abstract int getNumExportsOnPort();

        abstract Iterator<ImmutableExport> getExportsOnPort();

        long getMemorySize(ObjSize objSize) {
            return objSize.sizeOf(this);
        }

        private void check(ImmutableNodeInst n) {
            this.checkArcs(n);
            this.checkExports(n);
        }

        void checkArcs(ImmutableNodeInst n) {
            int nodeId = n.nodeId;
            ImmutableArcInst oldA = null;
            for (ImmutableArcInst a : this.getConnections()) {
                assert (a.tailNodeId == nodeId && a.headNodeId != nodeId && a.tailPortId.parentId == n.protoId && a.tailPortId.externalId.isEmpty() || a.headNodeId == nodeId && a.tailNodeId != nodeId && a.headPortId.parentId == n.protoId && a.headPortId.externalId.isEmpty());
                if (oldA != null) assert (oldA.arcId < a.arcId);
                oldA = a;
            }
        }

        private void checkExports(ImmutableNodeInst n) {
            ImmutableExport oldE = null;
            Iterator<ImmutableExport> eit = this.getExportsOnPort();
            while (eit.hasNext()) {
                ImmutableExport e = eit.next();
                assert (e.originalNodeId == n.nodeId && e.originalPortId.parentId == n.protoId && e.originalPortId.externalId.isEmpty());
                if (oldE != null) assert (oldE.exportId.chronIndex < e.exportId.chronIndex);
                oldE = e;
            }
        }
    }

    private static class NodeConnections {
        private final ImmutableArcInst[] arcs;
        private final BitSet arcEnds;
        private final ImmutableExport[] exports;

        private NodeConnections(ImmutableArcInst[] arcs, BitSet arcEnds, ImmutableExport[] exports) {
            this.arcs = arcs;
            this.arcEnds = arcEnds;
            this.exports = exports;
        }

        private ImmutableArcInst[] getArcs() {
            return this.arcs;
        }

        private BitSet getArcEnds() {
            return this.arcEnds;
        }

        private ImmutableExport[] getExports() {
            return this.exports;
        }

        private boolean hasConnectionsOnNode() {
            return this.arcs.length != 0;
        }

        private int getNumConnectionsOnNode() {
            return this.arcs.length;
        }

        private List<ImmutableArcInst> getConnectionsOnNode(BitSet headEnds) {
            if (headEnds != null) {
                headEnds.clear();
                headEnds.or(this.arcEnds);
            }
            return ImmutableArrayList.of(this.arcs);
        }

        private boolean hasConnectionsOnPort(PortProtoId portId) {
            int i = this.searchConnectionByPort(portId.chronIndex);
            if (i >= this.arcs.length) {
                return false;
            }
            ImmutableArcInst a = this.arcs[i];
            boolean end = this.arcEnds.get(i);
            return portId == (end ? a.headPortId : a.tailPortId);
        }

        private int getNumConnectionsOnPort(PortProtoId portId) {
            int i;
            int j;
            int chronIndex = portId.chronIndex;
            for (j = i = this.searchConnectionByPort(chronIndex); j < this.arcs.length && portId == (this.arcEnds.get(j) ? this.arcs[j].headPortId : this.arcs[j].tailPortId); ++j) {
            }
            return j - i;
        }

        private List<ImmutableArcInst> getConnectionsOnPort(BitSet headEnds, PortProtoId portId) {
            int i;
            int j;
            int chronIndex = portId.chronIndex;
            for (j = i = this.searchConnectionByPort(chronIndex); j < this.arcs.length && portId == (this.arcEnds.get(j) ? this.arcs[j].headPortId : this.arcs[j].tailPortId); ++j) {
            }
            if (headEnds != null) {
                headEnds.clear();
                for (int k = i; k < j; ++k) {
                    if (!this.arcEnds.get(k)) continue;
                    headEnds.set(k - i);
                }
            }
            return i < j ? new ImmutableArrayList<ImmutableArcInst>((E[])this.arcs, i, j) : Collections.emptyList();
        }

        private int searchConnectionByPort(int chronIndex) {
            int low = 0;
            int high = this.arcs.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                ImmutableArcInst a = this.arcs[mid];
                boolean end = this.arcEnds.get(mid);
                PortProtoId portId = end ? a.headPortId : a.tailPortId;
                int cmp = portId.getChronIndex() - chronIndex;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
            return low;
        }

        private boolean hasExportsOnNode() {
            return this.exports.length != 0;
        }

        private int getNumExportsOnNode() {
            return this.exports.length;
        }

        private Iterator<ImmutableExport> getExportsOnNode() {
            return ArrayIterator.iterator(this.exports);
        }

        private boolean hasExportsOnPort(PortProtoId portId) {
            int i = this.searchExportByPort(portId.chronIndex);
            if (i >= this.exports.length) {
                return false;
            }
            ImmutableExport e = this.exports[i];
            return portId == e.originalPortId;
        }

        private int getNumExportsOnPort(PortProtoId portId) {
            int i;
            int j;
            int chronIndex = portId.chronIndex;
            for (j = i = this.searchExportByPort(chronIndex); j < this.exports.length && portId == this.exports[j].originalPortId; ++j) {
            }
            return j - i;
        }

        private Iterator<ImmutableExport> getExportsOnPort(PortProtoId portId) {
            int i;
            int j;
            int chronIndex = portId.chronIndex;
            for (j = i = this.searchExportByPort(chronIndex); j < this.exports.length && portId == this.exports[j].originalPortId; ++j) {
            }
            return ArrayIterator.iterator(this.exports, i, j);
        }

        private int searchExportByPort(int chronIndex) {
            int low = 0;
            int high = this.exports.length - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                ImmutableExport e = this.exports[mid];
                int cmp = e.originalPortId.chronIndex - chronIndex;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
            return low;
        }

        private long getMemorySize(ObjSize objSize) {
            long s2 = objSize.sizeOf(this);
            if (this.arcs != ImmutableArcInst.NULL_ARRAY) {
                s2 += objSize.sizeOf(this.arcs);
            }
            s2 += CellRevision.sizeOfBitSet(objSize, this.arcEnds);
            if (this.exports != ImmutableExport.NULL_ARRAY) {
                s2 += objSize.sizeOf(this.exports);
            }
            return s2;
        }

        private void check(ImmutableNodeInst n) {
            CellRevisionConn0.checkArcs(this.arcs, this.arcEnds, n, null);
            ImmutableExport oldE = null;
            for (ImmutableExport e : this.exports) {
                assert (e.originalNodeId == n.nodeId && e.originalPortId.parentId == n.protoId);
                if (oldE != null) {
                    assert (oldE.originalPortId.chronIndex <= e.originalPortId.chronIndex);
                    if (oldE.originalPortId.chronIndex == e.originalPortId.chronIndex) assert (oldE.exportId.chronIndex < e.exportId.chronIndex);
                }
                oldE = e;
            }
        }
    }

    private class ConComparator
    implements Comparator<Integer> {
        private ConComparator() {
        }

        @Override
        public int compare(Integer con1, Integer con2) {
            PortProtoId portId2;
            int nodeId2;
            ImmutableArcInst a1 = CellRevisionConn0.this.getArcById(con1 >> 1);
            ImmutableArcInst a2 = CellRevisionConn0.this.getArcById(con2 >> 1);
            boolean end1 = (con1 & 1) != 0;
            boolean end2 = (con2 & 1) != 0;
            int nodeId1 = end1 ? a1.headNodeId : a1.tailNodeId;
            int n = nodeId2 = end2 ? a2.headNodeId : a2.tailNodeId;
            assert (nodeId1 == nodeId2);
            PortProtoId portId1 = end1 ? a1.headPortId : a1.tailPortId;
            PortProtoId portProtoId = portId2 = end2 ? a2.headPortId : a2.tailPortId;
            if (portId1.chronIndex < portId2.chronIndex) {
                return -1;
            }
            if (portId1.chronIndex > portId2.chronIndex) {
                return 1;
            }
            if (con1 < con2) {
                return -1;
            }
            if (con1 > con2) {
                return 1;
            }
            return 0;
        }
    }

    private static class BlockBuffer {
        private boolean hasKilledObjs = false;
        private final ImmutableList<ImmutableElectricObject>[] newObjs = new ImmutableList[64];

        private BlockBuffer() {
        }

        private void putObj(int nodeId, ImmutableElectricObject obj) {
            int lowId = nodeId & 0x3F;
            this.newObjs[lowId] = ImmutableList.addFirst(this.newObjs[lowId], obj);
        }
    }

    public static class CellRevisionProvider
    extends CellRevisionProviderDefault {
        @Override
        public CellRevision createCellRevision(ImmutableCell c) {
            return new CellRevisionConn0(c);
        }
    }
}

