/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.ir;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\nH$J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\rH$J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0010H$J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020'H\u0016\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "<init>", "()V", "getActualClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getActualProperty", "Lorg/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer$ActualPropertyResult;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getActualConstructor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "getActualFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isTargetDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitConstructorCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "ActualPropertyResult", "ir.backend.common"})
public abstract class ExpectSymbolTransformer
extends IrVisitorVoid {
    @Nullable
    protected abstract IrClassSymbol getActualClass(@NotNull ClassDescriptor var1);

    @Nullable
    protected abstract ActualPropertyResult getActualProperty(@NotNull PropertyDescriptor var1);

    @Nullable
    protected abstract IrConstructorSymbol getActualConstructor(@NotNull ClassConstructorDescriptor var1);

    @Nullable
    protected abstract IrSimpleFunctionSymbol getActualFunction(@NotNull FunctionDescriptor var1);

    protected boolean isTargetDeclaration(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return IrUtilsKt.isExpect(declaration);
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren(this, null);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitConstructorCall(expression2);
        if (!this.isTargetDeclaration((IrDeclaration)expression2.getSymbol().getOwner())) {
            return;
        }
        IrConstructorSymbol irConstructorSymbol = this.getActualConstructor((ClassConstructorDescriptor)expression2.getSymbol().getDescriptor());
        if (irConstructorSymbol == null) {
            return;
        }
        expression2.setSymbol(irConstructorSymbol);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitDelegatingConstructorCall(expression2);
        if (!this.isTargetDeclaration((IrDeclaration)expression2.getSymbol().getOwner())) {
            return;
        }
        IrConstructorSymbol irConstructorSymbol = this.getActualConstructor((ClassConstructorDescriptor)expression2.getSymbol().getDescriptor());
        if (irConstructorSymbol == null) {
            return;
        }
        expression2.setSymbol(irConstructorSymbol);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitEnumConstructorCall(expression2);
        if (!this.isTargetDeclaration((IrDeclaration)expression2.getSymbol().getOwner())) {
            return;
        }
        IrConstructorSymbol irConstructorSymbol = this.getActualConstructor((ClassConstructorDescriptor)expression2.getSymbol().getDescriptor());
        if (irConstructorSymbol == null) {
            return;
        }
        expression2.setSymbol(irConstructorSymbol);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitCall(expression2);
        if (!this.isTargetDeclaration((IrDeclaration)expression2.getSymbol().getOwner())) {
            return;
        }
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.getActualFunction((FunctionDescriptor)expression2.getSymbol().getDescriptor());
        if (irSimpleFunctionSymbol == null) {
            return;
        }
        expression2.setSymbol(irSimpleFunctionSymbol);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitPropertyReference(expression2);
        if (!this.isTargetDeclaration((IrDeclaration)((IrPropertySymbol)expression2.getSymbol()).getOwner())) {
            return;
        }
        ActualPropertyResult actualPropertyResult = this.getActualProperty((PropertyDescriptor)((IrPropertySymbol)expression2.getSymbol()).getDescriptor());
        if (actualPropertyResult == null) {
            return;
        }
        ActualPropertyResult actualPropertyResult2 = actualPropertyResult;
        IrPropertySymbol newSymbol = actualPropertyResult2.component1();
        IrSimpleFunctionSymbol newGetter = actualPropertyResult2.component2();
        IrSimpleFunctionSymbol newSetter = actualPropertyResult2.component3();
        expression2.setSymbol((IrSymbol)newSymbol);
        expression2.setGetter(newGetter);
        expression2.setSetter(newSetter);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFunctionReference(expression2);
        if (!this.isTargetDeclaration(((IrFunctionSymbol)expression2.getSymbol()).getOwner())) {
            return;
        }
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.getActualFunction(((IrFunctionSymbol)expression2.getSymbol()).getDescriptor());
        if (irSimpleFunctionSymbol == null) {
            return;
        }
        expression2.setSymbol((IrSymbol)irSimpleFunctionSymbol);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitClassReference(expression2);
        IrClassifierSymbol irClassifierSymbol = expression2.getSymbol();
        IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (irClassSymbol == null) {
            return;
        }
        IrClassSymbol oldSymbol = irClassSymbol;
        if (!this.isTargetDeclaration((IrDeclaration)oldSymbol.getOwner())) {
            return;
        }
        IrClassSymbol irClassSymbol2 = this.getActualClass((ClassDescriptor)oldSymbol.getDescriptor());
        if (irClassSymbol2 == null) {
            return;
        }
        expression2.setSymbol(irClassSymbol2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/ir/ExpectSymbolTransformer$ActualPropertyResult;", "", "propertySymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "getterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "setterSymbol", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;)V", "getPropertySymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "getGetterSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getSetterSymbol", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ir.backend.common"})
    protected static final class ActualPropertyResult {
        @NotNull
        private final IrPropertySymbol propertySymbol;
        @Nullable
        private final IrSimpleFunctionSymbol getterSymbol;
        @Nullable
        private final IrSimpleFunctionSymbol setterSymbol;

        public ActualPropertyResult(@NotNull IrPropertySymbol propertySymbol, @Nullable IrSimpleFunctionSymbol getterSymbol, @Nullable IrSimpleFunctionSymbol setterSymbol) {
            Intrinsics.checkNotNullParameter((Object)propertySymbol, (String)"propertySymbol");
            this.propertySymbol = propertySymbol;
            this.getterSymbol = getterSymbol;
            this.setterSymbol = setterSymbol;
        }

        @NotNull
        public final IrPropertySymbol getPropertySymbol() {
            return this.propertySymbol;
        }

        @Nullable
        public final IrSimpleFunctionSymbol getGetterSymbol() {
            return this.getterSymbol;
        }

        @Nullable
        public final IrSimpleFunctionSymbol getSetterSymbol() {
            return this.setterSymbol;
        }

        @NotNull
        public final IrPropertySymbol component1() {
            return this.propertySymbol;
        }

        @Nullable
        public final IrSimpleFunctionSymbol component2() {
            return this.getterSymbol;
        }

        @Nullable
        public final IrSimpleFunctionSymbol component3() {
            return this.setterSymbol;
        }

        @NotNull
        public final ActualPropertyResult copy(@NotNull IrPropertySymbol propertySymbol, @Nullable IrSimpleFunctionSymbol getterSymbol, @Nullable IrSimpleFunctionSymbol setterSymbol) {
            Intrinsics.checkNotNullParameter((Object)propertySymbol, (String)"propertySymbol");
            return new ActualPropertyResult(propertySymbol, getterSymbol, setterSymbol);
        }

        public static /* synthetic */ ActualPropertyResult copy$default(ActualPropertyResult actualPropertyResult, IrPropertySymbol irPropertySymbol, IrSimpleFunctionSymbol irSimpleFunctionSymbol, IrSimpleFunctionSymbol irSimpleFunctionSymbol2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irPropertySymbol = actualPropertyResult.propertySymbol;
            }
            if ((n2 & 2) != 0) {
                irSimpleFunctionSymbol = actualPropertyResult.getterSymbol;
            }
            if ((n2 & 4) != 0) {
                irSimpleFunctionSymbol2 = actualPropertyResult.setterSymbol;
            }
            return actualPropertyResult.copy(irPropertySymbol, irSimpleFunctionSymbol, irSimpleFunctionSymbol2);
        }

        @NotNull
        public String toString() {
            return "ActualPropertyResult(propertySymbol=" + this.propertySymbol + ", getterSymbol=" + this.getterSymbol + ", setterSymbol=" + this.setterSymbol + ')';
        }

        public int hashCode() {
            int result2 = this.propertySymbol.hashCode();
            result2 = result2 * 31 + (this.getterSymbol == null ? 0 : this.getterSymbol.hashCode());
            result2 = result2 * 31 + (this.setterSymbol == null ? 0 : this.setterSymbol.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActualPropertyResult)) {
                return false;
            }
            ActualPropertyResult actualPropertyResult = (ActualPropertyResult)other;
            if (!Intrinsics.areEqual((Object)this.propertySymbol, (Object)actualPropertyResult.propertySymbol)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.getterSymbol, (Object)actualPropertyResult.getterSymbol)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.setterSymbol, (Object)actualPropertyResult.setterSymbol);
        }
    }
}

