/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.laf.DefaultLookFeel;

public class DashedBorder
implements Border {
    private static final BasicStroke BASIC_STROKE = new BasicStroke();
    protected int thickness = 1;
    protected Color color;
    private BasicStroke stroke = BASIC_STROKE;
    private ResourceTableListener listener = null;

    public DashedBorder(Color color, float f, float f2) {
        this(color, new float[]{f, f2}, 1);
    }

    public DashedBorder(String string, Widget widget, float f, float f2) {
        this(string, widget.getResourceTable(), new float[]{f, f2}, 1);
    }

    public DashedBorder(String string, ResourceTable resourceTable, float f, float f2) {
        this(string, resourceTable, new float[]{f, f2}, 1);
    }

    public DashedBorder(Color color, float[] fArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid thickness: " + n);
        }
        this.thickness = n;
        this.color = color != null ? color : new DefaultLookFeel().getForeground();
        this.stroke = new BasicStroke(n, 0, 1, 0.0f, fArray, 0.0f);
    }

    public DashedBorder(String string, ResourceTable resourceTable, float[] fArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid thickness: " + n);
        }
        this.thickness = n;
        this.stroke = new BasicStroke(n, 0, 1, 0.0f, fArray, 0.0f);
        Object object = resourceTable.getProperty(string);
        if (object instanceof Color) {
            this.color = (Color)object;
        }
        this.listener = new ResourceTableListener();
        resourceTable.addPropertyChangeListener(string, this.listener);
    }

    @Override
    public Insets getInsets() {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.color);
        graphics2D.setStroke(this.stroke);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - this.thickness, rectangle.height - this.thickness);
        graphics2D.setStroke(stroke);
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public class ResourceTableListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DashedBorder.this.color = (Color)propertyChangeEvent.getNewValue();
        }
    }
}

