/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import javafx.scene.control.IndexRange;
import org.reactfx.util.FingerTree;
import org.reactfx.util.Lists;
import org.reactfx.util.ToSemigroup;
import org.reactfx.util.Tuple2;

public final class SparseList<E> {
    private static final ToSemigroup<Segment<?>, Stats> SEGMENT_STATS = new ToSemigroup<Segment<?>, Stats>(){

        @Override
        public Stats reduce(Stats left, Stats right) {
            return new Stats(left.size + right.size, left.presentCount + right.presentCount);
        }

        @Override
        public Stats apply(Segment<?> seg) {
            return new Stats(seg.getLength(), seg.getPresentCount());
        }
    };
    private FingerTree<Segment<E>, Stats> tree = SparseList.emptyTree();

    private static <E> FingerTree<Segment<E>, Stats> emptyTree() {
        return FingerTree.empty(SEGMENT_STATS);
    }

    public int size() {
        return this.tree.getSummary((Stats)Stats.ZERO).size;
    }

    public int getPresentCount() {
        return this.tree.getSummary((Stats)Stats.ZERO).presentCount;
    }

    public boolean isPresent(int index) {
        return this.tree.get(Stats::getSize, index, Segment::isPresent);
    }

    public E getOrThrow(int index) {
        return (E)this.tree.get(Stats::getSize, index, Segment::getOrThrow);
    }

    public Optional<E> get(int index) {
        return this.tree.get(Stats::getSize, index, Segment::get);
    }

    public E getPresent(int presentIndex) {
        return (E)this.tree.get(Stats::getPresentCount, presentIndex, Segment::getOrThrow);
    }

    public int getPresentCountBefore(int position) {
        Lists.checkPosition(position, this.size());
        return this.tree.getSummaryBetween(Stats::getSize, 0, position, Segment::getStatsBetween).orElse(Stats.ZERO).getPresentCount();
    }

    public int getPresentCountAfter(int position) {
        return this.getPresentCount() - this.getPresentCountBefore(position);
    }

    public int getPresentCountBetween(int from, int to) {
        Lists.checkRange(from, to, this.size());
        return this.getPresentCountBefore(to) - this.getPresentCountBefore(from);
    }

    public int indexOfPresentItem(int presentIndex) {
        Lists.checkIndex(presentIndex, this.getPresentCount());
        return this.tree.locateProgressively(Stats::getPresentCount, presentIndex).map(this::locationToPosition);
    }

    public IndexRange getPresentItemsRange() {
        if (this.getPresentCount() == 0) {
            return new IndexRange(0, 0);
        }
        int lowerBound = this.tree.locateProgressively(Stats::getPresentCount, 0).map(this::locationToPosition);
        int upperBound = this.tree.locateRegressively(Stats::getPresentCount, this.getPresentCount()).map(this::locationToPosition);
        return new IndexRange(lowerBound, upperBound);
    }

    private int locationToPosition(int major, int minor) {
        return this.tree.getSummaryBetween((int)0, (int)major).orElse((Stats)Stats.ZERO).size + minor;
    }

    public List<E> collect() {
        ArrayList acc = new ArrayList(this.getPresentCount());
        return this.tree.fold(acc, (l, seg) -> seg.appendTo(l));
    }

    public List<E> collect(int from, int to) {
        ArrayList acc = new ArrayList(this.getPresentCountBetween(from, to));
        return this.tree.foldBetween(acc, (l, seg) -> seg.appendTo(l), Stats::getSize, from, to, (l, seg, start, end) -> seg.appendRangeTo(l, (int)start, (int)end));
    }

    public void clear() {
        this.tree = SparseList.emptyTree();
    }

    public void remove(int index) {
        this.remove(index, index + 1);
    }

    public void remove(int from, int to) {
        Lists.checkRange(from, to, this.size());
        if (from != to) {
            this.spliceSegments(from, to, Collections.emptyList());
        }
    }

    public void set(int index, E elem) {
        this.tree.get(Stats::getSize, index).exec((seg, loc) -> {
            if (seg.isPresent()) {
                seg.setOrThrow(loc.minor, elem);
            } else {
                this.splice(index, index + 1, Collections.singleton(elem));
            }
        });
    }

    public boolean setIfAbsent(int index, E elem) {
        if (this.isPresent(index)) {
            return false;
        }
        this.set(index, elem);
        return true;
    }

    public void insert(int position, E elem) {
        this.insertAll(position, Collections.singleton(elem));
    }

    public void insertAll(int position, Collection<? extends E> elems) {
        if (elems.isEmpty()) {
            return;
        }
        PresentSegment seg = new PresentSegment(elems);
        this.tree = this.tree.caseEmpty().unify(emptyTree -> emptyTree.append(seg), nonEmptyTree -> nonEmptyTree.split(Stats::getSize, position).map((l, m3, r) -> this.join((FingerTree<Segment<E>, Stats>)l, (Tuple2<Segment<E>, Integer>)m3, seg, (Tuple2<Segment<E>, Integer>)m3, (FingerTree<Segment<E>, Stats>)r)));
    }

    public void insertVoid(int position, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be negative: " + length);
        }
        if (length == 0) {
            return;
        }
        AbsentSegment seg = new AbsentSegment(length);
        this.tree = this.tree.caseEmpty().unify(emptyTree -> emptyTree.append(seg), nonEmptyTree -> nonEmptyTree.split(Stats::getSize, position).map((l, m3, r) -> this.join((FingerTree<Segment<E>, Stats>)l, (Tuple2<Segment<E>, Integer>)m3, seg, (Tuple2<Segment<E>, Integer>)m3, (FingerTree<Segment<E>, Stats>)r)));
    }

    public void splice(int from, int to, Collection<? extends E> elems) {
        if (elems.isEmpty()) {
            this.remove(from, to);
        } else if (from == to) {
            this.insertAll(from, elems);
        } else {
            this.spliceSegments(from, to, Collections.singletonList(new PresentSegment<E>(elems)));
        }
    }

    public void spliceByVoid(int from, int to, int length) {
        if (length == 0) {
            this.remove(from, to);
        } else {
            if (length < 0) {
                throw new IllegalArgumentException("length cannot be negative: " + length);
            }
            if (from == to) {
                this.insertVoid(from, length);
            } else {
                this.spliceSegments(from, to, Collections.singletonList(new AbsentSegment(length)));
            }
        }
    }

    private void spliceSegments(int from, int to, List<Segment<E>> middle) {
        Lists.checkRange(from, to, this.tree.getSummary(Stats.ZERO).getSize());
        this.tree = this.tree.caseEmpty().mapLeft(emptyTree -> this.join((FingerTree<Segment<E>, Stats>)emptyTree, middle, (FingerTree<Segment<E>, Stats>)emptyTree)).toLeft(nonEmptyTree -> nonEmptyTree.split(Stats::getSize, from).map((left, lSuffix, r) -> nonEmptyTree.split(Stats::getSize, to).map((l, rPrefix, right) -> this.join((FingerTree<Segment<E>, Stats>)left, (Tuple2<Segment<E>, Integer>)lSuffix, middle, (Tuple2<Segment<E>, Integer>)rPrefix, (FingerTree<Segment<E>, Stats>)right))));
    }

    private FingerTree<Segment<E>, Stats> join(FingerTree<Segment<E>, Stats> left, Tuple2<Segment<E>, Integer> lSuffix, Segment<E> middle, Tuple2<Segment<E>, Integer> rPrefix, FingerTree<Segment<E>, Stats> right) {
        return this.join(left, lSuffix, Collections.singletonList(middle), rPrefix, right);
    }

    private FingerTree<Segment<E>, Stats> join(FingerTree<Segment<E>, Stats> left, Tuple2<Segment<E>, Integer> lSuffix, List<Segment<E>> middle, Tuple2<Segment<E>, Integer> rPrefix, FingerTree<Segment<E>, Stats> right) {
        Segment lSeg = (Segment)lSuffix._1;
        int lMax = (Integer)lSuffix._2;
        if (lMax > 0) {
            left = left.append(lSeg.subSegment(0, lMax));
        }
        Segment rSeg = (Segment)rPrefix._1;
        int rMin = (Integer)rPrefix._2;
        if (rMin < rSeg.getLength()) {
            right = right.prepend(rSeg.subSegment(rMin, rSeg.getLength()));
        }
        return this.join(left, middle, right);
    }

    private FingerTree<Segment<E>, Stats> join(FingerTree<Segment<E>, Stats> left, List<Segment<E>> middle, FingerTree<Segment<E>, Stats> right) {
        for (Segment<E> seg : middle) {
            left = this.append(left, seg);
        }
        return this.join(left, right);
    }

    private FingerTree<Segment<E>, Stats> join(FingerTree<Segment<E>, Stats> left, FingerTree<Segment<E>, Stats> right) {
        Segment<E> firstRight;
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        Segment<E> lastLeft = left.getLeaf(left.getLeafCount() - 1);
        if (lastLeft.possiblyDestructiveAppend(firstRight = right.getLeaf(0))) {
            left = left.updateLeaf(left.getLeafCount() - 1, lastLeft);
            right = (FingerTree)right.split((int)1)._2;
        }
        return left.join(right);
    }

    private FingerTree<Segment<E>, Stats> append(FingerTree<Segment<E>, Stats> left, Segment<E> right) {
        if (left.isEmpty()) {
            return left.append(right);
        }
        Segment<E> lastLeft = left.getLeaf(left.getLeafCount() - 1);
        if (lastLeft.possiblyDestructiveAppend(right)) {
            return left.updateLeaf(left.getLeafCount() - 1, lastLeft);
        }
        return left.append(right);
    }

    int getDepth() {
        return this.tree.getDepth();
    }

    FingerTree<Segment<E>, Stats> getTree() {
        return this.tree;
    }

    private static final class Stats {
        private static final Stats ZERO = new Stats(0, 0);
        final int size;
        final int presentCount;

        Stats(int size, int presentCount) {
            assert (size >= presentCount && presentCount >= 0);
            this.size = size;
            this.presentCount = presentCount;
        }

        int getSize() {
            return this.size;
        }

        int getPresentCount() {
            return this.presentCount;
        }
    }

    private static final class PresentSegment<E>
    implements Segment<E> {
        private final List<E> list;

        public PresentSegment(Collection<? extends E> c) {
            assert (c.size() > 0);
            this.list = new ArrayList<E>(c);
        }

        public String toString() {
            return "[" + this.list.size() + " items: " + this.list + "]";
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public int getPresentCount() {
            return this.list.size();
        }

        @Override
        public int getPresentCountBetween(int from, int to) {
            assert (Lists.isValidRange(from, to, this.getLength()));
            return to - from;
        }

        @Override
        public boolean isPresent(int index) {
            assert (Lists.isValidIndex(index, this.getLength()));
            return true;
        }

        @Override
        public Optional<E> get(int index) {
            return Optional.of(this.list.get(index));
        }

        @Override
        public E getOrThrow(int index) {
            return this.list.get(index);
        }

        @Override
        public void setOrThrow(int index, E elem) {
            this.list.set(index, elem);
        }

        @Override
        public List<E> appendTo(List<E> acc) {
            acc.addAll(this.list);
            return acc;
        }

        @Override
        public List<E> appendRangeTo(List<E> acc, int from, int to) {
            acc.addAll(this.list.subList(from, to));
            return acc;
        }

        @Override
        public Segment<E> subSegment(int from, int to) {
            return new PresentSegment<E>(this.list.subList(from, to));
        }

        @Override
        public boolean possiblyDestructiveAppend(Segment<E> suffix) {
            if (suffix.getPresentCount() == suffix.getLength()) {
                suffix.appendTo(this.list);
                return true;
            }
            return false;
        }
    }

    private static final class AbsentSegment<E>
    implements Segment<E> {
        private int length;

        AbsentSegment(int length) {
            assert (length > 0);
            this.length = length;
        }

        public String toString() {
            return "[Void x " + this.length + "]";
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getPresentCount() {
            return 0;
        }

        @Override
        public int getPresentCountBetween(int from, int to) {
            return 0;
        }

        @Override
        public boolean isPresent(int index) {
            return false;
        }

        @Override
        public Optional<E> get(int index) {
            return Optional.empty();
        }

        @Override
        public E getOrThrow(int index) {
            throw new NoSuchElementException();
        }

        @Override
        public void setOrThrow(int index, E elem) {
            throw new NoSuchElementException();
        }

        @Override
        public List<E> appendTo(List<E> acc) {
            return acc;
        }

        @Override
        public List<E> appendRangeTo(List<E> acc, int from, int to) {
            return acc;
        }

        @Override
        public Segment<E> subSegment(int from, int to) {
            assert (Lists.isValidRange(from, to, this.length));
            return new AbsentSegment<E>(to - from);
        }

        @Override
        public boolean possiblyDestructiveAppend(Segment<E> suffix) {
            if (suffix.getPresentCount() == 0) {
                this.length += suffix.getLength();
                return true;
            }
            return false;
        }
    }

    private static interface Segment<E> {
        public boolean isPresent();

        public int getLength();

        public int getPresentCount();

        public int getPresentCountBetween(int var1, int var2);

        public boolean isPresent(int var1);

        public Optional<E> get(int var1);

        public E getOrThrow(int var1);

        public void setOrThrow(int var1, E var2);

        public List<E> appendTo(List<E> var1);

        public List<E> appendRangeTo(List<E> var1, int var2, int var3);

        public Segment<E> subSegment(int var1, int var2);

        public boolean possiblyDestructiveAppend(Segment<E> var1);

        default public Stats getStatsBetween(int from, int to) {
            return new Stats(to - from, this.getPresentCountBetween(from, to));
        }
    }
}

