/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search;

import java.util.Objects;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.search.SearchMatcher;
import org.jabref.model.search.rules.SearchRule;
import org.jabref.model.search.rules.SearchRules;

public class GroupSearchQuery
implements SearchMatcher {
    private final String query;
    private final boolean caseSensitive;
    private final boolean regularExpression;
    private final SearchRule rule;

    public GroupSearchQuery(String query, boolean caseSensitive, boolean regularExpression) {
        this.query = Objects.requireNonNull(query);
        this.caseSensitive = caseSensitive;
        this.regularExpression = regularExpression;
        this.rule = Objects.requireNonNull(this.getSearchRule());
    }

    public String toString() {
        return String.format("\"%s\" (%s, %s)", this.query, this.getCaseSensitiveDescription(), this.getRegularExpressionDescription());
    }

    @Override
    public boolean isMatch(BibEntry entry) {
        return this.getRule().applyRule(this.query, entry);
    }

    private SearchRule getSearchRule() {
        return SearchRules.getSearchRuleByQuery(this.query, this.caseSensitive, this.regularExpression);
    }

    private String getCaseSensitiveDescription() {
        if (this.caseSensitive) {
            return "case sensitive";
        }
        return "case insensitive";
    }

    private String getRegularExpressionDescription() {
        if (this.regularExpression) {
            return "regular expression";
        }
        return "plain text";
    }

    public SearchRule getRule() {
        return this.rule;
    }

    public String getSearchExpression() {
        return this.query;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegularExpression() {
        return this.regularExpression;
    }
}

