/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.paint.Color;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.search.SearchMatcher;
import org.jabref.model.strings.StringUtil;

public abstract class AbstractGroup
implements SearchMatcher {
    protected final String name;
    protected final GroupHierarchyType context;
    protected Optional<Color> color = Optional.empty();
    protected boolean isExpanded = true;
    protected Optional<String> description = Optional.empty();
    protected Optional<String> iconName = Optional.empty();

    protected AbstractGroup(String name, GroupHierarchyType context) {
        this.name = name;
        this.context = Objects.requireNonNull(context);
    }

    public String toString() {
        return "AbstractGroup{name='" + this.name + '\'' + ", context=" + (Object)((Object)this.context) + ", color=" + this.color + ", isExpanded=" + this.isExpanded + ", description=" + this.description + ", iconName=" + this.iconName + '}';
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractGroup that = (AbstractGroup)other;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals((Object)this.context, (Object)that.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.context});
    }

    public Optional<Color> getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = Optional.of(color);
    }

    public void setColor(String colorString) {
        if (StringUtil.isBlank(colorString)) {
            this.color = Optional.empty();
        } else {
            this.setColor(Color.valueOf((String)colorString));
        }
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtil.isBlank(description) ? Optional.empty() : Optional.of(description);
    }

    public Optional<String> getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = StringUtil.isBlank(iconName) ? Optional.empty() : Optional.of(iconName);
    }

    public GroupHierarchyType getHierarchicalContext() {
        return this.context;
    }

    public final String getName() {
        return this.name;
    }

    public abstract boolean contains(BibEntry var1);

    @Override
    public boolean isMatch(BibEntry entry) {
        return this.contains(entry);
    }

    public boolean containsAny(List<BibEntry> entries) {
        for (BibEntry entry : entries) {
            if (!this.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(List<BibEntry> entries) {
        for (BibEntry entry : entries) {
            if (this.contains(entry)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean isDynamic();

    public abstract AbstractGroup deepCopy();
}

