/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Objects;
import java.util.Optional;
import org.jabref.model.strings.StringUtil;

public class Author {
    private final String firstPart;
    private final String firstAbbr;
    private final String vonPart;
    private final String lastPart;
    private final String jrPart;

    public Author(String first, String firstabbr, String von, String last, String jr) {
        this.firstPart = Author.addDotIfAbbreviation(this.removeStartAndEndBraces(first));
        this.firstAbbr = this.removeStartAndEndBraces(firstabbr);
        this.vonPart = this.removeStartAndEndBraces(von);
        this.lastPart = this.removeStartAndEndBraces(last);
        this.jrPart = this.removeStartAndEndBraces(jr);
    }

    public static String addDotIfAbbreviation(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.length() == 1 && Character.isLetter(name.charAt(0)) && Character.isUpperCase(name.charAt(0))) {
            return name + ".";
        }
        StringBuilder sb = new StringBuilder();
        char lastChar = name.charAt(0);
        for (int i = 0; i < name.length(); ++i) {
            char furtherChar;
            boolean lastIsLowercaseLetter;
            boolean currentIsUppercaseLetter;
            if (i > 0) {
                lastChar = name.charAt(i - 1);
            }
            char currentChar = name.charAt(i);
            sb.append(currentChar);
            if (currentChar == '.' && i + 1 < name.length() && Character.isUpperCase(name.charAt(i + 1))) {
                sb.append(' ');
            }
            boolean bl = currentIsUppercaseLetter = Character.isLetter(currentChar) && Character.isUpperCase(currentChar);
            if (!currentIsUppercaseLetter) continue;
            boolean bl2 = lastIsLowercaseLetter = Character.isLetter(lastChar) && Character.isLowerCase(lastChar);
            if (lastIsLowercaseLetter) continue;
            if (i + 1 >= name.length()) {
                sb.append('.');
                continue;
            }
            char nextChar = name.charAt(i + 1);
            if ('-' == nextChar) {
                sb.append(".");
                continue;
            }
            if ('.' == nextChar) continue;
            boolean nextWordIsUppercase = true;
            for (int j = i + 1; j < name.length() && !Character.isWhitespace(furtherChar = name.charAt(j)) && furtherChar != '-' && furtherChar != '~' && furtherChar != '.'; ++j) {
                boolean furtherIsUppercaseLetter;
                boolean bl3 = furtherIsUppercaseLetter = Character.isLetter(furtherChar) && Character.isUpperCase(furtherChar);
                if (furtherIsUppercaseLetter) continue;
                nextWordIsUppercase = false;
                break;
            }
            if (!nextWordIsUppercase) continue;
            sb.append(". ");
        }
        return sb.toString().trim();
    }

    public int hashCode() {
        return Objects.hash(this.firstAbbr, this.firstPart, this.jrPart, this.lastPart, this.vonPart);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Author) {
            Author that = (Author)other;
            return Objects.equals(this.firstPart, that.firstPart) && Objects.equals(this.firstAbbr, that.firstAbbr) && Objects.equals(this.vonPart, that.vonPart) && Objects.equals(this.lastPart, that.lastPart) && Objects.equals(this.jrPart, that.jrPart);
        }
        return false;
    }

    private boolean properBrackets(String s2) {
        int level = 0;
        block4: for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '{': {
                    ++level;
                    continue block4;
                }
                case '}': {
                    if (--level != -1) continue block4;
                    return false;
                }
            }
        }
        return level == 0;
    }

    private String removeStartAndEndBraces(String name) {
        if (StringUtil.isBlank(name)) {
            return null;
        }
        if (!name.contains("{")) {
            return name;
        }
        String[] split = name.split(" ");
        StringBuilder b = new StringBuilder();
        for (String s2 : split) {
            if (s2.length() > 2 && s2.startsWith("{") && s2.endsWith("}")) {
                String inner = s2.substring(1, s2.length() - 1);
                if (inner.contains("}")) {
                    if (this.properBrackets(inner)) {
                        s2 = inner;
                    }
                } else {
                    s2 = inner;
                }
            }
            b.append(s2).append(' ');
        }
        b.deleteCharAt(b.length() - 1);
        String newName = b.toString();
        if (newName.startsWith("{") && newName.endsWith("}")) {
            String inner = newName.substring(1, newName.length() - 1);
            if (this.properBrackets(inner)) {
                return inner;
            }
            return newName;
        }
        return newName;
    }

    public Optional<String> getFirst() {
        return Optional.ofNullable(this.firstPart);
    }

    public Optional<String> getFirstAbbr() {
        return Optional.ofNullable(this.firstAbbr);
    }

    public Optional<String> getVon() {
        return Optional.ofNullable(this.vonPart);
    }

    public Optional<String> getLast() {
        return Optional.ofNullable(this.lastPart);
    }

    public Optional<String> getJr() {
        return Optional.ofNullable(this.jrPart);
    }

    public String getLastOnly() {
        if (this.vonPart == null) {
            return this.getLast().orElse("");
        }
        return this.lastPart == null ? this.vonPart : this.vonPart + ' ' + this.lastPart;
    }

    public String getLastFirst(boolean abbr) {
        StringBuilder res = new StringBuilder(this.getLastOnly());
        this.getJr().ifPresent(jr -> res.append(", ").append((String)jr));
        if (abbr) {
            this.getFirstAbbr().ifPresent(firstA -> res.append(", ").append((String)firstA));
        } else {
            this.getFirst().ifPresent(first -> res.append(", ").append((String)first));
        }
        return res.toString();
    }

    public String getFirstLast(boolean abbr) {
        StringBuilder res = new StringBuilder();
        if (abbr) {
            this.getFirstAbbr().map(firstA -> firstA + ' ').ifPresent(res::append);
        } else {
            this.getFirst().map(first -> first + ' ').ifPresent(res::append);
        }
        res.append(this.getLastOnly());
        this.getJr().ifPresent(jr -> res.append(", ").append((String)jr));
        return res.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Author{");
        sb.append("firstPart='").append(this.firstPart).append('\'');
        sb.append(", firstAbbr='").append(this.firstAbbr).append('\'');
        sb.append(", vonPart='").append(this.vonPart).append('\'');
        sb.append(", lastPart='").append(this.lastPart).append('\'');
        sb.append(", jrPart='").append(this.jrPart).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public String getNameForAlphabetization() {
        StringBuilder res = new StringBuilder();
        this.getLast().ifPresent(res::append);
        this.getJr().ifPresent(jr -> res.append(", ").append((String)jr));
        this.getFirstAbbr().ifPresent(firstA -> res.append(", ").append((String)firstA));
        while (res.length() > 0 && res.charAt(0) == '{') {
            res.deleteCharAt(0);
        }
        return res.toString();
    }
}

