/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.database;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.model.Defaults;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.database.BibDatabaseModeDetection;
import org.jabref.model.database.event.CoarseChangeFilter;
import org.jabref.model.database.shared.DatabaseLocation;
import org.jabref.model.database.shared.DatabaseSynchronizer;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.metadata.FileDirectoryPreferences;
import org.jabref.model.metadata.MetaData;

public class BibDatabaseContext {
    private final BibDatabase database;
    private final Defaults defaults;
    private MetaData metaData;
    private File file;
    private DatabaseSynchronizer dbmsSynchronizer;
    private CoarseChangeFilter dbmsListener;
    private DatabaseLocation location;

    public BibDatabaseContext() {
        this(new Defaults());
    }

    public BibDatabaseContext(Defaults defaults) {
        this(new BibDatabase(), defaults);
    }

    public BibDatabaseContext(BibDatabase database) {
        this(database, new Defaults());
    }

    public BibDatabaseContext(BibDatabase database, Defaults defaults) {
        this(database, new MetaData(), defaults);
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData, Defaults defaults) {
        this.defaults = Objects.requireNonNull(defaults);
        this.database = Objects.requireNonNull(database);
        this.metaData = Objects.requireNonNull(metaData);
        this.location = DatabaseLocation.LOCAL;
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData) {
        this(database, metaData, new Defaults());
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData, File file, Defaults defaults, DatabaseLocation location) {
        this(database, metaData, defaults);
        Objects.requireNonNull(location);
        this.setDatabaseFile(file);
        if (location == DatabaseLocation.LOCAL) {
            this.convertToLocalDatabase();
        }
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData, File file, Defaults defaults) {
        this(database, metaData, file, defaults, DatabaseLocation.LOCAL);
    }

    public BibDatabaseContext(BibDatabase database, MetaData metaData, File file) {
        this(database, metaData, file, new Defaults());
    }

    public BibDatabaseMode getMode() {
        Optional<BibDatabaseMode> mode = this.metaData.getMode();
        if (!mode.isPresent()) {
            BibDatabaseMode inferredMode = BibDatabaseModeDetection.inferMode(this.database);
            BibDatabaseMode newMode = BibDatabaseMode.BIBTEX;
            if (this.defaults.mode == BibDatabaseMode.BIBLATEX || inferredMode == BibDatabaseMode.BIBLATEX) {
                newMode = BibDatabaseMode.BIBLATEX;
            }
            this.setMode(newMode);
            return newMode;
        }
        return mode.get();
    }

    public void setMode(BibDatabaseMode bibDatabaseMode) {
        this.metaData.setMode(bibDatabaseMode);
    }

    @Deprecated
    public Optional<File> getDatabaseFile() {
        return Optional.ofNullable(this.file);
    }

    public void setDatabaseFile(File file) {
        this.file = file;
    }

    public Optional<Path> getDatabasePath() {
        return Optional.ofNullable(this.file).map(File::toPath);
    }

    public void clearDatabaseFile() {
        this.file = null;
    }

    public BibDatabase getDatabase() {
        return this.database;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = Objects.requireNonNull(metaData);
    }

    public boolean isBiblatexMode() {
        return this.getMode() == BibDatabaseMode.BIBLATEX;
    }

    public List<Path> getFileDirectoriesAsPaths(FileDirectoryPreferences preferences) {
        return this.getFileDirectories(preferences).stream().filter(s2 -> !s2.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toAbsolutePath).map(Path::normalize).collect(Collectors.toList());
    }

    @Deprecated
    public List<String> getFileDirectories(FileDirectoryPreferences preferences) {
        return this.getFileDirectories("file", preferences);
    }

    public Optional<Path> getFirstExistingFileDir(FileDirectoryPreferences preferences) {
        return this.getFileDirectoriesAsPaths(preferences).stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
    }

    public List<String> getFileDirectories(String fieldName, FileDirectoryPreferences preferences) {
        Optional<String> metaDataDirectory;
        ArrayList<String> fileDirs = new ArrayList<String>();
        Optional<String> userFileDirectory = this.metaData.getUserFileDirectory(preferences.getUser());
        if (userFileDirectory.isPresent()) {
            fileDirs.add(this.getFileDirectoryPath(userFileDirectory.get()));
        }
        if ((metaDataDirectory = this.metaData.getDefaultFileDirectory()).isPresent()) {
            fileDirs.add(this.getFileDirectoryPath(metaDataDirectory.get()));
        }
        preferences.getFileDirectory(fieldName).ifPresent(path -> fileDirs.add(path.toAbsolutePath().toString()));
        this.getDatabasePath().ifPresent(dbPath -> {
            Objects.requireNonNull(dbPath, "dbPath is null");
            Path parentPath = dbPath.getParent();
            if (parentPath == null) {
                parentPath = Paths.get(System.getProperty("user.dir"), new String[0]);
            }
            Objects.requireNonNull(parentPath, "BibTeX database parent path is null");
            String parentDir = parentPath.toAbsolutePath().toString();
            if (preferences.isBibLocationAsPrimary()) {
                fileDirs.add(0, parentDir);
            } else {
                fileDirs.add(parentDir);
            }
        });
        return fileDirs;
    }

    private String getFileDirectoryPath(String directoryName) {
        String relDir;
        String dir = directoryName;
        Optional<File> databaseFile = this.getDatabaseFile();
        if (!new File(dir).isAbsolute() && databaseFile.isPresent() && new File(relDir = ".".equals(dir) ? databaseFile.get().getParent() : databaseFile.get().getParent() + File.separator + dir).exists()) {
            dir = relDir;
        }
        return dir;
    }

    public DatabaseSynchronizer getDBMSSynchronizer() {
        return this.dbmsSynchronizer;
    }

    public void clearDBMSSynchronizer() {
        this.dbmsSynchronizer = null;
    }

    public DatabaseLocation getLocation() {
        return this.location;
    }

    public void convertToSharedDatabase(DatabaseSynchronizer dmbsSynchronizer) {
        this.dbmsSynchronizer = dmbsSynchronizer;
        this.dbmsListener = new CoarseChangeFilter(this);
        this.dbmsListener.registerListener(this.dbmsSynchronizer);
        this.location = DatabaseLocation.SHARED;
    }

    public String toString() {
        return "BibDatabaseContext{file=" + this.file + ", location=" + (Object)((Object)this.location) + '}';
    }

    public void convertToLocalDatabase() {
        if (Objects.nonNull(this.dbmsListener) && this.location == DatabaseLocation.SHARED) {
            this.dbmsListener.unregisterListener(this.dbmsSynchronizer);
            this.dbmsListener.shutdown();
        }
        this.location = DatabaseLocation.LOCAL;
    }

    public List<BibEntry> getEntries() {
        return this.database.getEntries();
    }
}

