/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.bibtexkeypattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public abstract class AbstractBibtexKeyPattern {
    protected List<String> defaultPattern = new ArrayList<String>();
    protected Map<String, List<String>> data = new HashMap<String, List<String>>();

    public void addBibtexKeyPattern(String type, String pattern) {
        this.data.put(type, AbstractBibtexKeyPattern.split(pattern));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractBibtexKeyPattern{");
        sb.append("defaultPattern=").append(this.defaultPattern);
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBibtexKeyPattern that = (AbstractBibtexKeyPattern)o;
        return Objects.equals(this.defaultPattern, that.defaultPattern) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.defaultPattern, this.data);
    }

    public void removeBibtexKeyPattern(String type) {
        if (this.data.containsKey(type)) {
            this.data.remove(type);
        }
    }

    public List<String> getValue(String key) {
        List<String> result = this.data.get(key);
        if (result == null && ((result = this.getDefaultValue()) == null || result.isEmpty())) {
            return this.getLastLevelBibtexKeyPattern(key);
        }
        return result;
    }

    public static List<String> split(String bibtexKeyPattern) {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add(bibtexKeyPattern);
        StringTokenizer tok = new StringTokenizer(bibtexKeyPattern, "[]", true);
        while (tok.hasMoreTokens()) {
            fieldList.add(tok.nextToken());
        }
        return fieldList;
    }

    public final boolean isDefaultValue(String key) {
        return this.data.get(key) == null;
    }

    public List<String> getDefaultValue() {
        return this.defaultPattern;
    }

    public void setDefaultValue(String bibtexKeyPattern) {
        Objects.requireNonNull(bibtexKeyPattern);
        this.defaultPattern = AbstractBibtexKeyPattern.split(bibtexKeyPattern);
    }

    public Set<String> getAllKeys() {
        return this.data.keySet();
    }

    public Map<String, List<String>> getPatterns() {
        return this.data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public abstract List<String> getLastLevelBibtexKeyPattern(String var1);
}

