/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.util.Arrays;

public class FileNameCleaner {
    private static final int[] ILLEGAL_CHARS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 42, 58, 60, 62, 63, 124};

    private FileNameCleaner() {
    }

    public static String cleanFileName(String badFileName) {
        StringBuilder cleanName = new StringBuilder(badFileName.length());
        for (int i = 0; i < badFileName.length(); ++i) {
            char c = badFileName.charAt(i);
            if (FileNameCleaner.isCharLegal(c) && c != '/' && c != '\\') {
                cleanName.append(c);
                continue;
            }
            cleanName.append('_');
        }
        return cleanName.toString().trim();
    }

    public static String cleanDirectoryName(String badFileName) {
        StringBuilder cleanName = new StringBuilder(badFileName.length());
        for (int i = 0; i < badFileName.length(); ++i) {
            char c = badFileName.charAt(i);
            if (FileNameCleaner.isCharLegal(c)) {
                cleanName.append(c);
                continue;
            }
            cleanName.append('_');
        }
        return cleanName.toString().trim();
    }

    private static boolean isCharLegal(char c) {
        return Arrays.binarySearch(ILLEGAL_CHARS, (int)c) < 0;
    }
}

