/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jabref.logic.formatter.bibtexfields.HtmlToLatexFormatter;
import org.jabref.logic.formatter.bibtexfields.UnicodeToLatexFormatter;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.layout.ParamLayoutFormatter;
import org.jabref.logic.layout.StringInt;
import org.jabref.logic.layout.format.AuthorAbbreviator;
import org.jabref.logic.layout.format.AuthorAndToSemicolonReplacer;
import org.jabref.logic.layout.format.AuthorAndsCommaReplacer;
import org.jabref.logic.layout.format.AuthorAndsReplacer;
import org.jabref.logic.layout.format.AuthorFirstAbbrLastCommas;
import org.jabref.logic.layout.format.AuthorFirstAbbrLastOxfordCommas;
import org.jabref.logic.layout.format.AuthorFirstFirst;
import org.jabref.logic.layout.format.AuthorFirstFirstCommas;
import org.jabref.logic.layout.format.AuthorFirstLastCommas;
import org.jabref.logic.layout.format.AuthorFirstLastOxfordCommas;
import org.jabref.logic.layout.format.AuthorLF_FF;
import org.jabref.logic.layout.format.AuthorLF_FFAbbr;
import org.jabref.logic.layout.format.AuthorLastFirst;
import org.jabref.logic.layout.format.AuthorLastFirstAbbrCommas;
import org.jabref.logic.layout.format.AuthorLastFirstAbbrOxfordCommas;
import org.jabref.logic.layout.format.AuthorLastFirstAbbreviator;
import org.jabref.logic.layout.format.AuthorLastFirstCommas;
import org.jabref.logic.layout.format.AuthorLastFirstOxfordCommas;
import org.jabref.logic.layout.format.AuthorNatBib;
import org.jabref.logic.layout.format.AuthorOrgSci;
import org.jabref.logic.layout.format.Authors;
import org.jabref.logic.layout.format.CompositeFormat;
import org.jabref.logic.layout.format.CreateBibORDFAuthors;
import org.jabref.logic.layout.format.CreateDocBookAuthors;
import org.jabref.logic.layout.format.CreateDocBookEditors;
import org.jabref.logic.layout.format.CurrentDate;
import org.jabref.logic.layout.format.DOICheck;
import org.jabref.logic.layout.format.DOIStrip;
import org.jabref.logic.layout.format.DateFormatter;
import org.jabref.logic.layout.format.Default;
import org.jabref.logic.layout.format.EntryTypeFormatter;
import org.jabref.logic.layout.format.FileLink;
import org.jabref.logic.layout.format.FirstPage;
import org.jabref.logic.layout.format.FormatPagesForHTML;
import org.jabref.logic.layout.format.FormatPagesForXML;
import org.jabref.logic.layout.format.GetOpenOfficeType;
import org.jabref.logic.layout.format.HTMLChars;
import org.jabref.logic.layout.format.HTMLParagraphs;
import org.jabref.logic.layout.format.IfPlural;
import org.jabref.logic.layout.format.Iso690FormatDate;
import org.jabref.logic.layout.format.Iso690NamesAuthors;
import org.jabref.logic.layout.format.JournalAbbreviator;
import org.jabref.logic.layout.format.LastPage;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.logic.layout.format.NameFormatter;
import org.jabref.logic.layout.format.NoSpaceBetweenAbbreviations;
import org.jabref.logic.layout.format.NotFoundFormatter;
import org.jabref.logic.layout.format.Number;
import org.jabref.logic.layout.format.Ordinal;
import org.jabref.logic.layout.format.RTFChars;
import org.jabref.logic.layout.format.RemoveBrackets;
import org.jabref.logic.layout.format.RemoveBracketsAddComma;
import org.jabref.logic.layout.format.RemoveLatexCommandsFormatter;
import org.jabref.logic.layout.format.RemoveTilde;
import org.jabref.logic.layout.format.RemoveWhitespace;
import org.jabref.logic.layout.format.Replace;
import org.jabref.logic.layout.format.RisAuthors;
import org.jabref.logic.layout.format.RisKeywords;
import org.jabref.logic.layout.format.RisMonth;
import org.jabref.logic.layout.format.ToLowerCase;
import org.jabref.logic.layout.format.ToUpperCase;
import org.jabref.logic.layout.format.WrapContent;
import org.jabref.logic.layout.format.WrapFileLinks;
import org.jabref.logic.layout.format.XMLChars;
import org.jabref.logic.openoffice.OOPreFormatter;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LayoutEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(LayoutEntry.class);
    private List<LayoutFormatter> option;
    private LayoutFormatter postFormatter;
    private String text;
    private List<LayoutEntry> layoutEntries;
    private final int type;
    private final List<String> invalidFormatter = new ArrayList<String>();
    private final LayoutFormatterPreferences prefs;

    public LayoutEntry(StringInt si, LayoutFormatterPreferences prefs) {
        this.prefs = prefs;
        this.type = si.i;
        switch (this.type) {
            case 1: {
                this.text = si.s;
                break;
            }
            case 2: {
                this.text = si.s.trim();
                break;
            }
            case 5: {
                this.doOptionField(si.s);
                break;
            }
        }
    }

    public LayoutEntry(List<StringInt> parsedEntries, int layoutType, LayoutFormatterPreferences prefs) {
        this.prefs = prefs;
        ArrayList<LayoutEntry> tmpEntries = new ArrayList<LayoutEntry>();
        String blockStart = parsedEntries.get((int)0).s;
        String blockEnd = parsedEntries.get((int)(parsedEntries.size() - 1)).s;
        if (!blockStart.equals(blockEnd)) {
            LOGGER.warn("Field start and end entry must be equal.");
        }
        this.type = layoutType;
        this.text = blockEnd;
        ArrayList<StringInt> blockEntries = null;
        for (StringInt parsedEntry : parsedEntries.subList(1, parsedEntries.size() - 1)) {
            switch (parsedEntry.i) {
                case 3: 
                case 6: {
                    blockEntries = new ArrayList<StringInt>();
                    blockStart = parsedEntry.s;
                    break;
                }
                case 4: 
                case 7: {
                    if (blockStart.equals(parsedEntry.s)) {
                        blockEntries.add(parsedEntry);
                        int groupType = parsedEntry.i == 7 ? 6 : 3;
                        LayoutEntry le = new LayoutEntry(blockEntries, groupType, prefs);
                        tmpEntries.add(le);
                        blockEntries = null;
                        break;
                    }
                    LOGGER.warn("Nested field entries are not implemented!");
                    break;
                }
            }
            if (blockEntries == null) {
                tmpEntries.add(new LayoutEntry(parsedEntry, prefs));
                continue;
            }
            blockEntries.add(parsedEntry);
        }
        this.layoutEntries = new ArrayList<LayoutEntry>(tmpEntries);
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            this.invalidFormatter.addAll(layoutEntry.getInvalidFormatters());
        }
    }

    public void setPostFormatter(LayoutFormatter formatter) {
        this.postFormatter = formatter;
    }

    public String doLayout(BibEntry bibtex, BibDatabase database) {
        switch (this.type) {
            case 1: {
                return this.text;
            }
            case 2: {
                String value = bibtex.getResolvedFieldOrAlias(this.text, database).orElse("");
                if (this.postFormatter != null) {
                    value = this.postFormatter.format(value);
                }
                return value;
            }
            case 3: 
            case 6: {
                return this.handleFieldOrGroupStart(bibtex, database);
            }
            case 4: 
            case 7: {
                return "";
            }
            case 5: {
                return this.handleOptionField(bibtex, database);
            }
            case 8: {
                return bibtex.getResolvedFieldOrAlias("encoding", database).orElse(null);
            }
        }
        return "";
    }

    private String handleOptionField(BibEntry bibtex, BibDatabase database) {
        String fieldEntry;
        if ("entrytype".equals(this.text)) {
            fieldEntry = bibtex.getType();
        } else if ("bibtextype".equals(this.text)) {
            LOGGER.warn("'bibtextype' is an obsolete name for the entry type. Please update your layout to use 'entrytype' instead.");
            fieldEntry = bibtex.getType();
        } else {
            String string = fieldEntry = this.text.startsWith("\\") ? bibtex.getResolvedFieldOrAlias(this.text.substring(1), database).orElse("") : BibDatabase.getText(this.text, database);
        }
        if (this.option != null) {
            for (LayoutFormatter anOption : this.option) {
                fieldEntry = anOption.format(fieldEntry);
            }
        }
        if (this.postFormatter != null) {
            fieldEntry = this.postFormatter.format(fieldEntry);
        }
        return fieldEntry;
    }

    private String handleFieldOrGroupStart(BibEntry bibtex, BibDatabase database) {
        String part;
        int n;
        int n2;
        String[] stringArray;
        String[] parts;
        Optional<String> field2;
        if (this.type == 6) {
            field2 = bibtex.getResolvedFieldOrAlias(this.text, database);
        } else if (this.text.matches(".*(;|(\\&+)).*")) {
            parts = this.text.split("\\s*(;|(\\&+))\\s*");
            field2 = Optional.empty();
            stringArray = parts;
            n2 = stringArray.length;
            for (n = 0; n < n2 && (field2 = bibtex.getResolvedFieldOrAlias(part = stringArray[n], database)).isPresent(); ++n) {
            }
        } else {
            parts = this.text.split("\\s*(\\|+)\\s*");
            field2 = Optional.empty();
            stringArray = parts;
            n2 = stringArray.length;
            for (n = 0; n < n2 && !(field2 = bibtex.getResolvedFieldOrAlias(part = stringArray[n], database)).isPresent(); ++n) {
            }
        }
        if (!field2.isPresent() || this.type == 6 && field2.get().equalsIgnoreCase(LayoutHelper.getCurrentGroup())) {
            return null;
        }
        if (this.type == 6) {
            LayoutHelper.setCurrentGroup(field2.get());
        }
        StringBuilder sb = new StringBuilder(100);
        boolean previousSkipped = false;
        for (int i = 0; i < this.layoutEntries.size(); ++i) {
            String fieldText = this.layoutEntries.get(i).doLayout(bibtex, database);
            if (fieldText == null) {
                if (i + 1 < this.layoutEntries.size() && this.layoutEntries.get(i + 1).doLayout(bibtex, database).trim().isEmpty()) {
                    ++i;
                    previousSkipped = true;
                    continue;
                }
            } else if (previousSkipped) {
                int eol;
                for (eol = 0; eol < fieldText.length() && (fieldText.charAt(eol) == '\n' || fieldText.charAt(eol) == '\r'); ++eol) {
                }
                if (eol < fieldText.length()) {
                    sb.append(fieldText.substring(eol));
                }
            } else {
                sb.append(fieldText);
            }
            previousSkipped = false;
        }
        return sb.toString();
    }

    public String doLayout(BibDatabaseContext databaseContext, Charset encoding) {
        switch (this.type) {
            case 1: {
                return this.text;
            }
            case 2: {
                throw new UnsupportedOperationException("bibtex entry fields not allowed in begin or end layout");
            }
            case 3: 
            case 6: {
                throw new UnsupportedOperationException("field and group starts not allowed in begin or end layout");
            }
            case 4: 
            case 7: {
                throw new UnsupportedOperationException("field and group ends not allowed in begin or end layout");
            }
            case 5: {
                String field2 = BibDatabase.getText(this.text, databaseContext.getDatabase());
                if (this.option != null) {
                    for (LayoutFormatter anOption : this.option) {
                        field2 = anOption.format(field2);
                    }
                }
                if (this.postFormatter != null) {
                    field2 = this.postFormatter.format(field2);
                }
                return field2;
            }
            case 8: {
                return encoding.displayName();
            }
            case 9: {
                return databaseContext.getDatabaseFile().map(File::getName).orElse("");
            }
            case 10: {
                return databaseContext.getDatabaseFile().map(File::getPath).orElse("");
            }
        }
        return "";
    }

    private void doOptionField(String s2) {
        List<String> v = StringUtil.tokenizeToList(s2, "\n");
        if (v.size() == 1) {
            this.text = v.get(0);
        } else {
            this.text = v.get(0).trim();
            this.option = this.getOptionalLayout(v.get(1));
            for (LayoutFormatter anOption : this.option) {
                if (!(anOption instanceof NotFoundFormatter)) continue;
                String notFound = ((NotFoundFormatter)anOption).getNotFound();
                this.invalidFormatter.add(notFound);
            }
        }
    }

    private LayoutFormatter getLayoutFormatterByName(String name) throws Exception {
        switch (name) {
            case "HTMLToLatexFormatter": 
            case "HtmlToLatex": {
                return new HtmlToLatexFormatter();
            }
            case "UnicodeToLatexFormatter": 
            case "UnicodeToLatex": {
                return new UnicodeToLatexFormatter();
            }
            case "OOPreFormatter": {
                return new OOPreFormatter();
            }
            case "AuthorAbbreviator": {
                return new AuthorAbbreviator();
            }
            case "AuthorAndToSemicolonReplacer": {
                return new AuthorAndToSemicolonReplacer();
            }
            case "AuthorAndsCommaReplacer": {
                return new AuthorAndsCommaReplacer();
            }
            case "AuthorAndsReplacer": {
                return new AuthorAndsReplacer();
            }
            case "AuthorFirstAbbrLastCommas": {
                return new AuthorFirstAbbrLastCommas();
            }
            case "AuthorFirstAbbrLastOxfordCommas": {
                return new AuthorFirstAbbrLastOxfordCommas();
            }
            case "AuthorFirstFirst": {
                return new AuthorFirstFirst();
            }
            case "AuthorFirstFirstCommas": {
                return new AuthorFirstFirstCommas();
            }
            case "AuthorFirstLastCommas": {
                return new AuthorFirstLastCommas();
            }
            case "AuthorFirstLastOxfordCommas": {
                return new AuthorFirstLastOxfordCommas();
            }
            case "AuthorLastFirst": {
                return new AuthorLastFirst();
            }
            case "AuthorLastFirstAbbrCommas": {
                return new AuthorLastFirstAbbrCommas();
            }
            case "AuthorLastFirstAbbreviator": {
                return new AuthorLastFirstAbbreviator();
            }
            case "AuthorLastFirstAbbrOxfordCommas": {
                return new AuthorLastFirstAbbrOxfordCommas();
            }
            case "AuthorLastFirstCommas": {
                return new AuthorLastFirstCommas();
            }
            case "AuthorLastFirstOxfordCommas": {
                return new AuthorLastFirstOxfordCommas();
            }
            case "AuthorLF_FF": {
                return new AuthorLF_FF();
            }
            case "AuthorLF_FFAbbr": {
                return new AuthorLF_FFAbbr();
            }
            case "AuthorNatBib": {
                return new AuthorNatBib();
            }
            case "AuthorOrgSci": {
                return new AuthorOrgSci();
            }
            case "CompositeFormat": {
                return new CompositeFormat();
            }
            case "CreateBibORDFAuthors": {
                return new CreateBibORDFAuthors();
            }
            case "CreateDocBookAuthors": {
                return new CreateDocBookAuthors();
            }
            case "CreateDocBookEditors": {
                return new CreateDocBookEditors();
            }
            case "CurrentDate": {
                return new CurrentDate();
            }
            case "DateFormatter": {
                return new DateFormatter();
            }
            case "DOICheck": {
                return new DOICheck();
            }
            case "DOIStrip": {
                return new DOIStrip();
            }
            case "EntryTypeFormatter": {
                return new EntryTypeFormatter();
            }
            case "FirstPage": {
                return new FirstPage();
            }
            case "FormatPagesForHTML": {
                return new FormatPagesForHTML();
            }
            case "FormatPagesForXML": {
                return new FormatPagesForXML();
            }
            case "GetOpenOfficeType": {
                return new GetOpenOfficeType();
            }
            case "HTMLChars": {
                return new HTMLChars();
            }
            case "HTMLParagraphs": {
                return new HTMLParagraphs();
            }
            case "Iso690FormatDate": {
                return new Iso690FormatDate();
            }
            case "Iso690NamesAuthors": {
                return new Iso690NamesAuthors();
            }
            case "JournalAbbreviator": {
                return new JournalAbbreviator(this.prefs.getJournalAbbreviationLoader(), this.prefs.getJournalAbbreviationPreferences());
            }
            case "LastPage": {
                return new LastPage();
            }
            case "FormatChars": 
            case "LatexToUnicode": {
                return new LatexToUnicodeFormatter();
            }
            case "NameFormatter": {
                return new NameFormatter();
            }
            case "NoSpaceBetweenAbbreviations": {
                return new NoSpaceBetweenAbbreviations();
            }
            case "Ordinal": {
                return new Ordinal();
            }
            case "RemoveBrackets": {
                return new RemoveBrackets();
            }
            case "RemoveBracketsAddComma": {
                return new RemoveBracketsAddComma();
            }
            case "RemoveLatexCommands": {
                return new RemoveLatexCommandsFormatter();
            }
            case "RemoveTilde": {
                return new RemoveTilde();
            }
            case "RemoveWhitespace": {
                return new RemoveWhitespace();
            }
            case "RisKeywords": {
                return new RisKeywords();
            }
            case "RisMonth": {
                return new RisMonth();
            }
            case "RTFChars": {
                return new RTFChars();
            }
            case "ToLowerCase": {
                return new ToLowerCase();
            }
            case "ToUpperCase": {
                return new ToUpperCase();
            }
            case "XMLChars": {
                return new XMLChars();
            }
            case "Default": {
                return new Default();
            }
            case "FileLink": {
                return new FileLink(this.prefs.getFileLinkPreferences());
            }
            case "Number": {
                return new Number();
            }
            case "RisAuthors": {
                return new RisAuthors();
            }
            case "Authors": {
                return new Authors();
            }
            case "IfPlural": {
                return new IfPlural();
            }
            case "Replace": {
                return new Replace();
            }
            case "WrapContent": {
                return new WrapContent();
            }
            case "WrapFileLinks": {
                return new WrapFileLinks(this.prefs.getFileLinkPreferences());
            }
        }
        return new NotFoundFormatter(name);
    }

    private List<LayoutFormatter> getOptionalLayout(String formatterName) {
        List<List<String>> formatterStrings = LayoutEntry.parseMethodsCalls(formatterName);
        ArrayList<LayoutFormatter> results = new ArrayList<LayoutFormatter>(formatterStrings.size());
        Map<String, String> userNameFormatter = NameFormatter.getNameFormatters(this.prefs.getNameFormatterPreferences());
        for (List<String> strings : formatterStrings) {
            String nameFormatterName = strings.get(0).trim();
            Optional<String> contents = this.prefs.getCustomExportNameFormatter(nameFormatterName);
            if (contents.isPresent()) {
                NameFormatter nf = new NameFormatter();
                nf.setParameter(contents.get());
                results.add(nf);
                continue;
            }
            try {
                LayoutFormatter f = this.getLayoutFormatterByName(nameFormatterName);
                if (f instanceof ParamLayoutFormatter && strings.size() >= 2) {
                    ((ParamLayoutFormatter)f).setArgument(strings.get(1));
                }
                results.add(f);
            }
            catch (Exception ex) {
                LOGGER.info("Problem with formatter", ex);
                String formatterParameter = userNameFormatter.get(nameFormatterName);
                if (formatterParameter != null) {
                    NameFormatter nf = new NameFormatter();
                    nf.setParameter(formatterParameter);
                    results.add(nf);
                    continue;
                }
                results.add(new NotFoundFormatter(nameFormatterName));
            }
        }
        return results;
    }

    public List<String> getInvalidFormatters() {
        return this.invalidFormatter;
    }

    public static List<List<String>> parseMethodsCalls(String calls) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        char[] c = calls.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            String method;
            int start = i;
            if (!Character.isJavaIdentifierStart(c[i])) continue;
            ++i;
            while (i < c.length && (Character.isJavaIdentifierPart(c[i]) || c[i] == '.')) {
                ++i;
            }
            if (i < c.length && c[i] == '(') {
                method = calls.substring(start, i);
                int bracelevel = 0;
                if (++i < c.length) {
                    int startParam;
                    if (c[i] == '\"') {
                        startParam = ++i;
                        ++i;
                        boolean escaped = false;
                        while (i + 1 < c.length && (escaped || c[i] != '\"' || c[i + 1] != ')' || bracelevel != 0)) {
                            if (c[i] == '\\') {
                                escaped = !escaped;
                            } else if (c[i] == '(') {
                                ++bracelevel;
                            } else if (c[i] == ')') {
                                --bracelevel;
                            } else {
                                escaped = false;
                            }
                            ++i;
                        }
                        String param2 = calls.substring(startParam, i);
                        result.add(Arrays.asList(method, param2));
                        continue;
                    }
                    startParam = i;
                    while (i < c.length && (c[i] != ')' || bracelevel != 0)) {
                        if (c[i] == '(') {
                            ++bracelevel;
                        } else if (c[i] == ')') {
                            --bracelevel;
                        }
                        ++i;
                    }
                    String param3 = calls.substring(startParam, i);
                    result.add(Arrays.asList(method, param3));
                    continue;
                }
                result.add(Collections.singletonList(method));
                continue;
            }
            method = calls.substring(start, i);
            result.add(Collections.singletonList(method));
        }
        return result;
    }
}

