/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.journals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jabref.logic.journals.Abbreviation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalAbbreviationRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(JournalAbbreviationRepository.class);
    private final Set<Abbreviation> abbreviations = new HashSet<Abbreviation>(16000);

    public JournalAbbreviationRepository(Abbreviation ... abbreviations) {
        for (Abbreviation abbreviation : abbreviations) {
            this.addEntry(abbreviation);
        }
    }

    private static boolean isMatched(String name, Abbreviation abbreviation) {
        return name.equalsIgnoreCase(abbreviation.getName()) || name.equalsIgnoreCase(abbreviation.getIsoAbbreviation()) || name.equalsIgnoreCase(abbreviation.getMedlineAbbreviation());
    }

    private static boolean isMatchedAbbreviated(String name, Abbreviation abbreviation) {
        return name.equalsIgnoreCase(abbreviation.getIsoAbbreviation()) || name.equalsIgnoreCase(abbreviation.getMedlineAbbreviation());
    }

    public int size() {
        return this.abbreviations.size();
    }

    public boolean isKnownName(String journalName) {
        return this.abbreviations.stream().anyMatch(abbreviation -> JournalAbbreviationRepository.isMatched(journalName.trim(), abbreviation));
    }

    public boolean isAbbreviatedName(String journalName) {
        return this.abbreviations.stream().anyMatch(abbreviation -> JournalAbbreviationRepository.isMatchedAbbreviated(journalName.trim(), abbreviation));
    }

    public Optional<Abbreviation> getAbbreviation(String journalName) {
        return this.abbreviations.stream().filter(abbreviation -> JournalAbbreviationRepository.isMatched(journalName.trim(), abbreviation)).findFirst();
    }

    public void addEntry(Abbreviation abbreviation) {
        Objects.requireNonNull(abbreviation);
        if (this.abbreviations.contains(abbreviation)) {
            this.abbreviations.remove(abbreviation);
        }
        this.abbreviations.add(abbreviation);
    }

    public void addEntries(Collection<Abbreviation> abbreviationsToAdd) {
        abbreviationsToAdd.forEach(this::addEntry);
    }

    public Set<Abbreviation> getAbbreviations() {
        return Collections.unmodifiableSet(this.abbreviations);
    }

    public Optional<String> getNextAbbreviation(String text) {
        return this.getAbbreviation(text).map(abbreviation -> abbreviation.getNext(text));
    }

    public Optional<String> getMedlineAbbreviation(String text) {
        return this.getAbbreviation(text).map(Abbreviation::getMedlineAbbreviation);
    }

    public Optional<String> getIsoAbbreviation(String text) {
        return this.getAbbreviation(text).map(Abbreviation::getIsoAbbreviation);
    }
}

