/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.strings.StringUtil;

public class MonthChecker
implements ValueChecker {
    private static final Predicate<String> ONLY_AN_INTEGER = Pattern.compile("[1-9]|10|11|12").asPredicate();
    private static final Predicate<String> MONTH_NORMALIZED = Pattern.compile("#jan#|#feb#|#mar#|#apr#|#may#|#jun#|#jul#|#aug#|#sep#|#oct#|#nov#|#dec#").asPredicate();
    private final BibDatabaseContext bibDatabaseContextMonth;

    public MonthChecker(BibDatabaseContext bibDatabaseContext) {
        this.bibDatabaseContextMonth = Objects.requireNonNull(bibDatabaseContext);
    }

    @Override
    public Optional<String> checkValue(String value) {
        if (StringUtil.isBlank(value)) {
            return Optional.empty();
        }
        if (this.bibDatabaseContextMonth.isBiblatexMode() && !ONLY_AN_INTEGER.test(value.trim()) && !MONTH_NORMALIZED.test(value.trim())) {
            return Optional.of(Localization.lang("should be an integer or normalized", new String[0]));
        }
        if (!this.bibDatabaseContextMonth.isBiblatexMode() && !MONTH_NORMALIZED.test(value.trim())) {
            return Optional.of(Localization.lang("should be normalized", new String[0]));
        }
        return Optional.empty();
    }
}

