/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GvkParser
implements Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GvkParser.class);

    @Override
    public List<BibEntry> parseEntries(InputStream inputStream) throws ParseException {
        try {
            DocumentBuilder dbuild = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document content = dbuild.parse(inputStream);
            return this.parseEntries(content);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new ParseException(exception);
        }
    }

    private List<BibEntry> parseEntries(Document content) {
        LinkedList<BibEntry> result = new LinkedList<BibEntry>();
        Element root = (Element)content.getElementsByTagName("zs:searchRetrieveResponse").item(0);
        Element srwrecords = this.getChild("zs:records", root);
        if (srwrecords == null) {
            return result;
        }
        List<Element> records = this.getChildren("zs:record", srwrecords);
        for (Element record : records) {
            Element e = this.getChild("zs:recordData", record);
            if (e == null || (e = this.getChild("record", e)) == null) continue;
            result.add(this.parseEntry(e));
        }
        return result;
    }

    private BibEntry parseEntry(Element e) {
        String author = null;
        String editor = null;
        String title = null;
        String publisher = null;
        String year = null;
        String address = null;
        String series = null;
        String edition = null;
        String isbn = null;
        String issn = null;
        String number = null;
        String pagetotal = null;
        String volume = null;
        String pages = null;
        String journal = null;
        String ppn = null;
        String booktitle = null;
        String url = null;
        String note = null;
        String quelle = "";
        String mak = "";
        String subtitle = "";
        String entryType = "book";
        List<Element> datafields = this.getChildren("datafield", e);
        for (Element datafield : datafields) {
            String nachname;
            String vorname;
            String tag = datafield.getAttribute("tag");
            LOGGER.debug("tag: " + tag);
            if ("002@".equals(tag) && (mak = this.getSubfield("0", datafield)) == null) {
                mak = "";
            }
            if ("003@".equals(tag)) {
                ppn = this.getSubfield("0", datafield);
            }
            if ("028A".equals(tag)) {
                vorname = this.getSubfield("d", datafield);
                nachname = this.getSubfield("a", datafield);
                author = author == null ? "" : author.concat(" and ");
                author = author.concat(vorname + " " + nachname);
            }
            if ("028B".equals(tag)) {
                vorname = this.getSubfield("d", datafield);
                nachname = this.getSubfield("a", datafield);
                author = author == null ? "" : author.concat(" and ");
                author = author.concat(vorname + " " + nachname);
            }
            if ("028C".equals(tag)) {
                vorname = this.getSubfield("d", datafield);
                nachname = this.getSubfield("a", datafield);
                editor = editor == null ? "" : editor.concat(" and ");
                editor = editor.concat(vorname + " " + nachname);
            }
            if ("021A".equals(tag)) {
                title = this.getSubfield("a", datafield);
                subtitle = this.getSubfield("d", datafield);
            }
            if ("033A".equals(tag)) {
                publisher = this.getSubfield("n", datafield);
                address = this.getSubfield("p", datafield);
            }
            if ("011@".equals(tag)) {
                year = this.getSubfield("a", datafield);
            }
            if ("031A".equals(tag)) {
                year = this.getSubfield("j", datafield);
                volume = this.getSubfield("e", datafield);
                number = this.getSubfield("a", datafield);
                pages = this.getSubfield("h", datafield);
            }
            if ("036D".equals(tag)) {
                if (title != null) {
                    if (title.startsWith("@")) {
                        title = title.substring(1);
                    }
                    number = title;
                }
                title = this.getSubfield("a", datafield);
                subtitle = this.getSubfield("d", datafield);
                volume = this.getSubfield("l", datafield);
            }
            if ("036E".equals(tag)) {
                series = this.getSubfield("a", datafield);
                number = this.getSubfield("l", datafield);
                String kor = this.getSubfield("b", datafield);
                if (kor != null) {
                    series = series + " / " + kor;
                }
            }
            if ("037A".equals(tag)) {
                note = this.getSubfield("a", datafield);
            }
            if ("032@".equals(tag)) {
                edition = this.getSubfield("a", datafield);
            }
            if ("004A".equals(tag)) {
                String isbn10 = this.getSubfield("0", datafield);
                String isbn13 = this.getSubfield("A", datafield);
                if (isbn10 != null) {
                    isbn = isbn10;
                }
                if (isbn13 != null) {
                    isbn = isbn13;
                }
            }
            if ("037C".equals(tag)) {
                String st;
                if (address == null && (address = this.getSubfield("b", datafield)) != null) {
                    address = this.removeSortCharacters(address);
                }
                if ((st = this.getSubfield("a", datafield)) != null && st.contains("Diss")) {
                    entryType = "phdthesis";
                }
            }
            if ("027D".equals(tag)) {
                journal = this.getSubfield("a", datafield);
                booktitle = this.getSubfield("a", datafield);
                address = this.getSubfield("p", datafield);
                publisher = this.getSubfield("n", datafield);
            }
            if ("034D".equals(tag) && (pagetotal = this.getSubfield("a", datafield)) != null) {
                pagetotal = pagetotal.replaceAll(" S\\.?$", "");
            }
            if ("030F".equals(tag)) {
                address = this.getSubfield("k", datafield);
                if (!"proceedings".equals(entryType)) {
                    subtitle = this.getSubfield("a", datafield);
                }
                entryType = "proceedings";
            }
            if ("phdthesis".equals(entryType) && isbn != null) {
                entryType = "book";
            }
            if ("039B".equals(tag)) {
                quelle = this.getSubfield("8", datafield);
            }
            if ("046R".equals(tag) && (quelle == null || quelle.isEmpty())) {
                quelle = this.getSubfield("a", datafield);
            }
            if (!"009P".equals(tag) || !"03".equals(datafield.getAttribute("occurrence")) && !"05".equals(datafield.getAttribute("occurrence")) || url != null) continue;
            url = this.getSubfield("a", datafield);
        }
        if (quelle == null) {
            quelle = "";
        }
        if (author != null) {
            author = this.removeSortCharacters(author);
        }
        if (editor != null) {
            editor = this.removeSortCharacters(editor);
        }
        if (title != null) {
            title = this.removeSortCharacters(title);
        }
        if (subtitle != null) {
            subtitle = this.removeSortCharacters(subtitle);
        }
        if (mak.startsWith("As")) {
            entryType = "misc";
            if (quelle.contains("ISBN")) {
                entryType = "incollection";
            }
            if (quelle.contains("ZDB-ID")) {
                entryType = "article";
            }
        } else if (mak.isEmpty()) {
            entryType = "misc";
        } else if (mak.startsWith("O")) {
            entryType = "misc";
        }
        BibEntry result = new BibEntry(entryType);
        if (author != null) {
            result.setField("author", author);
        }
        if (editor != null) {
            result.setField("editor", editor);
        }
        if (title != null) {
            result.setField("title", title);
        }
        if (!Strings.isNullOrEmpty(subtitle)) {
            StringBuilder newSubtitle = new StringBuilder(Character.toString(Character.toUpperCase(subtitle.charAt(0))));
            if (subtitle.length() > 1) {
                newSubtitle.append(subtitle.substring(1));
            }
            result.setField("subtitle", newSubtitle.toString());
        }
        if (publisher != null) {
            result.setField("publisher", publisher);
        }
        if (year != null) {
            result.setField("year", year);
        }
        if (address != null) {
            result.setField("address", address);
        }
        if (series != null) {
            result.setField("series", series);
        }
        if (edition != null) {
            result.setField("edition", edition);
        }
        if (isbn != null) {
            result.setField("isbn", isbn);
        }
        if (issn != null) {
            result.setField("issn", issn);
        }
        if (number != null) {
            result.setField("number", number);
        }
        if (pagetotal != null) {
            result.setField("pagetotal", pagetotal);
        }
        if (pages != null) {
            result.setField("pages", pages);
        }
        if (volume != null) {
            result.setField("volume", volume);
        }
        if (journal != null) {
            result.setField("journal", journal);
        }
        if (ppn != null) {
            result.setField("ppn_GVK", ppn);
        }
        if (url != null) {
            result.setField("url", url);
        }
        if (note != null) {
            result.setField("note", note);
        }
        if ("article".equals(entryType) && journal != null) {
            result.setField("journal", journal);
        } else if ("incollection".equals(entryType) && booktitle != null) {
            result.setField("booktitle", booktitle);
        }
        return result;
    }

    private String getSubfield(String a, Element datafield) {
        List<Element> liste = this.getChildren("subfield", datafield);
        for (Element subfield : liste) {
            if (!subfield.getAttribute("code").equals(a)) continue;
            return subfield.getTextContent();
        }
        return null;
    }

    private Element getChild(String name, Element e) {
        if (e == null) {
            return null;
        }
        NodeList children = e.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Element entry;
            Node test = children.item(i);
            if (test.getNodeType() != 1 || !(entry = (Element)test).getTagName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    private List<Element> getChildren(String name, Element e) {
        LinkedList<Element> result = new LinkedList<Element>();
        NodeList children = e.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Element entry;
            Node test = children.item(i);
            if (test.getNodeType() != 1 || !(entry = (Element)test).getTagName().equals(name)) continue;
            result.add(entry);
        }
        return result;
    }

    private String removeSortCharacters(String input) {
        return input.replaceAll("\\@", "");
    }
}

