/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jabref.JabRefGUI;
import org.jabref.gui.BasePanel;
import org.jabref.gui.mergeentries.FetchAndMergeWorker;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldName;

public class FetchAndMergeEntry {
    public static List<String> SUPPORTED_FIELDS = Arrays.asList("doi", "eprint", "isbn");

    public FetchAndMergeEntry(BibEntry entry, BasePanel panel, String field2) {
        this(entry, panel, Arrays.asList(field2));
    }

    public FetchAndMergeEntry(BibEntry entry, String field2) {
        this(entry, JabRefGUI.getMainFrame().getCurrentBasePanel(), field2);
    }

    public FetchAndMergeEntry(BibEntry entry, BasePanel panel, List<String> fields) {
        for (String field2 : fields) {
            if (entry.hasField(field2)) {
                new FetchAndMergeWorker(panel, entry, field2).execute();
                continue;
            }
            panel.frame().setStatus(Localization.lang("No %0 found", FieldName.getDisplayName(field2)));
        }
    }

    public static String getDisplayNameOfSupportedFields() {
        return FieldName.orFields(SUPPORTED_FIELDS.stream().map(FieldName::getDisplayName).collect(Collectors.toList()));
    }
}

