/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.journals;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.journals.AbbreviationViewModel;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.journals.AbbreviationWriter;
import org.jabref.logic.journals.JournalAbbreviationLoader;

public class AbbreviationsFileViewModel {
    private final SimpleListProperty<AbbreviationViewModel> abbreviations = new SimpleListProperty(FXCollections.observableArrayList());
    private final ReadOnlyBooleanProperty isBuiltInList;
    private final String name;
    private final Optional<Path> path;

    public AbbreviationsFileViewModel(Path filePath) {
        this.path = Optional.ofNullable(filePath);
        this.name = this.path.get().toAbsolutePath().toString();
        this.isBuiltInList = new SimpleBooleanProperty(false);
        this.abbreviations.add((Object)new AbbreviationViewModel(null));
    }

    public AbbreviationsFileViewModel(List<AbbreviationViewModel> abbreviations, String name) {
        this.abbreviations.addAll(abbreviations);
        this.name = name;
        this.path = Optional.empty();
        this.isBuiltInList = new SimpleBooleanProperty(true);
    }

    public void readAbbreviations() throws FileNotFoundException {
        if (!this.path.isPresent()) {
            throw new FileNotFoundException();
        }
        List<Abbreviation> abbreviationList = JournalAbbreviationLoader.readJournalListFromFile(this.path.get().toFile());
        abbreviationList.forEach(abbreviation -> this.abbreviations.addAll((Object[])new AbbreviationViewModel[]{new AbbreviationViewModel((Abbreviation)abbreviation)}));
    }

    public void writeOrCreate() throws IOException {
        if (!this.isBuiltInList.get()) {
            List<Abbreviation> actualAbbreviations = this.abbreviations.stream().filter(abb -> !abb.isPseudoAbbreviation()).map(abb -> abb.getAbbreviationObject()).collect(Collectors.toList());
            AbbreviationWriter.writeOrCreate(this.path.get(), actualAbbreviations, StandardCharsets.UTF_8);
        }
    }

    public SimpleListProperty<AbbreviationViewModel> abbreviationsProperty() {
        return this.abbreviations;
    }

    public boolean exists() {
        return this.path.isPresent() && Files.exists(this.path.get(), new LinkOption[0]);
    }

    public Optional<Path> getAbsolutePath() {
        return this.path;
    }

    public ReadOnlyBooleanProperty isBuiltInListProperty() {
        return this.isBuiltInList;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbbreviationsFileViewModel) {
            return Objects.equals(this.name, ((AbbreviationsFileViewModel)obj).name);
        }
        return false;
    }
}

