/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.layout.HBox;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.fieldeditors.EditorTextArea;
import org.jabref.gui.fieldeditors.EditorValidator;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.UrlEditorViewModel;
import org.jabref.gui.util.ControlHelper;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.JabRefPreferences;

public class UrlEditor
extends HBox
implements FieldEditorFX {
    @FXML
    private UrlEditorViewModel viewModel;
    @FXML
    private EditorTextArea textArea;

    public UrlEditor(String fieldName, DialogService dialogService, AutoCompleteSuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, JabRefPreferences preferences) {
        this.viewModel = new UrlEditorViewModel(fieldName, suggestionProvider, dialogService, fieldCheckers);
        ControlHelper.loadFXMLForControl((Parent)this);
        this.textArea.textProperty().bindBidirectional((Property)this.viewModel.textProperty());
        new EditorValidator(preferences).configureValidation(this.viewModel.getFieldValidator().getValidationStatus(), this.textArea);
    }

    public UrlEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    @FXML
    private void openExternalLink(ActionEvent event) {
        this.viewModel.openExternalLink();
    }
}

