/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiletype;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.jabref.Globals;
import org.jabref.gui.IconTheme;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.externalfiletype.UnknownExternalFileType;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.FileFieldWriter;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.FileHelper;

public class ExternalFileTypes {
    private static final String FILE_TYPE_REMOVED_FLAG = "REMOVED";
    private static ExternalFileTypes singleton;
    private final Set<ExternalFileType> externalFileTypes = new TreeSet<ExternalFileType>();
    private final ExternalFileType HTML_FALLBACK_TYPE = new ExternalFileType("URL", "html", "text/html", "", "www", IconTheme.JabRefIcon.WWW.getSmallIcon());

    private ExternalFileTypes() {
        this.updateExternalFileTypes();
    }

    public static ExternalFileTypes getInstance() {
        if (singleton == null) {
            singleton = new ExternalFileTypes();
        }
        return singleton;
    }

    public static List<ExternalFileType> getDefaultExternalFileTypes() {
        ArrayList<ExternalFileType> list = new ArrayList<ExternalFileType>();
        list.add(new ExternalFileType("PDF", "pdf", "application/pdf", "evince", "pdfSmall", IconTheme.JabRefIcon.PDF_FILE.getSmallIcon()));
        list.add(new ExternalFileType("PostScript", "ps", "application/postscript", "evince", "psSmall", IconTheme.JabRefIcon.FILE.getSmallIcon()));
        list.add(new ExternalFileType("Word", "doc", "application/msword", "oowriter", "openoffice", IconTheme.JabRefIcon.FILE_WORD.getSmallIcon()));
        list.add(new ExternalFileType("Word 2007+", "docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "oowriter", "openoffice", IconTheme.JabRefIcon.FILE_WORD.getSmallIcon()));
        list.add(new ExternalFileType(Localization.lang("OpenDocument text", new String[0]), "odt", "application/vnd.oasis.opendocument.text", "oowriter", "openoffice", IconTheme.getImage("openoffice")));
        list.add(new ExternalFileType("Excel", "xls", "application/excel", "oocalc", "openoffice", IconTheme.JabRefIcon.FILE_EXCEL.getSmallIcon()));
        list.add(new ExternalFileType("Excel 2007+", "xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "oocalc", "openoffice", IconTheme.JabRefIcon.FILE_EXCEL.getSmallIcon()));
        list.add(new ExternalFileType(Localization.lang("OpenDocument spreadsheet", new String[0]), "ods", "application/vnd.oasis.opendocument.spreadsheet", "oocalc", "openoffice", IconTheme.getImage("openoffice")));
        list.add(new ExternalFileType("PowerPoint", "ppt", "application/vnd.ms-powerpoint", "ooimpress", "openoffice", IconTheme.JabRefIcon.FILE_POWERPOINT.getSmallIcon()));
        list.add(new ExternalFileType("PowerPoint 2007+", "pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "ooimpress", "openoffice", IconTheme.JabRefIcon.FILE_POWERPOINT.getSmallIcon()));
        list.add(new ExternalFileType(Localization.lang("OpenDocument presentation", new String[0]), "odp", "application/vnd.oasis.opendocument.presentation", "ooimpress", "openoffice", IconTheme.getImage("openoffice")));
        list.add(new ExternalFileType("Rich Text Format", "rtf", "application/rtf", "oowriter", "openoffice", IconTheme.JabRefIcon.FILE_TEXT.getSmallIcon()));
        list.add(new ExternalFileType(Localization.lang("%0 image", "PNG"), "png", "image/png", "gimp", "picture", IconTheme.JabRefIcon.PICTURE.getSmallIcon()));
        list.add(new ExternalFileType(Localization.lang("%0 image", "GIF"), "gif", "image/gif", "gimp", "picture", IconTheme.JabRefIcon.PICTURE.getSmallIcon()));
        list.add(new ExternalFileType(Localization.lang("%0 image", "JPG"), "jpg", "image/jpeg", "gimp", "picture", IconTheme.JabRefIcon.PICTURE.getSmallIcon()));
        list.add(new ExternalFileType("Djvu", "djvu", "image/vnd.djvu", "evince", "psSmall", IconTheme.JabRefIcon.FILE.getSmallIcon()));
        list.add(new ExternalFileType("Text", "txt", "text/plain", "emacs", "emacs", IconTheme.JabRefIcon.FILE_TEXT.getSmallIcon()));
        list.add(new ExternalFileType("LaTeX", "tex", "application/x-latex", "emacs", "emacs", IconTheme.JabRefIcon.FILE_TEXT.getSmallIcon()));
        list.add(new ExternalFileType("CHM", "chm", "application/mshelp", "gnochm", "www", IconTheme.JabRefIcon.WWW.getSmallIcon()));
        list.add(new ExternalFileType(Localization.lang("%0 image", "TIFF"), "tiff", "image/tiff", "gimp", "picture", IconTheme.JabRefIcon.PICTURE.getSmallIcon()));
        list.add(new ExternalFileType("URL", "html", "text/html", "firefox", "www", IconTheme.JabRefIcon.WWW.getSmallIcon()));
        list.add(new ExternalFileType("MHT", "mht", "multipart/related", "firefox", "www", IconTheme.JabRefIcon.WWW.getSmallIcon()));
        list.add(new ExternalFileType("ePUB", "epub", "application/epub+zip", "firefox", "www", IconTheme.JabRefIcon.WWW.getSmallIcon()));
        for (ExternalFileType type : list) {
            type.setOpenWith("");
        }
        return list;
    }

    public Set<ExternalFileType> getExternalFileTypeSelection() {
        return this.externalFileTypes;
    }

    public Optional<ExternalFileType> getExternalFileTypeByName(String name) {
        Optional<ExternalFileType> externalFileType = this.externalFileTypes.stream().filter(type -> type.getExtension().equals(name)).findFirst();
        if (externalFileType.isPresent()) {
            return externalFileType;
        }
        return Optional.of(new UnknownExternalFileType(name));
    }

    public Optional<ExternalFileType> getExternalFileTypeByExt(String extension) {
        return this.externalFileTypes.stream().filter(type -> type.getExtension().equalsIgnoreCase(extension)).findFirst();
    }

    public boolean isExternalFileTypeByExt(String extension) {
        return this.externalFileTypes.stream().anyMatch(type -> type.getExtension().equalsIgnoreCase(extension));
    }

    public Optional<ExternalFileType> getExternalFileTypeForName(String filename) {
        int longestFound = -1;
        ExternalFileType foundType = null;
        for (ExternalFileType type : this.externalFileTypes) {
            if (type.getExtension().isEmpty() || !filename.toLowerCase(Locale.ROOT).endsWith(type.getExtension().toLowerCase(Locale.ROOT)) || type.getExtension().length() <= longestFound) continue;
            longestFound = type.getExtension().length();
            foundType = type;
        }
        return Optional.ofNullable(foundType);
    }

    public Optional<ExternalFileType> getExternalFileTypeByMimeType(String mimeType) {
        for (ExternalFileType type : this.externalFileTypes) {
            if (!type.getMimeType().equalsIgnoreCase(mimeType)) continue;
            return Optional.of(type);
        }
        if ("text/html".equalsIgnoreCase(mimeType)) {
            return Optional.of(this.HTML_FALLBACK_TYPE);
        }
        return Optional.empty();
    }

    public void setExternalFileTypes(List<ExternalFileType> types) {
        List<ExternalFileType> defTypes = ExternalFileTypes.getDefaultExternalFileTypes();
        ArrayList<ExternalFileType> unchanged = new ArrayList<ExternalFileType>();
        this.externalFileTypes.clear();
        for (ExternalFileType type : types) {
            this.externalFileTypes.add(type);
            ExternalFileType found = null;
            for (ExternalFileType defType : defTypes) {
                if (!defType.getName().equals(type.getName())) continue;
                found = defType;
                break;
            }
            if (found == null) continue;
            if (found.equals(type)) {
                unchanged.add(type);
                continue;
            }
            defTypes.remove(found);
        }
        for (ExternalFileType type : unchanged) {
            defTypes.remove(type);
            types.remove(type);
        }
        String[][] array = new String[types.size() + defTypes.size()][];
        int i = 0;
        for (ExternalFileType type : types) {
            array[i] = type.getStringArrayRepresentation();
            ++i;
        }
        for (ExternalFileType type : defTypes) {
            array[i] = new String[]{type.getName(), FILE_TYPE_REMOVED_FLAG};
            ++i;
        }
        Globals.prefs.put("externalFileTypes", FileFieldWriter.encodeStringArray(array));
    }

    private void updateExternalFileTypes() {
        String[][] vals;
        List<ExternalFileType> types = ExternalFileTypes.getDefaultExternalFileTypes();
        if (Globals.prefs.get("externalFileTypes", null) == null) {
            this.externalFileTypes.clear();
            this.externalFileTypes.addAll(types);
            return;
        }
        for (String[] val : vals = StringUtil.decodeStringDoubleArray(Globals.prefs.get("externalFileTypes", ""))) {
            if (val.length == 2 && val[1].equals(FILE_TYPE_REMOVED_FLAG)) {
                ExternalFileType toRemove = null;
                for (ExternalFileType type : types) {
                    if (!type.getName().equals(val[0])) continue;
                    toRemove = type;
                    break;
                }
                if (toRemove == null) continue;
                types.remove(toRemove);
                continue;
            }
            ExternalFileType type = ExternalFileType.buildFromArgs(val);
            ExternalFileType toRemove = null;
            for (ExternalFileType defType : types) {
                if (!type.getName().equals(defType.getName())) continue;
                toRemove = defType;
                break;
            }
            if (toRemove != null) {
                types.remove(toRemove);
            }
            types.add(type);
        }
        this.externalFileTypes.addAll(types);
    }

    public Optional<ExternalFileType> getExternalFileTypeByFile(Path file) {
        String filePath = file.toString();
        Optional<String> extension = FileHelper.getFileExtension(filePath);
        return extension.flatMap(this::getExternalFileTypeByExt);
    }

    public Optional<ExternalFileType> fromLinkedFile(LinkedFile linkedFile, boolean deduceUnknownType) {
        boolean isUnknownType;
        Optional<ExternalFileType> type = this.getExternalFileTypeByName(linkedFile.getFileType());
        boolean bl = isUnknownType = !type.isPresent() || type.get() instanceof UnknownExternalFileType;
        if (isUnknownType && deduceUnknownType) {
            Optional<ExternalFileType> mimeType = this.getExternalFileTypeByMimeType(linkedFile.getFileType());
            if (mimeType.isPresent()) {
                return mimeType;
            }
            return FileHelper.getFileExtension(linkedFile.getLink()).flatMap(this::getExternalFileTypeByExt);
        }
        return type;
    }
}

