/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.externalfiles;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferableFileLinkSelection
implements Transferable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferableFileLinkSelection.class);
    private final List<Path> fileList = new ArrayList<Path>();

    public TransferableFileLinkSelection(BasePanel panel, List<BibEntry> selection) {
        BibEntry entry = selection.get(0);
        List<LinkedFile> files = entry.getFiles();
        if (!files.isEmpty()) {
            LinkedFile firstFile = files.get(0);
            firstFile.findIn(panel.getBibDatabaseContext(), Globals.prefs.getFileDirectoryPreferences()).ifPresent(this.fileList::add);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.javaFileListFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        LOGGER.debug("Query: " + dataFlavor.getHumanPresentableName() + " , " + dataFlavor.getDefaultRepresentationClass() + " , " + dataFlavor.getMimeType());
        return dataFlavor.equals(DataFlavor.javaFileListFlavor) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this.fileList;
    }
}

