/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.TextInputControl;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.jabref.gui.autocompleter.AutoCompletionInput;
import org.jabref.gui.autocompleter.AutoCompletionStrategy;
import org.jabref.gui.autocompleter.ReplaceStrategy;

public class AutoCompletionTextInputBinding<T>
extends AutoCompletionBinding<T> {
    private StringConverter<T> converter;
    private AutoCompletionStrategy inputAnalyzer;
    private final ChangeListener<String> textChangeListener = (obs, oldText, newText) -> {
        if (this.getCompletionTarget().isFocused()) {
            this.setUserInputText((String)newText);
        }
    };
    private boolean showOnFocus;
    private final ChangeListener<Boolean> focusChangedListener = (obs, oldFocused, newFocused) -> {
        if (newFocused.booleanValue()) {
            if (this.showOnFocus) {
                this.setUserInputText(this.getCompletionTarget().getText());
            }
        } else {
            this.hidePopup();
        }
    };

    private AutoCompletionTextInputBinding(TextInputControl textInputControl, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> suggestionProvider) {
        this(textInputControl, suggestionProvider, AutoCompletionTextInputBinding.defaultStringConverter(), new ReplaceStrategy());
    }

    private AutoCompletionTextInputBinding(TextInputControl textInputControl, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> suggestionProvider, StringConverter<T> converter) {
        this(textInputControl, suggestionProvider, converter, new ReplaceStrategy());
    }

    private AutoCompletionTextInputBinding(TextInputControl textInputControl, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> suggestionProvider, StringConverter<T> converter, AutoCompletionStrategy inputAnalyzer) {
        super((Node)textInputControl, suggestionProvider, converter);
        this.converter = converter;
        this.inputAnalyzer = inputAnalyzer;
        this.getCompletionTarget().textProperty().addListener(this.textChangeListener);
        this.getCompletionTarget().focusedProperty().addListener(this.focusChangedListener);
    }

    private static <T> StringConverter<T> defaultStringConverter() {
        return new StringConverter<T>(){

            public String toString(T t) {
                return t == null ? null : t.toString();
            }

            public T fromString(String string) {
                return string;
            }
        };
    }

    public static <T> void autoComplete(TextInputControl textArea, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> suggestionProvider) {
        new AutoCompletionTextInputBinding<T>(textArea, suggestionProvider);
    }

    public static <T> void autoComplete(TextInputControl textArea, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> suggestionProvider, StringConverter<T> converter) {
        new AutoCompletionTextInputBinding<T>(textArea, suggestionProvider, converter);
    }

    public static <T> AutoCompletionTextInputBinding<T> autoComplete(TextInputControl textArea, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> suggestionProvider, StringConverter<T> converter, AutoCompletionStrategy inputAnalyzer) {
        return new AutoCompletionTextInputBinding<T>(textArea, suggestionProvider, converter, inputAnalyzer);
    }

    public static <T> AutoCompletionTextInputBinding<T> autoComplete(TextInputControl textArea, Callback<AutoCompletionBinding.ISuggestionRequest, Collection<T>> suggestionProvider, AutoCompletionStrategy inputAnalyzer) {
        return AutoCompletionTextInputBinding.autoComplete(textArea, suggestionProvider, AutoCompletionTextInputBinding.defaultStringConverter(), inputAnalyzer);
    }

    private void setUserInputText(String newText) {
        if (newText == null) {
            newText = "";
        }
        AutoCompletionInput input = this.inputAnalyzer.analyze(newText);
        this.setUserInput(input.getUnfinishedPart());
    }

    public TextInputControl getCompletionTarget() {
        return (TextInputControl)super.getCompletionTarget();
    }

    @Override
    public void dispose() {
        this.getCompletionTarget().textProperty().removeListener(this.textChangeListener);
        this.getCompletionTarget().focusedProperty().removeListener(this.focusChangedListener);
    }

    @Override
    protected void completeUserInput(T completion) {
        String completionText = this.converter.toString(completion);
        String inputText = this.getCompletionTarget().getText();
        if (inputText == null) {
            inputText = "";
        }
        AutoCompletionInput input = this.inputAnalyzer.analyze(inputText);
        String newText = input.getPrefix() + completionText;
        this.getCompletionTarget().setText(newText);
        this.getCompletionTarget().positionCaret(newText.length());
    }

    public void setShowOnFocus(boolean showOnFocus) {
        this.showOnFocus = showOnFocus;
    }
}

