/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.json;

import de.undercouch.citeproc.helper.json.JsonBuilder;
import de.undercouch.citeproc.helper.json.JsonBuilderFactory;
import de.undercouch.citeproc.helper.json.JsonObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapJsonBuilder
implements JsonBuilder {
    private final JsonBuilderFactory factory;
    private final Map<String, Object> m;

    public MapJsonBuilder(JsonBuilderFactory factory) {
        this.factory = factory;
        this.m = new LinkedHashMap<String, Object>();
    }

    @Override
    public JsonBuilder add(String name, Object o) {
        this.m.put(name, MapJsonBuilder.toJson(o, this.factory));
        return this;
    }

    @Override
    public Map<String, Object> build() {
        return this.m;
    }

    @Override
    public Object toJson(Object arr) {
        return MapJsonBuilder.toJson(arr, this.factory);
    }

    private static Object toJson(Object obj, JsonBuilderFactory factory) {
        if (obj instanceof JsonObject) {
            return ((JsonObject)obj).toJson(factory.createJsonBuilder());
        }
        if (obj.getClass().isArray()) {
            ArrayList<Object> r = new ArrayList<Object>();
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object ao = Array.get(obj, i);
                r.add(MapJsonBuilder.toJson(ao, factory));
            }
            return r;
        }
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            ArrayList<Object> r = new ArrayList<Object>();
            for (Object ao : coll) {
                r.add(MapJsonBuilder.toJson(ao, factory));
            }
            return r;
        }
        if (obj instanceof Map) {
            Map m3 = (Map)obj;
            LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>();
            for (Map.Entry e : m3.entrySet()) {
                String key = MapJsonBuilder.toJson(e.getKey(), factory).toString();
                Object value = MapJsonBuilder.toJson(e.getValue(), factory);
                r.put(key, value);
            }
            return r;
        }
        return obj;
    }
}

