/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation.visualization;

import de.saxsys.mvvmfx.utils.validation.Severity;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.visualization.ValidationVisualizerBase;
import java.util.Optional;
import javafx.scene.control.Control;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.decoration.GraphicValidationDecoration;
import org.controlsfx.validation.decoration.ValidationDecoration;

public class ControlsFxVisualizer
extends ValidationVisualizerBase {
    private ValidationDecoration decoration = new GraphicValidationDecoration();

    public void setDecoration(ValidationDecoration decoration) {
        this.decoration = decoration;
    }

    @Override
    void applyRequiredVisualization(Control control, boolean required) {
        ValidationSupport.setRequired(control, required);
        if (required) {
            this.decoration.applyRequiredDecoration(control);
        }
    }

    @Override
    void applyVisualization(Control control, Optional<ValidationMessage> messageOptional, boolean required) {
        if (messageOptional.isPresent()) {
            ValidationMessage message = messageOptional.get();
            this.decoration.removeDecorations(control);
            if (Severity.ERROR.equals((Object)message.getSeverity())) {
                this.decoration.applyValidationDecoration(org.controlsfx.validation.ValidationMessage.error(control, message.getMessage()));
            } else if (Severity.WARNING.equals((Object)message.getSeverity())) {
                this.decoration.applyValidationDecoration(org.controlsfx.validation.ValidationMessage.warning(control, message.getMessage()));
            }
        } else {
            this.decoration.removeDecorations(control);
        }
        if (required) {
            this.decoration.applyRequiredDecoration(control);
        }
    }
}

