/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.helper;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyChangeEvent;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalAccessException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.WrappedTargetRuntimeException;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.reflection.XCompoundTypeDescription;
import com.sun.star.reflection.XIdlClass;
import com.sun.star.reflection.XIdlField2;
import com.sun.star.reflection.XIndirectTypeDescription;
import com.sun.star.reflection.XInterfaceAttributeTypeDescription2;
import com.sun.star.reflection.XInterfaceMemberTypeDescription;
import com.sun.star.reflection.XInterfaceTypeDescription2;
import com.sun.star.reflection.XStructTypeDescription;
import com.sun.star.reflection.XTypeDescription;
import com.sun.star.reflection.theCoreReflection;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertySetMixin {
    private final XComponentContext context;
    private final XInterface object;
    private final Type type;
    private final String[] absentOptional;
    private final XIdlClass idlClass;
    private final Map<String, PropertyData> properties;
    private final String[] handleMap;
    private HashMap<String, ArrayList<XPropertyChangeListener>> boundListeners = new HashMap();
    private HashMap<String, ArrayList<XVetoableChangeListener>> vetoListeners = new HashMap();
    private boolean disposed = false;

    public PropertySetMixin(XComponentContext context, XInterface object, Type type, String[] absentOptional) {
        XTypeDescription ifc;
        this.context = context;
        this.object = object;
        this.type = type;
        this.absentOptional = absentOptional;
        this.idlClass = this.getReflection(type.getTypeName());
        try {
            XHierarchicalNameAccess xhna = UnoRuntime.queryInterface(XHierarchicalNameAccess.class, context.getValueByName("/singletons/com.sun.star.reflection.theTypeDescriptionManager"));
            ifc = UnoRuntime.queryInterface(XTypeDescription.class, xhna.getByHierarchicalName(type.getTypeName()));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, PropertyData> map = new HashMap<String, PropertyData>();
        ArrayList<String> handleNames = new ArrayList<String>();
        this.initProperties(ifc, map, handleNames, new HashSet<String>());
        this.properties = map;
        this.handleMap = handleNames.toArray(new String[handleNames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareSet(String propertyName, Object oldValue, Object newValue, BoundListeners bound) throws PropertyVetoException {
        Property p = this.properties.get((Object)propertyName).property;
        ArrayList<XVetoableChangeListener> specificVeto = null;
        ArrayList<XVetoableChangeListener> unspecificVeto = null;
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            ArrayList<XEventListener> o;
            if (this.disposed) {
                throw new DisposedException("disposed", this.object);
            }
            if ((p.Attributes & 4) != 0) {
                o = this.vetoListeners.get(propertyName);
                if (o != null) {
                    specificVeto = new ArrayList<XVetoableChangeListener>(o);
                }
                if ((o = this.vetoListeners.get("")) != null) {
                    unspecificVeto = new ArrayList<XVetoableChangeListener>(o);
                }
            }
            if ((p.Attributes & 2) != 0) {
                o = this.boundListeners.get(propertyName);
                if (o != null) {
                    bound.specificListeners = new ArrayList<XVetoableChangeListener>(o);
                }
                if ((o = this.boundListeners.get("")) != null) {
                    bound.unspecificListeners = new ArrayList<XVetoableChangeListener>(o);
                }
            }
        }
        if ((p.Attributes & 4) != 0) {
            Iterator<XVetoableChangeListener> i;
            PropertyChangeEvent event = new PropertyChangeEvent(this.object, propertyName, false, p.Handle, oldValue, newValue);
            if (specificVeto != null) {
                i = specificVeto.iterator();
                while (i.hasNext()) {
                    try {
                        i.next().vetoableChange(event);
                    }
                    catch (DisposedException disposedException) {}
                }
            }
            if (unspecificVeto != null) {
                i = unspecificVeto.iterator();
                while (i.hasNext()) {
                    try {
                        i.next().vetoableChange(event);
                    }
                    catch (DisposedException disposedException) {}
                }
            }
        }
        if ((p.Attributes & 2) != 0) {
            bound.event = new PropertyChangeEvent(this.object, propertyName, false, p.Handle, oldValue, newValue);
        }
    }

    public void prepareSet(String propertyName, BoundListeners bound) {
        try {
            this.prepareSet(propertyName, Any.VOID, Any.VOID, bound);
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException("unexpected " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Iterator<XEventListener> j;
        Iterator<ArrayList<XEventListener>> i;
        HashMap<String, ArrayList<XVetoableChangeListener>> veto;
        HashMap<String, ArrayList<XPropertyChangeListener>> bound;
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            bound = this.boundListeners;
            this.boundListeners = null;
            veto = this.vetoListeners;
            this.vetoListeners = null;
            this.disposed = true;
        }
        EventObject event = new EventObject(this.object);
        if (bound != null) {
            i = bound.values().iterator();
            while (i.hasNext()) {
                j = i.next().iterator();
                while (j.hasNext()) {
                    ((XPropertyChangeListener)j.next()).disposing(event);
                }
            }
        }
        if (veto != null) {
            i = veto.values().iterator();
            while (i.hasNext()) {
                j = i.next().iterator();
                while (j.hasNext()) {
                    ((XVetoableChangeListener)j.next()).disposing(event);
                }
            }
        }
    }

    public XPropertySetInfo getPropertySetInfo() {
        return new Info(this.properties);
    }

    public void setPropertyValue(String propertyName, Object value) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.setProperty(propertyName, value, false, false, (short)1);
    }

    public Object getPropertyValue(String propertyName) throws UnknownPropertyException, WrappedTargetException {
        return this.getProperty(propertyName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String propertyName, XPropertyChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        boolean disp;
        this.checkUnknown(propertyName);
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            disp = this.disposed;
            if (!disp) {
                ArrayList<XPropertyChangeListener> v = this.boundListeners.get(propertyName);
                if (v == null) {
                    v = new ArrayList();
                    this.boundListeners.put(propertyName, v);
                }
                v.add(listener);
            }
        }
        if (disp) {
            listener.disposing(new EventObject(this.object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String propertyName, XPropertyChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        this.checkUnknown(propertyName);
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            ArrayList<XPropertyChangeListener> v;
            if (this.boundListeners != null && (v = this.boundListeners.get(propertyName)) != null) {
                v.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(String propertyName, XVetoableChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        boolean disp;
        this.checkUnknown(propertyName);
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            disp = this.disposed;
            if (!disp) {
                ArrayList<XVetoableChangeListener> v = this.vetoListeners.get(propertyName);
                if (v == null) {
                    v = new ArrayList();
                    this.vetoListeners.put(propertyName, v);
                }
                v.add(listener);
            }
        }
        if (disp) {
            listener.disposing(new EventObject(this.object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVetoableChangeListener(String propertyName, XVetoableChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        this.checkUnknown(propertyName);
        PropertySetMixin propertySetMixin = this;
        synchronized (propertySetMixin) {
            ArrayList<XVetoableChangeListener> v;
            if (this.vetoListeners != null && (v = this.vetoListeners.get(propertyName)) != null) {
                v.remove(listener);
            }
        }
    }

    public void setFastPropertyValue(int handle, Object value) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.setProperty(this.translateHandle(handle), value, false, false, (short)1);
    }

    public Object getFastPropertyValue(int handle) throws UnknownPropertyException, WrappedTargetException {
        return this.getProperty(this.translateHandle(handle), null);
    }

    public PropertyValue[] getPropertyValues() {
        PropertyValue[] s2 = new PropertyValue[this.handleMap.length];
        int n = 0;
        for (int i = 0; i < this.handleMap.length; ++i) {
            Object value;
            PropertyState[] state = new PropertyState[1];
            try {
                value = this.getProperty(this.handleMap[i], state);
            }
            catch (UnknownPropertyException e) {
                continue;
            }
            catch (WrappedTargetException e) {
                throw new WrappedTargetRuntimeException(e.getCause(), e.getMessage(), this.object, e.TargetException);
            }
            s2[n++] = new PropertyValue(this.handleMap[i], i, value, state[0]);
        }
        if (n < this.handleMap.length) {
            PropertyValue[] s22 = new PropertyValue[n];
            System.arraycopy(s2, 0, s22, 0, n);
            s2 = s22;
        }
        return s2;
    }

    public void setPropertyValues(PropertyValue[] props) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        for (int i = 0; i < props.length; ++i) {
            if (props[i].Handle != -1 && !props[i].Name.equals(this.translateHandle(props[i].Handle))) {
                throw new UnknownPropertyException("name " + props[i].Name + " does not match handle " + props[i].Handle, this.object);
            }
            this.setProperty(props[i].Name, props[i].Value, props[i].State == PropertyState.AMBIGUOUS_VALUE, props[i].State == PropertyState.DEFAULT_VALUE, (short)0);
        }
    }

    private XIdlClass getReflection(String typeName) {
        return theCoreReflection.get(this.context).forName(typeName);
    }

    private void initProperties(XTypeDescription type, HashMap<String, PropertyData> map, ArrayList<String> handleNames, HashSet<String> seen) {
        XInterfaceTypeDescription2 ifc = UnoRuntime.queryInterface(XInterfaceTypeDescription2.class, (Object)PropertySetMixin.resolveTypedefs(type));
        if (!seen.add(ifc.getName())) {
            return;
        }
        XTypeDescription[] bases = ifc.getBaseTypes();
        for (int i = 0; i < bases.length; ++i) {
            this.initProperties(bases[i], map, handleNames, seen);
        }
        XInterfaceMemberTypeDescription[] members = ifc.getMembers();
        for (int i = 0; i < members.length; ++i) {
            int j;
            if (members[i].getTypeClass() != TypeClass.INTERFACE_ATTRIBUTE) continue;
            XInterfaceAttributeTypeDescription2 attr = UnoRuntime.queryInterface(XInterfaceAttributeTypeDescription2.class, (Object)members[i]);
            short attrAttribs = 0;
            if (attr.isBound()) {
                attrAttribs = (short)(attrAttribs | 2);
            }
            boolean setUnknown = false;
            if (attr.isReadOnly()) {
                attrAttribs = (short)(attrAttribs | 0x10);
                setUnknown = true;
            }
            XCompoundTypeDescription[] excs = attr.getGetExceptions();
            boolean getUnknown = false;
            for (j = 0; j < excs.length; ++j) {
                if (!excs[j].getName().equals("com.sun.star.beans.UnknownPropertyException")) continue;
                getUnknown = true;
                break;
            }
            excs = attr.getSetExceptions();
            for (j = 0; j < excs.length; ++j) {
                if (excs[j].getName().equals("com.sun.star.beans.UnknownPropertyException")) {
                    setUnknown = true;
                    continue;
                }
                if (!excs[j].getName().equals("com.sun.star.beans.PropertyVetoException")) continue;
                attrAttribs = (short)(attrAttribs | 4);
            }
            if (getUnknown && setUnknown) {
                attrAttribs = (short)(attrAttribs | 0x100);
            }
            XTypeDescription t = attr.getType();
            while (true) {
                int n;
                if ((t = PropertySetMixin.resolveTypedefs(t)).getName().startsWith("com.sun.star.beans.Ambiguous<")) {
                    n = 32;
                } else if (t.getName().startsWith("com.sun.star.beans.Defaulted<")) {
                    n = 64;
                } else {
                    if (!t.getName().startsWith("com.sun.star.beans.Optional<")) break;
                    n = 1;
                }
                attrAttribs = (short)(attrAttribs | n);
                t = UnoRuntime.queryInterface(XStructTypeDescription.class, (Object)t).getTypeArguments()[0];
            }
            String name = members[i].getMemberName();
            boolean present = true;
            if (this.absentOptional != null) {
                for (int j2 = 0; j2 < this.absentOptional.length; ++j2) {
                    if (!name.equals(this.absentOptional[j2])) continue;
                    present = false;
                    break;
                }
            }
            if (map.put(name, new PropertyData(new Property(name, handleNames.size(), new Type(t.getName(), t.getTypeClass()), attrAttribs), present)) != null) {
                throw new RuntimeException("inconsistent UNO type registry");
            }
            handleNames.add(name);
        }
    }

    private String translateHandle(int handle) throws UnknownPropertyException {
        if (handle < 0 || handle >= this.handleMap.length) {
            throw new UnknownPropertyException("bad handle " + handle, this.object);
        }
        return this.handleMap[handle];
    }

    private void setProperty(String name, Object value, boolean isAmbiguous, boolean isDefaulted, short illegalArgumentPosition) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        PropertyData p = this.properties.get(name);
        if (p == null) {
            throw new UnknownPropertyException(name, this.object);
        }
        if (isAmbiguous && (p.property.Attributes & 0x20) == 0 || isDefaulted && (p.property.Attributes & 0x40) == 0) {
            throw new IllegalArgumentException("flagging as ambiguous/defaulted non-ambiguous/defaulted property " + name, this.object, illegalArgumentPosition);
        }
        XIdlField2 f = UnoRuntime.queryInterface(XIdlField2.class, (Object)this.idlClass.getField(name));
        Object[] o = new Object[]{new Any(this.type, UnoRuntime.queryInterface(this.type, (Object)this.object))};
        Object v = this.wrapValue(value, UnoRuntime.queryInterface(XIdlField2.class, (Object)this.idlClass.getField(name)).getType(), (p.property.Attributes & 0x20) != 0, isAmbiguous, (p.property.Attributes & 0x40) != 0, isDefaulted, (p.property.Attributes & 1) != 0);
        try {
            f.set(o, v);
        }
        catch (IllegalArgumentException e) {
            if (e.ArgumentPosition == 1) {
                throw new IllegalArgumentException(e, e.getMessage(), this.object, illegalArgumentPosition);
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyVetoException(e, "cannot set read-only property " + name, this.object);
        }
        catch (WrappedTargetRuntimeException e) {
            if (new Type(UnknownPropertyException.class).isSupertypeOf(AnyConverter.getType(e.TargetException)) && (p.property.Attributes & 0x100) != 0) {
                throw new UnknownPropertyException(e, name, this.object);
            }
            if (new Type(PropertyVetoException.class).isSupertypeOf(AnyConverter.getType(e.TargetException)) && (p.property.Attributes & 4) != 0) {
                throw new PropertyVetoException(e, name, this.object);
            }
            throw new WrappedTargetException(e.getCause(), e.getMessage(), this.object, e.TargetException);
        }
    }

    Object getProperty(String name, PropertyState[] state) throws UnknownPropertyException, WrappedTargetException {
        Object value;
        PropertyData p = this.properties.get(name);
        if (p == null) {
            throw new UnknownPropertyException(name, this.object);
        }
        XIdlField2 field2 = UnoRuntime.queryInterface(XIdlField2.class, (Object)this.idlClass.getField(name));
        try {
            value = field2.get(new Any(this.type, UnoRuntime.queryInterface(this.type, (Object)this.object)));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (WrappedTargetRuntimeException e) {
            if (new Type(UnknownPropertyException.class).isSupertypeOf(AnyConverter.getType(e.TargetException)) && (p.property.Attributes & 0x100) != 0) {
                throw new UnknownPropertyException(e, name, this.object);
            }
            throw new WrappedTargetException(e.getCause(), e.getMessage(), this.object, e.TargetException);
        }
        boolean undoAmbiguous = (p.property.Attributes & 0x20) != 0;
        boolean undoDefaulted = (p.property.Attributes & 0x40) != 0;
        boolean undoOptional = (p.property.Attributes & 1) != 0;
        boolean isAmbiguous = false;
        boolean isDefaulted = false;
        while (undoAmbiguous || undoDefaulted || undoOptional) {
            String typeName = AnyConverter.getType(value).getTypeName();
            if (undoAmbiguous && typeName.startsWith("com.sun.star.beans.Ambiguous<")) {
                XIdlClass ambiguous = this.getReflection(typeName);
                try {
                    isAmbiguous = AnyConverter.toBoolean(UnoRuntime.queryInterface(XIdlField2.class, (Object)ambiguous.getField("IsAmbiguous")).get(value));
                    value = UnoRuntime.queryInterface(XIdlField2.class, (Object)ambiguous.getField("Value")).get(value);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                undoAmbiguous = false;
                continue;
            }
            if (undoDefaulted && typeName.startsWith("com.sun.star.beans.Defaulted<")) {
                XIdlClass defaulted = this.getReflection(typeName);
                try {
                    isDefaulted = AnyConverter.toBoolean(UnoRuntime.queryInterface(XIdlField2.class, (Object)defaulted.getField("IsDefaulted")).get(value));
                    value = UnoRuntime.queryInterface(XIdlField2.class, (Object)defaulted.getField("Value")).get(value);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                undoDefaulted = false;
                continue;
            }
            if (undoOptional && typeName.startsWith("com.sun.star.beans.Optional<")) {
                XIdlClass optional = this.getReflection(typeName);
                try {
                    boolean present = AnyConverter.toBoolean(UnoRuntime.queryInterface(XIdlField2.class, (Object)optional.getField("IsPresent")).get(value));
                    if (!present) {
                        value = Any.VOID;
                        break;
                    }
                    value = UnoRuntime.queryInterface(XIdlField2.class, (Object)optional.getField("Value")).get(value);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                undoOptional = false;
                continue;
            }
            throw new RuntimeException("unexpected type of attribute " + name);
        }
        if (state != null) {
            state[0] = isAmbiguous ? PropertyState.AMBIGUOUS_VALUE : (isDefaulted ? PropertyState.DEFAULT_VALUE : PropertyState.DIRECT_VALUE);
        }
        return value;
    }

    private Object wrapValue(Object value, XIdlClass type, boolean wrapAmbiguous, boolean isAmbiguous, boolean wrapDefaulted, boolean isDefaulted, boolean wrapOptional) {
        if (wrapAmbiguous && type.getName().startsWith("com.sun.star.beans.Ambiguous<")) {
            Object[] strct = new Object[1];
            type.createObject(strct);
            try {
                XIdlField2 field2 = UnoRuntime.queryInterface(XIdlField2.class, (Object)type.getField("Value"));
                field2.set(strct, this.wrapValue(value, field2.getType(), false, false, wrapDefaulted, isDefaulted, wrapOptional));
                UnoRuntime.queryInterface(XIdlField2.class, (Object)type.getField("IsAmbiguous")).set(strct, isAmbiguous);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return strct[0];
        }
        if (wrapDefaulted && type.getName().startsWith("com.sun.star.beans.Defaulted<")) {
            Object[] strct = new Object[1];
            type.createObject(strct);
            try {
                XIdlField2 field3 = UnoRuntime.queryInterface(XIdlField2.class, (Object)type.getField("Value"));
                field3.set(strct, this.wrapValue(value, field3.getType(), wrapAmbiguous, isAmbiguous, false, false, wrapOptional));
                UnoRuntime.queryInterface(XIdlField2.class, (Object)type.getField("IsDefaulted")).set(strct, isDefaulted);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return strct[0];
        }
        if (wrapOptional && type.getName().startsWith("com.sun.star.beans.Optional<")) {
            Object[] strct = new Object[1];
            type.createObject(strct);
            boolean present = !AnyConverter.isVoid(value);
            try {
                UnoRuntime.queryInterface(XIdlField2.class, (Object)type.getField("IsPresent")).set(strct, present);
                if (present) {
                    XIdlField2 field4 = UnoRuntime.queryInterface(XIdlField2.class, (Object)type.getField("Value"));
                    field4.set(strct, this.wrapValue(value, field4.getType(), wrapAmbiguous, isAmbiguous, wrapDefaulted, isDefaulted, false));
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return strct[0];
        }
        if (wrapAmbiguous || wrapDefaulted || wrapOptional) {
            throw new RuntimeException("unexpected type of attribute");
        }
        return value;
    }

    private static XTypeDescription resolveTypedefs(XTypeDescription type) {
        while (type.getTypeClass() == TypeClass.TYPEDEF) {
            type = UnoRuntime.queryInterface(XIndirectTypeDescription.class, (Object)type).getReferencedType();
        }
        return type;
    }

    private PropertyData get(Object object, String propertyName) throws UnknownPropertyException {
        PropertyData p = this.properties.get(propertyName);
        if (p == null || !p.present) {
            throw new UnknownPropertyException(propertyName, object);
        }
        return p;
    }

    private void checkUnknown(String propertyName) throws UnknownPropertyException {
        if (propertyName.length() != 0) {
            this.get(this, propertyName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Info
    extends WeakBase
    implements XPropertySetInfo {
        private final Map<String, PropertyData> properties;

        public Info(Map<String, PropertyData> properties) {
            this.properties = properties;
        }

        @Override
        public Property[] getProperties() {
            ArrayList<Property> al = new ArrayList<Property>(this.properties.size());
            for (PropertyData p : this.properties.values()) {
                if (!p.present) continue;
                al.add(p.property);
            }
            return al.toArray(new Property[al.size()]);
        }

        @Override
        public Property getPropertyByName(String name) throws UnknownPropertyException {
            return ((PropertySetMixin)PropertySetMixin.this).get((Object)this, (String)name).property;
        }

        @Override
        public boolean hasPropertyByName(String name) {
            PropertyData p = this.properties.get(name);
            return p != null && p.present;
        }
    }

    private static final class PropertyData {
        public final Property property;
        public final boolean present;

        public PropertyData(Property property, boolean present) {
            this.property = property;
            this.present = present;
        }
    }

    public static final class BoundListeners {
        private ArrayList<XPropertyChangeListener> specificListeners = null;
        private ArrayList<XPropertyChangeListener> unspecificListeners = null;
        private PropertyChangeEvent event = null;

        public void notifyListeners() {
            Iterator<XPropertyChangeListener> i;
            if (this.specificListeners != null) {
                i = this.specificListeners.iterator();
                while (i.hasNext()) {
                    try {
                        i.next().propertyChange(this.event);
                    }
                    catch (DisposedException disposedException) {}
                }
            }
            if (this.unspecificListeners != null) {
                i = this.unspecificListeners.iterator();
                while (i.hasNext()) {
                    try {
                        i.next().propertyChange(this.event);
                    }
                    catch (DisposedException disposedException) {}
                }
            }
        }
    }
}

