/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.EventData;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseSampleSourceTelemetry;
import java.util.concurrent.ConcurrentMap;

public final class EventTelemetry
extends BaseSampleSourceTelemetry<EventData> {
    private Double samplingPercentage;
    private final EventData data = new EventData();
    private static final String ENVELOPE_NAME = "Event";
    private static final String BASE_TYPE = "EventData";

    public EventTelemetry() {
        this.initialize(this.data.getProperties());
    }

    public EventTelemetry(String name) {
        this();
        this.setName(name);
    }

    public ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String name) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("The event name cannot be null or empty");
        }
        this.data.setName(name);
    }

    @Override
    @Deprecated
    protected void additionalSanitize() {
        this.data.setName(Sanitizer.sanitizeName(this.data.getName()));
        Sanitizer.sanitizeMeasurements(this.getMetrics());
    }

    @Override
    protected EventData getData() {
        return this.data;
    }

    @Override
    public Double getSamplingPercentage() {
        return this.samplingPercentage;
    }

    @Override
    public void setSamplingPercentage(Double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
    }

    @Override
    public String getEnvelopName() {
        return ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return BASE_TYPE;
    }
}

