/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCountersFactory;
import com.microsoft.applicationinsights.internal.perfcounter.jvm.DeadLockDetectorPerformanceCounter;
import com.microsoft.applicationinsights.internal.perfcounter.jvm.JvmHeapMemoryUsedPerformanceCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class JvmPerformanceCountersFactory
implements PerformanceCountersFactory {
    private boolean isEnabled = true;
    private HashSet<String> disabledJvmPCs = new HashSet();

    @Override
    public Collection<PerformanceCounter> getPerformanceCounters() {
        ArrayList<PerformanceCounter> pcs = new ArrayList<PerformanceCounter>();
        if (this.isEnabled) {
            this.addDeadLockDetector(pcs);
            this.addJvmMemoryPerformanceCounter(pcs);
        } else {
            InternalLogger.INSTANCE.trace("JvmPerformanceCountersFactory is disabled", new Object[0]);
        }
        return pcs;
    }

    private void addDeadLockDetector(ArrayList<PerformanceCounter> pcs) {
        try {
            if (this.disabledJvmPCs.contains("ThreadDeadLockDetector")) {
                InternalLogger.INSTANCE.trace("DeadLockDetectorPerformanceCounter is disabled", new Object[0]);
                return;
            }
            DeadLockDetectorPerformanceCounter dlpc = new DeadLockDetectorPerformanceCounter();
            if (!dlpc.isSupported()) {
                InternalLogger.INSTANCE.trace("DeadLockDetectorPerformanceCounter is not supported", new Object[0]);
                return;
            }
            pcs.add(dlpc);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("Failed to create DeadLockDetector, exception: %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void addJvmMemoryPerformanceCounter(ArrayList<PerformanceCounter> pcs) {
        try {
            if (this.disabledJvmPCs.contains("MemoryUsage")) {
                InternalLogger.INSTANCE.trace("JvmHeapMemoryUsedPerformanceCounter is disabled", new Object[0]);
                return;
            }
            JvmHeapMemoryUsedPerformanceCounter mpc = new JvmHeapMemoryUsedPerformanceCounter();
            pcs.add(mpc);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("Failed to create JvmHeapMemoryUsedPerformanceCounter, exception: %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setDisabledJvmPCs(HashSet<String> disabledJvmPCs) {
        this.disabledJvmPCs = disabledJvmPCs;
    }
}

