/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.DomainType;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import java.sql.SQLException;
import java.util.Map;

class SQLTypeMetaData {
    private static PrimitiveType[][] sqlToPrimitiveMatrix;
    private static int[] primitiveToSQLTypeMatrix;

    SQLTypeMetaData() {
    }

    public static boolean requiresQuoting(Type type) {
        int sqlType = SQLTypeMetaData.getSQLType(type);
        switch (sqlType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return false;
            }
        }
        return true;
    }

    public static boolean isCurrency(Type type) {
        return type.unwrap().getPrimitiveType() == PrimitiveType.Money;
    }

    public static boolean isCaseSensitive(Type type) throws SQLException {
        switch (type.getCategory()) {
            case Enumeration: 
            case String: {
                return true;
            }
        }
        return false;
    }

    public static boolean isAutoIncrement(Type type, CompositeType relType, int relAttrNum) {
        if (relType != null && relAttrNum > 0) {
            CompositeType.Attribute attr = relType.getAttribute(relAttrNum);
            if (attr != null && attr.isAutoIncrement()) {
                return true;
            }
        } else if (type instanceof DomainType) {
            return ((DomainType)type).getDefaultValue().startsWith("nextval(");
        }
        return false;
    }

    public static int isNullable(Type type, CompositeType relType, int relAttrNum) {
        CompositeType.Attribute attr;
        int nullable = SQLTypeMetaData.isNullable(type);
        if (relType != null && relAttrNum != 0 && (attr = relType.getAttribute(relAttrNum)) != null) {
            if (attr.isNullable() && nullable == 2) {
                nullable = 1;
            } else if (!attr.isNullable()) {
                nullable = 0;
            }
        }
        return nullable;
    }

    public static int isNullable(Type type) {
        if (type instanceof DomainType) {
            return ((DomainType)type).isNullable() ? 1 : 0;
        }
        return 2;
    }

    public static boolean isSigned(Type type) {
        return type.unwrap().getCategory() == Type.Category.Numeric;
    }

    public static Type getType(int sqlType, Registry reg) {
        switch (sqlType) {
            case -7: 
            case 16: {
                return reg.loadType("bool");
            }
            case 5: {
                return reg.loadType("int2");
            }
            case 4: {
                return reg.loadType("int4");
            }
            case -5: {
                return reg.loadType("int8");
            }
            case 7: {
                return reg.loadType("float4");
            }
            case 6: 
            case 8: {
                return reg.loadType("float8");
            }
            case 2: 
            case 3: {
                return reg.loadType("numeric");
            }
            case -1: 
            case 1: 
            case 12: {
                return reg.loadType("text");
            }
            case 92: {
                return reg.loadType("time");
            }
            case 91: {
                return reg.loadType("date");
            }
            case 93: {
                return reg.loadType("timestamp");
            }
            case -4: 
            case -3: 
            case -2: {
                return reg.loadType("bytea");
            }
            case 2003: {
                return reg.loadType("anyarray");
            }
            case 2004: 
            case 2005: {
                return reg.loadType("oid");
            }
            case 2001: {
                return null;
            }
            case 2002: {
                return reg.loadType("oid");
            }
            case -8: {
                return reg.loadType("tid");
            }
        }
        return null;
    }

    public static int getSQLTypeIndex(int sqlType) {
        return (sqlType % 255 + 255) % 255;
    }

    public static int getSQLType(Type type) {
        PrimitiveType ptype = type.getPrimitiveType();
        if (ptype == null) {
            return 1111;
        }
        return primitiveToSQLTypeMatrix[ptype.ordinal()];
    }

    public static int getSQLTypeAlias(int sqlType) {
        switch (sqlType) {
            case -7: {
                return 16;
            }
            case -1: 
            case 1: 
            case 12: {
                return 12;
            }
            case -4: 
            case -3: 
            case -2: {
                return -3;
            }
            case -16: 
            case -15: 
            case -9: {
                return -9;
            }
        }
        return sqlType;
    }

    public static String getTypeName(Type type, CompositeType relType, int relAttrNum) {
        if (SQLTypeMetaData.isAutoIncrement(type, relType, relAttrNum)) {
            switch (type.getPrimitiveType()) {
                case Int4: {
                    return "serial";
                }
                case Int8: {
                    return "bigserial";
                }
            }
        }
        return type.getName();
    }

    public static int getPrecisionRadix(Type type) {
        switch (type.unwrap().getCategory()) {
            case Numeric: {
                return 10;
            }
            case BitString: {
                return 2;
            }
        }
        return 0;
    }

    public static int getMinPrecision(Type type) {
        return 0;
    }

    public static int getMaxPrecision(Type type) {
        PrimitiveType ptype = (type = type.unwrap()).getPrimitiveType();
        if (ptype == null) {
            return 0;
        }
        switch (ptype) {
            case Numeric: {
                return 1000;
            }
            case Time: 
            case TimeTZ: 
            case Timestamp: 
            case TimestampTZ: 
            case Interval: {
                return 6;
            }
            case String: {
                return 0xA00000;
            }
            case Bits: {
                return 0x5000000;
            }
        }
        return 0;
    }

    public static int getPrecision(Type type, int typeLength, int typeModifier) {
        int prec;
        type = type.unwrap();
        Map<String, Object> mods = type.getModifierParser().parse(typeModifier);
        int precMod = -1;
        if (mods.containsKey("precision")) {
            precMod = (Integer)mods.get("precision");
        }
        int lenMod = -1;
        if (mods.containsKey("length")) {
            lenMod = (Integer)mods.get("length");
        } else if (typeLength != -1) {
            lenMod = typeLength;
        }
        PrimitiveType ptype = type.getPrimitiveType();
        if (ptype == null) {
            prec = lenMod;
        } else {
            switch (ptype) {
                case Int2: {
                    prec = 5;
                    break;
                }
                case Int4: 
                case Oid: {
                    prec = 10;
                    break;
                }
                case Int8: 
                case Money: {
                    prec = 19;
                    break;
                }
                case Float: {
                    prec = 8;
                    break;
                }
                case Double: {
                    prec = 17;
                    break;
                }
                case Numeric: {
                    if (precMod != 0) {
                        prec = precMod;
                        break;
                    }
                    prec = 131072;
                    break;
                }
                case Time: 
                case TimeTZ: 
                case Timestamp: 
                case TimestampTZ: 
                case Date: {
                    prec = SQLTypeMetaData.calculateDateTimeDisplaySize(type.getPrimitiveType(), precMod);
                    break;
                }
                case Interval: {
                    prec = 49;
                    break;
                }
                case String: 
                case Bits: 
                case Binary: {
                    prec = lenMod;
                    break;
                }
                case Bool: {
                    prec = 1;
                    break;
                }
                case UUID: {
                    prec = 36;
                    break;
                }
                default: {
                    prec = lenMod;
                }
            }
        }
        return prec;
    }

    public static int getMinScale(Type type) {
        PrimitiveType ptype = (type = type.unwrap()).getPrimitiveType();
        if (ptype == null) {
            return 0;
        }
        switch (ptype) {
            case Money: {
                return 2;
            }
        }
        return 0;
    }

    public static int getMaxScale(Type type) {
        PrimitiveType ptype = (type = type.unwrap()).getPrimitiveType();
        if (ptype == null) {
            return 0;
        }
        switch (ptype) {
            case Numeric: {
                return 1000;
            }
        }
        return 0;
    }

    public static int getScale(Type type, int typeLength, int typeModifier) {
        type = type.unwrap();
        Map<String, Object> mods = type.getModifierParser().parse(typeModifier);
        int scaleMod = -1;
        if (mods.get("scale") != null) {
            scaleMod = (Integer)mods.get("scale");
        }
        int scale = 0;
        switch (type.getPrimitiveType()) {
            case Float: {
                scale = 8;
                break;
            }
            case Double: {
                scale = 17;
                break;
            }
            case Numeric: {
                if (scale == -1) {
                    scale = 0;
                    break;
                }
                scale = scaleMod;
                break;
            }
            case Time: 
            case TimeTZ: 
            case Timestamp: 
            case TimestampTZ: {
                int precMod = -1;
                if (mods.get("precision") != null) {
                    precMod = (Integer)mods.get("precision");
                }
                if (precMod == -1) {
                    scale = 6;
                    break;
                }
                scale = precMod;
                break;
            }
            case Interval: {
                if (scaleMod == -1) {
                    scale = 6;
                    break;
                }
                scale = scaleMod;
                break;
            }
            default: {
                scale = 0;
            }
        }
        return scale;
    }

    public static int getDisplaySize(Type type, int typeLength, int typeModifier) {
        int size;
        type = type.unwrap();
        Map<String, Object> mods = type.getModifierParser().parse(typeModifier);
        int precMod = -1;
        if (mods.containsKey("precision")) {
            precMod = (Integer)mods.get("precision");
        }
        int lenMod = -1;
        if (mods.containsKey("length")) {
            lenMod = (Integer)mods.get("length");
        } else if (typeLength != -1) {
            lenMod = typeLength;
        }
        switch (type.getCategory()) {
            case Numeric: {
                if (precMod == -1) {
                    size = 131089;
                    break;
                }
                int prec = SQLTypeMetaData.getPrecision(type, typeLength, typeModifier);
                int scale = SQLTypeMetaData.getScale(type, typeLength, typeModifier);
                size = prec + (scale != 0 ? 1 : 0) + 1;
                break;
            }
            case Boolean: {
                size = 5;
                break;
            }
            case Enumeration: 
            case String: 
            case BitString: {
                if (lenMod == -1) {
                    size = Integer.MAX_VALUE;
                    break;
                }
                size = lenMod;
                break;
            }
            case DateTime: {
                size = SQLTypeMetaData.calculateDateTimeDisplaySize(type.getPrimitiveType(), precMod);
                break;
            }
            case Timespan: {
                size = 49;
                break;
            }
            default: {
                size = Integer.MAX_VALUE;
            }
        }
        return size;
    }

    private static int calculateDateTimeDisplaySize(PrimitiveType primType, int precision) {
        int size;
        if (primType == null) {
            return 0;
        }
        block0 : switch (primType) {
            case Date: {
                size = 13;
                break;
            }
            case Time: 
            case TimeTZ: 
            case Timestamp: 
            case TimestampTZ: {
                int secondSize;
                switch (precision) {
                    case -1: {
                        secondSize = 7;
                        break;
                    }
                    case 0: {
                        secondSize = 0;
                        break;
                    }
                    case 1: {
                        secondSize = 3;
                        break;
                    }
                    default: {
                        secondSize = precision + 1;
                    }
                }
                switch (primType) {
                    case Time: {
                        size = 8 + secondSize;
                        break block0;
                    }
                    case TimeTZ: {
                        size = 8 + secondSize + 6;
                        break block0;
                    }
                    case Timestamp: {
                        size = 22 + secondSize;
                        break block0;
                    }
                    case TimestampTZ: {
                        size = 22 + secondSize + 6;
                        break block0;
                    }
                }
                size = 0;
                break;
            }
            default: {
                size = 0;
            }
        }
        return size;
    }

    static {
        primitiveToSQLTypeMatrix = new int[255];
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Bool.ordinal()] = 16;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Int2.ordinal()] = 5;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Int4.ordinal()] = 4;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Int8.ordinal()] = -5;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Float.ordinal()] = 7;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Double.ordinal()] = 8;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Numeric.ordinal()] = 2;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Money.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.String.ordinal()] = 12;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Date.ordinal()] = 91;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Time.ordinal()] = 92;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.TimeTZ.ordinal()] = 92;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Timestamp.ordinal()] = 93;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.TimestampTZ.ordinal()] = 93;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Oid.ordinal()] = 4;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Tid.ordinal()] = -8;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Array.ordinal()] = 2003;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Record.ordinal()] = 2002;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Domain.ordinal()] = 2001;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Binary.ordinal()] = -2;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Bits.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Range.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.UUID.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Interval.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Unknown.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Box.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Circle.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Line.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.LineSegment.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Path.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Point.ordinal()] = 1111;
        SQLTypeMetaData.primitiveToSQLTypeMatrix[PrimitiveType.Polygon.ordinal()] = 1111;
        sqlToPrimitiveMatrix = new PrimitiveType[255][];
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)0)] = new PrimitiveType[0];
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)16)] = new PrimitiveType[]{PrimitiveType.Bool};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-7)] = new PrimitiveType[]{PrimitiveType.Bool};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-6)] = new PrimitiveType[0];
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)5)] = new PrimitiveType[]{PrimitiveType.Int2};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)4)] = new PrimitiveType[]{PrimitiveType.Int4};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-5)] = new PrimitiveType[]{PrimitiveType.Int8};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)7)] = new PrimitiveType[]{PrimitiveType.Float};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)6)] = new PrimitiveType[]{PrimitiveType.Float};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)8)] = new PrimitiveType[]{PrimitiveType.Double};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)2)] = new PrimitiveType[]{PrimitiveType.Numeric};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)3)] = new PrimitiveType[]{PrimitiveType.Numeric};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)1)] = new PrimitiveType[]{PrimitiveType.String};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)12)] = new PrimitiveType[]{PrimitiveType.String};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-16)] = new PrimitiveType[]{PrimitiveType.String};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)91)] = new PrimitiveType[]{PrimitiveType.Date};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)92)] = new PrimitiveType[]{PrimitiveType.Time, PrimitiveType.TimeTZ};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)93)] = new PrimitiveType[]{PrimitiveType.Timestamp, PrimitiveType.TimestampTZ};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-2)] = new PrimitiveType[]{PrimitiveType.Binary};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-3)] = new PrimitiveType[]{PrimitiveType.Binary};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-4)] = new PrimitiveType[]{PrimitiveType.Binary};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)2004)] = new PrimitiveType[]{PrimitiveType.Int4};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)2005)] = new PrimitiveType[]{PrimitiveType.Int4};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)2009)] = new PrimitiveType[]{PrimitiveType.String};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)2003)] = new PrimitiveType[]{PrimitiveType.Array};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)2002)] = new PrimitiveType[]{PrimitiveType.Record};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)2001)] = new PrimitiveType[]{PrimitiveType.Domain};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)70)] = new PrimitiveType[0];
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)2000)] = new PrimitiveType[0];
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-15)] = new PrimitiveType[0];
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-9)] = new PrimitiveType[0];
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-16)] = new PrimitiveType[0];
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)2006)] = new PrimitiveType[0];
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)-8)] = new PrimitiveType[]{PrimitiveType.Tid};
        SQLTypeMetaData.sqlToPrimitiveMatrix[SQLTypeMetaData.getSQLTypeIndex((int)1111)] = new PrimitiveType[0];
    }
}

