/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.SQLTextTree;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLText {
    private static final Set<Character> ESCAPE_STRING_SPECIFIERS = new HashSet<Character>(Arrays.asList(Character.valueOf('E'), Character.valueOf('e')));
    private SQLTextTree.MultiStatementNode root;

    public SQLText(String sqlText) throws ParseException {
        this(sqlText, true);
    }

    public SQLText(String sqlText, boolean standardConformingStrings) throws ParseException {
        this.root = SQLText.parse(sqlText, standardConformingStrings);
    }

    public SQLText(SQLTextTree.MultiStatementNode copyRoot) {
        this.root = copyRoot;
    }

    public SQLText copy() {
        return new SQLText((SQLTextTree.MultiStatementNode)this.root.copy());
    }

    public int getStatementCount() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getNodeCount();
    }

    public SQLTextTree.StatementNode getFirstStatement() {
        if (this.root == null || this.root.getNodeCount() == 0) {
            return null;
        }
        return (SQLTextTree.StatementNode)this.root.get(0);
    }

    public SQLTextTree.StatementNode getLastStatement() {
        if (this.root == null || this.root.getNodeCount() == 0) {
            return null;
        }
        return (SQLTextTree.StatementNode)this.root.get(this.root.getNodeCount() - 1);
    }

    public void addStatements(SQLText sqlText) {
        this.root.nodes.addAll(sqlText.root.nodes);
    }

    public void process(SQLTextTree.Processor processor, boolean recurse) throws SQLException {
        this.root.process(processor, recurse);
    }

    public String toString() {
        return this.root.toString();
    }

    public static SQLTextTree.MultiStatementNode parse(String sql, boolean standardConformingStrings) throws ParseException {
        LinkedList<SQLTextTree.CompositeNode> parents = new LinkedList<SQLTextTree.CompositeNode>();
        parents.push(new SQLTextTree.MultiStatementNode(0));
        parents.push(new SQLTextTree.StatementNode(0));
        int paramId = 1;
        int ndx = 0;
        try {
            block14: while (ndx < sql.length()) {
                char c = sql.charAt(ndx);
                switch (c) {
                    case '\'': {
                        ndx = SQLText.consumeStringLiteral(sql, ndx + 1, (SQLTextTree.CompositeNode)parents.peek(), standardConformingStrings);
                        continue block14;
                    }
                    case '\"': {
                        ndx = SQLText.consumeQuotedIdentifier(sql, ndx, (SQLTextTree.CompositeNode)parents.peek());
                        continue block14;
                    }
                    case '?': {
                        SQLTextTree.GrammarPiece grammarPiece;
                        char nextChar = SQLText.lookAhead(sql, ndx);
                        if (nextChar == '|' || nextChar == '&' || nextChar == '?') {
                            grammarPiece = nextChar == '?' ? new SQLTextTree.GrammarPiece("?", ndx) : new SQLTextTree.GrammarPiece("?" + nextChar, ndx);
                            ((SQLTextTree.CompositeNode)parents.peek()).add(grammarPiece);
                            ++ndx;
                            break;
                        }
                        SQLTextTree.ParameterPiece parameterPiece = new SQLTextTree.ParameterPiece(paramId++, ndx);
                        ((SQLTextTree.CompositeNode)parents.peek()).add(parameterPiece);
                        break;
                    }
                    case '$': {
                        ndx = SQLText.consumeDollar(sql, ndx, (SQLTextTree.CompositeNode)parents.peek());
                        continue block14;
                    }
                    case '(': 
                    case ')': {
                        ndx = SQLText.consumeParens(sql, ndx, parents);
                        continue block14;
                    }
                    case '{': 
                    case '}': {
                        ndx = SQLText.consumeBraces(sql, ndx, parents);
                        continue block14;
                    }
                    case '/': {
                        if (SQLText.lookAhead(sql, ndx) == '*') {
                            ndx = SQLText.consumeMultilineComment(sql, ndx, (SQLTextTree.CompositeNode)parents.peek());
                            continue block14;
                        }
                        ((SQLTextTree.CompositeNode)parents.peek()).add(new SQLTextTree.GrammarPiece("/", ndx));
                        break;
                    }
                    case '-': {
                        if (SQLText.lookAhead(sql, ndx) == '-') {
                            ndx = SQLText.consumeSinglelineComment(sql, ndx, (SQLTextTree.CompositeNode)parents.peek());
                            continue block14;
                        }
                        if (Character.isDigit(SQLText.lookAhead(sql, ndx))) {
                            ndx = SQLText.consumeNumeric(sql, ndx, (SQLTextTree.CompositeNode)parents.peek());
                            continue block14;
                        }
                        SQLTextTree.GrammarPiece grammarPiece = new SQLTextTree.GrammarPiece("-", ndx);
                        ((SQLTextTree.CompositeNode)parents.peek()).add(grammarPiece);
                        break;
                    }
                    case ';': {
                        if (parents.size() == 2) {
                            paramId = 1;
                            SQLTextTree.CompositeNode comp = (SQLTextTree.CompositeNode)parents.pop();
                            comp.setEndPos(ndx);
                            ((SQLTextTree.CompositeNode)parents.peek()).add(comp);
                            parents.push(new SQLTextTree.StatementNode(ndx));
                            break;
                        }
                        ((SQLTextTree.CompositeNode)parents.peek()).add(new SQLTextTree.GrammarPiece(";", ndx));
                        break;
                    }
                    default: {
                        if (Character.isWhitespace(c)) {
                            SQLTextTree.WhitespacePiece whitespacePiece = new SQLTextTree.WhitespacePiece(sql.substring(ndx, ndx + 1), ndx);
                            if (((SQLTextTree.CompositeNode)parents.peek()).getLastNode() instanceof SQLTextTree.WhitespacePiece) {
                                ((SQLTextTree.WhitespacePiece)((SQLTextTree.CompositeNode)parents.peek()).getLastNode()).coalesce(whitespacePiece);
                                break;
                            }
                            ((SQLTextTree.CompositeNode)parents.peek()).add(whitespacePiece);
                            break;
                        }
                        if (Character.isDigit(c) || c == '+' && Character.isDigit(SQLText.lookAhead(sql, ndx))) {
                            ndx = SQLText.consumeNumeric(sql, ndx, (SQLTextTree.CompositeNode)parents.peek());
                            continue block14;
                        }
                        if (Character.isJavaIdentifierStart(c)) {
                            ndx = SQLText.consumeUnquotedIdentifier(sql, ndx, (SQLTextTree.CompositeNode)parents.peek());
                            continue block14;
                        }
                        SQLTextTree.GrammarPiece grammarPiece = new SQLTextTree.GrammarPiece(sql.substring(ndx, ndx + 1), ndx);
                        if (((SQLTextTree.CompositeNode)parents.peek()).getLastNode() instanceof SQLTextTree.GrammarPiece) {
                            ((SQLTextTree.GrammarPiece)((SQLTextTree.CompositeNode)parents.peek()).getLastNode()).coalesce(grammarPiece);
                            break;
                        }
                        ((SQLTextTree.CompositeNode)parents.peek()).add(grammarPiece);
                    }
                }
                ++ndx;
            }
            if (parents.peek() instanceof SQLTextTree.StatementNode) {
                SQLTextTree.StatementNode stmt = (SQLTextTree.StatementNode)parents.peek();
                stmt.trim();
                if (stmt.getNodeCount() > 0) {
                    SQLTextTree.CompositeNode tmp = (SQLTextTree.CompositeNode)parents.pop();
                    tmp.setEndPos(ndx);
                    ((SQLTextTree.CompositeNode)parents.peek()).add(tmp);
                }
            }
            if (!(parents.peek() instanceof SQLTextTree.StatementNode) && !(parents.peek() instanceof SQLTextTree.MultiStatementNode)) {
                throw new IllegalArgumentException("error parsing SQL");
            }
            return (SQLTextTree.MultiStatementNode)parents.getLast();
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            String errorTxt = sql.substring(ndx, Math.min(sql.length(), ndx + 10));
            throw new ParseException("Error near: " + errorTxt, ndx);
        }
    }

    private static int consumeNumeric(String sql, int start, SQLTextTree.CompositeNode parent) throws ParseException {
        Matcher matcher = Pattern.compile("((?:[+-]?(?:\\d+)?(?:\\.\\d+(?:[eE][+-]?\\d+)?))|(?:[+-]?\\d+))").matcher(sql.substring(start));
        if (matcher.find()) {
            parent.add(new SQLTextTree.NumericLiteralPiece(matcher.group(1), matcher.start()));
            return start + matcher.group(1).length();
        }
        throw new ParseException("Invalid numeric literal", start);
    }

    private static int consumeUnquotedIdentifier(String sql, int start, SQLTextTree.CompositeNode parent) {
        char c;
        int ndx = start;
        do {
            c = SQLText.lookAhead(sql, ndx++);
        } while (ndx < sql.length() && Character.isJavaIdentifierPart(c));
        parent.add(new SQLTextTree.UnquotedIdentifierPiece(sql.substring(start, ndx), start));
        return ndx;
    }

    private static int consumeBraces(String sql, int start, Deque<SQLTextTree.CompositeNode> parents) throws ParseException {
        if (sql.charAt(start) == '{') {
            parents.push(new SQLTextTree.EscapeNode(start));
        } else if (parents.peek() instanceof SQLTextTree.EscapeNode) {
            SQLTextTree.EscapeNode tmp = (SQLTextTree.EscapeNode)parents.pop();
            tmp.setEndPos(start);
            parents.peek().add(tmp);
        } else {
            throw new ParseException("Mismatched curly brace", start);
        }
        return start + 1;
    }

    private static int consumeParens(String sql, int start, Deque<SQLTextTree.CompositeNode> parents) throws ParseException {
        if (sql.charAt(start) == '(') {
            parents.push(new SQLTextTree.ParenGroupNode(start));
        } else if (parents.peek() instanceof SQLTextTree.ParenGroupNode) {
            SQLTextTree.ParenGroupNode tmp = (SQLTextTree.ParenGroupNode)parents.pop();
            tmp.setEndPos(start);
            parents.peek().add(tmp);
        } else {
            throw new ParseException("Mismmatched parenthesis", start);
        }
        return start + 1;
    }

    private static int consumeDollar(String sql, int start, SQLTextTree.CompositeNode parent) throws ParseException {
        int ndx = start;
        do {
            if (SQLText.lookAhead(sql, ndx) != '$') continue;
            String ident = sql.substring(start, ndx + 2);
            int pos = sql.indexOf(ident, ndx + 2);
            if (pos != -1) {
                String quotedText = sql.substring(ndx + 2, pos);
                parent.add(new SQLTextTree.StringLiteralPiece(quotedText, ident, start));
                return pos + ident.length();
            }
            ++ndx;
            break;
        } while (++ndx < sql.length());
        parent.add(new SQLTextTree.GrammarPiece(sql.substring(start, ndx), start));
        return ndx;
    }

    private static int consumeStringLiteral(String sql, int start, SQLTextTree.CompositeNode parent, boolean standardConformingStrings) throws ParseException {
        char c;
        char charBeforeLiteral = sql.charAt(start - 2);
        boolean standard = standardConformingStrings && !ESCAPE_STRING_SPECIFIERS.contains(Character.valueOf(charBeforeLiteral));
        int ndx = start;
        while ((c = sql.charAt(ndx)) != '\'' || !standard && sql.charAt(ndx - 1) == '\\') {
            if (SQLText.lookAhead(sql, ndx) == '\u0000') {
                throw new ParseException("Unterminated string literal", start);
            }
            ++ndx;
        }
        SQLTextTree.StringLiteralPiece literalPiece = new SQLTextTree.StringLiteralPiece(sql.substring(start, ndx), start);
        parent.add(literalPiece);
        return ndx + 1;
    }

    private static int consumeQuotedIdentifier(String sql, int start, SQLTextTree.CompositeNode parent) throws ParseException {
        char c;
        int ndx = start + 1;
        while ((c = sql.charAt(ndx)) != '\"' || sql.charAt(ndx - 1) == '\"') {
            if (SQLText.lookAhead(sql, ndx) == '\u0000') {
                throw new ParseException("Unterminated string literal", start);
            }
            ++ndx;
        }
        SQLTextTree.QuotedIdentifierPiece literalPiece = new SQLTextTree.QuotedIdentifierPiece(sql.substring(start + 1, ndx), start);
        parent.add(literalPiece);
        return ndx + 1;
    }

    private static int consumeSinglelineComment(String sql, int start, SQLTextTree.CompositeNode parent) {
        int ndx = start + 2;
        if (ndx < sql.length()) {
            do {
                char c;
                if ((c = sql.charAt(ndx)) != '\r' && c != '\n') continue;
                ndx = SQLText.lookAhead(sql, ndx) == '\n' ? ndx + 2 : ndx + 1;
                break;
            } while (++ndx < sql.length());
        } else {
            ndx = sql.length();
        }
        SQLTextTree.CommentPiece commentPiece = new SQLTextTree.CommentPiece(sql.substring(start, ndx), start);
        parent.add(commentPiece);
        return ndx;
    }

    private static int consumeMultilineComment(String sql, int start, SQLTextTree.CompositeNode parent) throws ParseException {
        int nestLevel = 1;
        int ndx = start + 1;
        do {
            char c;
            if ((c = SQLText.lookAhead(sql, ndx)) == '\u0000') {
                throw new ParseException("Unterminated comment", start);
            }
            if (c == '/' && SQLText.lookAhead(sql, ndx + 1) == '*') {
                ++nestLevel;
                ++ndx;
            } else if (c == '*' && SQLText.lookAhead(sql, ndx + 1) == '/') {
                --nestLevel;
                ++ndx;
            }
            ++ndx;
        } while (nestLevel > 0);
        SQLTextTree.CommentPiece commentPiece = new SQLTextTree.CommentPiece(sql.substring(start, ndx + 1), start);
        parent.add(commentPiece);
        return ndx + 1;
    }

    private static char lookAhead(String sql, int ndx) {
        if (ndx + 1 < sql.length()) {
            return sql.charAt(ndx + 1);
        }
        return '\u0000';
    }
}

