/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.BlobInputStream;
import com.impossibl.postgres.jdbc.BlobOutputStream;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.LargeObject;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.utils.guava.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PGBlob
implements Blob {
    LargeObject lo;
    List<LargeObject> streamLos;

    PGBlob(PGConnectionImpl connection, int oid) throws SQLException {
        if (connection.getAutoCommit()) {
            throw new SQLException("Blobs require connection to be in manual-commit mode... setAutoCommit(false)");
        }
        this.lo = LargeObject.open(connection, oid);
        this.streamLos = new ArrayList<LargeObject>();
    }

    private void checkClosed() throws SQLException {
        if (this.lo == null) {
            throw Exceptions.CLOSED_BLOB;
        }
    }

    private static void checkPosition(long pos) throws SQLException {
        if (pos < 1L) {
            throw Exceptions.ILLEGAL_ARGUMENT;
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        long cur = this.lo.tell();
        this.lo.lseek(0L, 2);
        long len = this.lo.tell();
        this.lo.lseek(cur, 0);
        return len;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkClosed();
        PGBlob.checkPosition(pos);
        this.lo.lseek(pos - 1L, 0);
        return this.lo.read(length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        LargeObject streamLo = this.lo.dup();
        this.streamLos.add(streamLo);
        return new BlobInputStream(this, streamLo);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkClosed();
        PGBlob.checkPosition(pos);
        LargeObject streamLo = this.lo.dup();
        this.streamLos.add(streamLo);
        streamLo.lseek(pos - 1L, 0);
        return ByteStreams.limit(new BlobInputStream(this, streamLo), length);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkClosed();
        PGBlob.checkPosition(start);
        LOByteIterator iter = new LOByteIterator(start - 1L);
        long curPos = start;
        long matchStartPos = 0L;
        int patternIdx = 0;
        while (iter.hasNext()) {
            byte b = iter.next();
            if (b == pattern[patternIdx]) {
                if (patternIdx == 0) {
                    matchStartPos = curPos;
                }
                if (++patternIdx == pattern.length) {
                    return matchStartPos;
                }
            } else {
                patternIdx = 0;
            }
            ++curPos;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.checkClosed();
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkClosed();
        PGBlob.checkPosition(pos);
        this.lo.lseek(pos - 1L, 0);
        return this.lo.write(bytes, offset, len);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkClosed();
        PGBlob.checkPosition(pos);
        LargeObject streamLo = this.lo.dup();
        this.streamLos.add(streamLo);
        streamLo.lseek(pos - 1L, 0);
        return new BlobOutputStream(this, streamLo);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkClosed();
        this.lo.truncate(len);
    }

    @Override
    public void free() throws SQLException {
        if (this.lo == null) {
            return;
        }
        this.lo.close();
        this.lo = null;
        for (LargeObject streamLo : this.streamLos) {
            streamLo.close();
        }
        this.streamLos.clear();
    }

    void removeStream(LargeObject lo) {
        this.streamLos.remove(lo);
    }

    private class LOByteIterator {
        private static final int MAX_BUFFER_SIZE = 8096;
        private byte[] buffer = new byte[0];
        private int idx = 0;

        LOByteIterator(long start) throws SQLException {
            PGBlob.this.lo.lseek(start, 0);
        }

        boolean hasNext() throws SQLException {
            boolean result;
            if (this.idx < this.buffer.length) {
                result = true;
            } else {
                this.buffer = PGBlob.this.lo.read(8096L);
                this.idx = 0;
                result = this.buffer.length > 0;
            }
            return result;
        }

        private byte next() {
            return this.buffer[this.idx++];
        }
    }
}

