/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.support;

public abstract class BasePoolConfig {
    public static final boolean DEFAULT_TEST_ON_CREATE = false;
    public static final boolean DEFAULT_TEST_ON_ACQUIRE = false;
    public static final boolean DEFAULT_TEST_ON_RELEASE = false;
    private final boolean testOnCreate;
    private final boolean testOnAcquire;
    private final boolean testOnRelease;

    protected BasePoolConfig(boolean testOnCreate, boolean testOnAcquire, boolean testOnRelease) {
        this.testOnCreate = testOnCreate;
        this.testOnAcquire = testOnAcquire;
        this.testOnRelease = testOnRelease;
    }

    public boolean isTestOnCreate() {
        return this.testOnCreate;
    }

    public boolean isTestOnAcquire() {
        return this.testOnAcquire;
    }

    public boolean isTestOnRelease() {
        return this.testOnRelease;
    }

    public static abstract class Builder {
        protected boolean testOnCreate = false;
        protected boolean testOnAcquire = false;
        protected boolean testOnRelease = false;

        protected Builder() {
        }

        public Builder testOnCreate() {
            return this.testOnCreate(true);
        }

        public Builder testOnCreate(boolean testOnCreate) {
            this.testOnCreate = testOnCreate;
            return this;
        }

        public Builder testOnAcquire() {
            return this.testOnAcquire(true);
        }

        public Builder testOnAcquire(boolean testOnAcquire) {
            this.testOnAcquire = testOnAcquire;
            return this;
        }

        public Builder testOnRelease() {
            return this.testOnRelease(true);
        }

        public Builder testOnRelease(boolean testOnRelease) {
            this.testOnRelease = testOnRelease;
            return this;
        }
    }
}

