/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.bitext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.bitext.StringPair;
import org.languagetool.bitext.WordFastTMReader;

public class WordFastTMReaderTest {
    @Test
    public void testReader() throws Exception {
        File input = File.createTempFile("input", ".txt");
        input.deleteOnExit();
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(input), StandardCharsets.UTF_8));){
            writer.println("%20100801~111517\t%UserID,AHLJat,AHLJat\t%TU=00008580\t%EN-US\t%Wordfast TM v.546/00\t%PL-PL\t%\t.");
            writer.println("20100727~145333\tAHLJat\t2\tEN-US\tObjection:\tPL-PL\tZarzut: ");
            writer.println("20100727~051350\tAHLJat\t2\tEN-US\tWhy not?&tA;\tPL-PL\tDlaczego nie?&tA; ");
        }
        WordFastTMReader reader = new WordFastTMReader(input.getAbsolutePath(), "UTF-8");
        int i = 1;
        for (StringPair srcAndTrg : reader) {
            Assert.assertTrue((srcAndTrg.getSource() != null ? 1 : 0) != 0);
            Assert.assertTrue((srcAndTrg.getTarget() != null ? 1 : 0) != 0);
            if (i == 1) {
                Assert.assertEquals((Object)"Objection:", (Object)srcAndTrg.getSource());
            } else if (i == 2) {
                Assert.assertEquals((Object)"Why not?&tA;", (Object)srcAndTrg.getSource());
            }
            ++i;
        }
    }
}

