/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSuspendLimitationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "isKotlinTestAnnotation", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSuspendLimitationsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSuspendLimitationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSuspendLimitationsChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n53#2:46\n1761#3,3:47\n*S KotlinDebug\n*F\n+ 1 FirSuspendLimitationsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSuspendLimitationsChecker\n*L\n28#1:46\n32#1:47,3\n*E\n"})
public final class FirSuspendLimitationsChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirSuspendLimitationsChecker INSTANCE = new FirSuspendLimitationsChecker();

    private FirSuspendLimitationsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
        block6: {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                FirMemberDeclaration $this$isSuspend$iv = declaration;
                boolean $i$f$isSuspend = false;
                if (!$this$isSuspend$iv.getStatus().isSuspend()) {
                    return;
                }
                Iterable $this$any$iv = declaration.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirAnnotation it = (FirAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.isKotlinTestAnnotation(it, context2.getSession())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) break block6;
            FirElement firElement = declaration;
            KtModifierKeywordToken ktModifierKeywordToken = KtTokens.SUSPEND_KEYWORD;
            Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "SUSPEND_KEYWORD");
            FirModifier<?> firModifier = FirKeywordUtilsKt.getModifier(firElement, ktModifierKeywordToken);
            if (firModifier != null) {
                FirModifier<?> it = firModifier;
                boolean bl3 = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it.getSource(), FirErrors.INSTANCE.getUNSUPPORTED_SUSPEND_TEST(), null, 8, null);
            }
        }
    }

    private final boolean isKotlinTestAnnotation(FirAnnotation $this$isKotlinTestAnnotation, FirSession session2) {
        ConeKotlinType nonExpandedType = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType($this$isKotlinTestAnnotation.getAnnotationTypeRef()));
        ConeClassLikeLookupTag coneClassLikeLookupTag = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(nonExpandedType);
        return Intrinsics.areEqual(coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null, StandardClassIds.Annotations.INSTANCE.getTest()) || Intrinsics.areEqual(FirAnnotationUtilsKt.toAnnotationClassId($this$isKotlinTestAnnotation, session2), StandardClassIds.Annotations.INSTANCE.getTest());
    }
}

