/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltinsVirtualFileProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0006H$J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProviderBaseImpl;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProvider;", "<init>", "()V", "builtInUrls", "", "Ljava/net/URL;", "getBuiltInUrls", "()Ljava/util/Set;", "builtInUrls$delegate", "Lkotlin/Lazy;", "createBuiltinsScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "findVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "getBuiltinVirtualFiles", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nBuiltinsVirtualFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltinsVirtualFileProvider.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProviderBaseImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1625#2:70\n1869#2:71\n1870#2:74\n1626#2:75\n1625#2:76\n1869#2:77\n1870#2:79\n1626#2:80\n11#3:72\n1#4:73\n1#4:78\n*S KotlinDebug\n*F\n+ 1 BuiltinsVirtualFileProvider.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProviderBaseImpl\n*L\n48#1:70\n48#1:71\n48#1:74\n48#1:75\n35#1:76\n35#1:77\n35#1:79\n35#1:80\n51#1:72\n48#1:73\n35#1:78\n*E\n"})
public abstract class BuiltinsVirtualFileProviderBaseImpl
extends BuiltinsVirtualFileProvider {
    @NotNull
    private final Lazy builtInUrls$delegate = LazyKt.lazy(() -> BuiltinsVirtualFileProviderBaseImpl.builtInUrls_delegate$lambda$1(this));

    private final Set<URL> getBuiltInUrls() {
        Lazy lazy = this.builtInUrls$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public GlobalSearchScope createBuiltinsScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        Set<VirtualFile> builtInFiles = this.getBuiltinVirtualFiles();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project, (Collection<? extends VirtualFile>)builtInFiles);
        Intrinsics.checkNotNullExpressionValue(globalSearchScope, "filesScope(...)");
        return globalSearchScope;
    }

    @Nullable
    protected abstract VirtualFile findVirtualFile(@NotNull URL var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<VirtualFile> getBuiltinVirtualFiles() {
        void var2_2;
        void $this$mapNotNullTo$iv;
        Iterable iterable = this.getBuiltInUrls();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            URL url = (URL)element$iv;
            boolean bl2 = false;
            VirtualFile file = this.findVirtualFile(url);
            if (file == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(BuiltinsVirtualFileProvider.class);
                Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
                logger.warn("VirtualFile not found for builtin " + url);
            }
            if (file == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set builtInUrls_delegate$lambda$1(BuiltinsVirtualFileProviderBaseImpl this$0) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        ClassLoader classLoader = this$0.getClass().getClassLoader();
        Iterable iterable = StandardClassIds.INSTANCE.getBuiltInsPackages();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            URL it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            FqName builtInPackageFqName = (FqName)element$iv;
            boolean bl2 = false;
            String resourcePath = BuiltInSerializerProtocol.INSTANCE.getBuiltInsFilePath(builtInPackageFqName);
            if (classLoader.getResource(resourcePath) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_3;
    }
}

