/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectCollectionSchema;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.ModelPath;

public class DefaultTaskCollection<T extends Task>
extends DefaultNamedDomainObjectSet<T>
implements TaskCollection<T> {
    protected final ProjectInternal project;
    private final MutationGuard parentMutationGuard;

    public DefaultTaskCollection(Class<T> type, Instantiator instantiator, ProjectInternal project, MutationGuard parentMutationGuard, CollectionCallbackActionDecorator decorator) {
        super(type, instantiator, Named.Namer.INSTANCE, decorator);
        this.project = project;
        this.parentMutationGuard = parentMutationGuard;
    }

    public DefaultTaskCollection(DefaultTaskCollection<? super T> collection, CollectionFilter<T> filter, Instantiator instantiator, ProjectInternal project, MutationGuard parentMutationGuard) {
        super(collection, filter, instantiator, Named.Namer.INSTANCE);
        this.project = project;
        this.parentMutationGuard = parentMutationGuard;
    }

    public DefaultTaskCollection(DefaultTaskCollection<? super T> collection, Spec<String> nameFilter, CollectionFilter<T> elementFilter, Instantiator instantiator, ProjectInternal project, MutationGuard parentMutationGuard) {
        super(collection, nameFilter, elementFilter, instantiator, Named.Namer.INSTANCE);
        this.project = project;
        this.parentMutationGuard = parentMutationGuard;
    }

    @Override
    protected <S extends T> DefaultTaskCollection<S> filtered(CollectionFilter<S> filter) {
        return (DefaultTaskCollection)Cast.uncheckedNonnullCast((Object)this.getInstantiator().newInstance(DefaultTaskCollection.class, new Object[]{this, filter, this.getInstantiator(), this.project, this.parentMutationGuard}));
    }

    @Override
    protected <S extends T> DefaultTaskCollection<S> filtered(Spec<String> nameFilter, CollectionFilter<S> elementFilter) {
        return (DefaultTaskCollection)Cast.uncheckedNonnullCast((Object)this.getInstantiator().newInstance(DefaultTaskCollection.class, new Object[]{this, nameFilter, elementFilter, this.getInstantiator(), this.project, this.parentMutationGuard}));
    }

    @Override
    public <S extends T> TaskCollection<S> withType(Class<S> type) {
        return this.filtered((CollectionFilter)this.createFilter(type));
    }

    @Override
    public TaskCollection<T> named(Spec<String> nameFilter) {
        Spec spec = this.convertNameToElementFilter(nameFilter);
        return this.filtered((Spec)nameFilter, this.createFilter(spec));
    }

    @Override
    public TaskCollection<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    @Override
    public TaskCollection<T> matching(Closure spec) {
        return this.matching((Spec<? super T>)Specs.convertClosureToSpec((Closure)spec));
    }

    public Action<? super T> whenTaskAdded(Action<? super T> action) {
        return this.whenObjectAdded(action);
    }

    public void whenTaskAdded(Closure closure) {
        this.whenObjectAdded(closure);
    }

    @Override
    public String getTypeDisplayName() {
        return "task";
    }

    protected UnknownTaskException createNotFoundException(String name) {
        return new UnknownTaskException(String.format("Task with name '%s' not found in %s.", name, this.project));
    }

    @Override
    protected InvalidUserDataException createWrongTypeException(String name, Class expected, Class actual) {
        return new InvalidUserDataException(String.format("The task '%s' (%s) is not a subclass of the given type (%s).", name, actual.getCanonicalName(), expected.getCanonicalName()));
    }

    @Override
    public TaskProvider<T> named(String name) throws UnknownTaskException {
        return (TaskProvider)super.named(name);
    }

    @Override
    public TaskProvider<T> named(String name, Action<? super T> configurationAction) throws UnknownTaskException {
        return (TaskProvider)super.named(name, configurationAction);
    }

    @Override
    public <S extends T> TaskProvider<S> named(String name, Class<S> type) throws UnknownTaskException {
        return (TaskProvider)super.named(name, type);
    }

    @Override
    public <S extends T> TaskProvider<S> named(String name, Class<S> type, Action<? super S> configurationAction) throws UnknownTaskException {
        return (TaskProvider)super.named(name, type, configurationAction);
    }

    @Override
    protected TaskProvider<? extends T> createExistingProvider(String name, T object) {
        return (TaskProvider)Cast.uncheckedCast((Object)this.getInstantiator().newInstance(ExistingTaskProvider.class, new Object[]{this, object.getName(), new DslObject(object).getDeclaredType()}));
    }

    @Override
    protected <I extends T> Action<? super I> withMutationDisabled(Action<? super I> action) {
        return this.parentMutationGuard.withMutationDisabled(super.withMutationDisabled(action));
    }

    @Override
    protected boolean hasWithName(String name) {
        return this.project.getModelRegistry() != null && this.project.getModelRegistry().state(ModelPath.path((String)("tasks." + name))) != null || super.hasWithName(name);
    }

    @Override
    public NamedDomainObjectCollectionSchema getCollectionSchema() {
        return new NamedDomainObjectCollectionSchema(){

            public Iterable<? extends NamedDomainObjectCollectionSchema.NamedDomainObjectSchema> getElements() {
                return Iterables.concat((Iterable)Iterables.transform(DefaultTaskCollection.this.index.asMap().entrySet(), (Function)new Function<Map.Entry<String, T>, NamedDomainObjectCollectionSchema.NamedDomainObjectSchema>(){

                    public NamedDomainObjectCollectionSchema.NamedDomainObjectSchema apply(final Map.Entry<String, T> e) {
                        return new NamedDomainObjectCollectionSchema.NamedDomainObjectSchema(){

                            public String getName() {
                                return (String)e.getKey();
                            }

                            public TypeOf<?> getPublicType() {
                                return new DslObject(e.getValue()).getPublicType();
                            }
                        };
                    }
                }), (Iterable)Iterables.transform(DefaultTaskCollection.this.index.getPendingAsMap().entrySet(), (Function)new Function<Map.Entry<String, ProviderInternal<? extends T>>, NamedDomainObjectCollectionSchema.NamedDomainObjectSchema>(){

                    public NamedDomainObjectCollectionSchema.NamedDomainObjectSchema apply(final Map.Entry<String, ProviderInternal<? extends T>> e) {
                        return new NamedDomainObjectCollectionSchema.NamedDomainObjectSchema(){

                            public String getName() {
                                return (String)e.getKey();
                            }

                            public TypeOf<?> getPublicType() {
                                return TypeOf.typeOf((Class)((ProviderInternal)e.getValue()).getType());
                            }
                        };
                    }
                }));
            }
        };
    }

    public Action<? super T> whenObjectRemovedInternal(Action<? super T> action) {
        return super.whenObjectRemoved(action);
    }

    public class ExistingTaskProvider<I extends T>
    extends DefaultNamedDomainObjectCollection.ExistingNamedDomainObjectProvider<I>
    implements TaskProvider<I> {
        public ExistingTaskProvider(String name, Class<I> type) {
            super(name, type);
        }

        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.taskState((Task)((Task)this.get()));
        }
    }
}

