/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.install;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.authentication.Authentication;
import org.gradle.cache.FileLock;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.jvm.toolchain.JavaToolchainDownload;
import org.gradle.jvm.toolchain.JavaToolchainResolver;
import org.gradle.jvm.toolchain.JavaToolchainResolverRegistry;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainRequest;
import org.gradle.jvm.toolchain.internal.JavaToolchainResolverRegistryInternal;
import org.gradle.jvm.toolchain.internal.JdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.RealizedJavaToolchainRepository;
import org.gradle.jvm.toolchain.internal.ToolchainDownloadFailedException;
import org.gradle.jvm.toolchain.internal.install.DefaultJdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.internal.install.SecureFileDownloader;
import org.gradle.platform.BuildPlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJavaToolchainProvisioningService
implements JavaToolchainProvisioningService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJavaToolchainProvisioningService.class);
    private static final Object PROVISIONING_PROCESS_LOCK = new Object();
    private final JavaToolchainResolverRegistryInternal toolchainResolverRegistry;
    private final SecureFileDownloader downloader;
    private final DefaultJdkCacheDirectory cacheDirProvider;
    private final Provider<Boolean> downloadEnabled;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildPlatform buildPlatform;

    @Inject
    public DefaultJavaToolchainProvisioningService(JavaToolchainResolverRegistry toolchainResolverRegistry, SecureFileDownloader downloader, JdkCacheDirectory cacheDirProvider, ProviderFactory factory, BuildOperationRunner executor, BuildPlatform buildPlatform) {
        this.toolchainResolverRegistry = (JavaToolchainResolverRegistryInternal)toolchainResolverRegistry;
        this.downloader = downloader;
        this.cacheDirProvider = (DefaultJdkCacheDirectory)cacheDirProvider;
        this.downloadEnabled = factory.gradleProperty("org.gradle.java.installations.auto-download").map(Boolean::parseBoolean);
        this.buildOperationRunner = executor;
        this.buildPlatform = buildPlatform;
    }

    @Override
    public boolean isAutoDownloadEnabled() {
        return (Boolean)this.downloadEnabled.getOrElse((Object)true);
    }

    @Override
    public boolean hasConfiguredToolchainRepositories() {
        return !this.toolchainResolverRegistry.requestedRepositories().isEmpty();
    }

    @Override
    public File tryInstall(JavaToolchainSpec spec) {
        if (!this.isAutoDownloadEnabled()) {
            throw new ToolchainDownloadFailedException("No locally installed toolchains match and toolchain auto-provisioning is not enabled.", "Learn more about toolchain auto-detection at " + Documentation.userManual((String)"toolchains", (String)"sec:auto_detection").getUrl() + ".");
        }
        List<? extends RealizedJavaToolchainRepository> repositories = this.toolchainResolverRegistry.requestedRepositories();
        if (repositories.isEmpty()) {
            throw new ToolchainDownloadFailedException("No locally installed toolchains match and toolchain download repositories have not been configured.", "Learn more about toolchain auto-detection at " + Documentation.userManual((String)"toolchains", (String)"sec:auto_detection").getUrl() + ".", "Learn more about toolchain repositories at " + Documentation.userManual((String)"toolchains", (String)"sub:download_repositories").getUrl() + ".");
        }
        ToolchainDownloadFailureTracker downloadFailureTracker = new ToolchainDownloadFailureTracker();
        File successfulProvisioning = null;
        for (RealizedJavaToolchainRepository realizedJavaToolchainRepository : repositories) {
            Optional<JavaToolchainDownload> download;
            JavaToolchainResolver resolver = realizedJavaToolchainRepository.getResolver();
            try {
                download = resolver.resolve(new DefaultJavaToolchainRequest(spec, this.buildPlatform));
            }
            catch (Exception e) {
                downloadFailureTracker.addResolveFailure(realizedJavaToolchainRepository.getRepositoryName(), e);
                continue;
            }
            try {
                if (!download.isPresent()) continue;
                Collection<Authentication> authentications = realizedJavaToolchainRepository.getAuthentications(download.get().getUri());
                successfulProvisioning = this.provisionInstallation(spec, download.get().getUri(), authentications);
                break;
            }
            catch (Exception e) {
                downloadFailureTracker.addProvisioningFailure(realizedJavaToolchainRepository.getRepositoryName(), e);
            }
        }
        if (successfulProvisioning == null) {
            throw downloadFailureTracker.buildFailureException();
        }
        downloadFailureTracker.logFailuresIfAny();
        return successfulProvisioning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File provisionInstallation(JavaToolchainSpec spec, URI uri, Collection<Authentication> authentications) {
        Object object = PROVISIONING_PROCESS_LOCK;
        synchronized (object) {
            File file;
            File downloadFolder = this.cacheDirProvider.getDownloadLocation();
            ExternalResource resource = this.wrapInOperation("Examining toolchain URI " + uri, () -> this.downloader.getResourceFor(uri, authentications));
            File archiveFile = new File(downloadFolder, this.getFileName(uri, resource));
            FileLock fileLock = this.cacheDirProvider.acquireWriteLock(archiveFile, "Downloading toolchain");
            try {
                if (!archiveFile.exists()) {
                    this.wrapInOperation("Downloading toolchain from URI " + uri, () -> {
                        this.downloader.download(uri, archiveFile, resource);
                        return null;
                    });
                }
                file = this.wrapInOperation("Unpacking toolchain archive " + archiveFile.getName(), () -> this.cacheDirProvider.provisionFromArchive(spec, archiveFile, uri));
            }
            catch (Throwable throwable) {
                try {
                    fileLock.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MissingToolchainException(spec, uri, e);
                }
            }
            fileLock.close();
            return file;
        }
    }

    private String getFileName(URI uri, ExternalResource resource) {
        ExternalResourceMetaData metaData = resource.getMetaData();
        if (metaData == null) {
            throw ResourceExceptions.getMissing((URI)uri);
        }
        String fileName = metaData.getFilename();
        if (fileName == null) {
            throw new GradleException("Can't determine filename for resource located at: " + uri);
        }
        return fileName;
    }

    private <T> T wrapInOperation(String displayName, Callable<T> provisioningStep) {
        return (T)this.buildOperationRunner.call(new ToolchainProvisioningBuildOperation<T>(displayName, provisioningStep));
    }

    private static class ToolchainDownloadFailureTracker {
        private final Map<String, Exception> resolveFailures = new TreeMap<String, Exception>();
        private final Map<String, Exception> provisioningFailures = new TreeMap<String, Exception>();

        private ToolchainDownloadFailureTracker() {
        }

        public void addResolveFailure(String repositoryName, Exception failure) {
            this.resolveFailures.put(repositoryName, failure);
        }

        public void addProvisioningFailure(String repositoryName, Exception failure) {
            this.provisioningFailures.put(repositoryName, failure);
        }

        public ToolchainDownloadFailedException buildFailureException() {
            String message = "No matching toolchain could be found in the locally installed toolchains or the configured toolchain download repositories." + (this.hasFailures() ? " " + this.failureMessage() : "");
            String[] resolutions = new String[]{"Learn more about toolchain auto-detection at " + Documentation.userManual((String)"toolchains", (String)"sec:auto_detection").getUrl() + ".", "Learn more about toolchain repositories at " + Documentation.userManual((String)"toolchains", (String)"sub:download_repositories").getUrl() + "."};
            ToolchainDownloadFailedException exception = new ToolchainDownloadFailedException(message, resolutions);
            return this.addFailuresAsSuppressed(exception);
        }

        private <T extends Exception> T addFailuresAsSuppressed(T exception) {
            for (Exception resolveFailure : this.resolveFailures.values()) {
                exception.addSuppressed(resolveFailure);
            }
            for (Exception provisionFailure : this.provisioningFailures.values()) {
                exception.addSuppressed(provisionFailure);
            }
            return exception;
        }

        public void logFailuresIfAny() {
            if (this.hasFailures()) {
                LOGGER.warn(this.failureMessage() + " Switch logging level to DEBUG (--debug) for further information.");
                if (LOGGER.isDebugEnabled()) {
                    String failureMessage = this.failureMessage();
                    LOGGER.debug(failureMessage, (Throwable)this.addFailuresAsSuppressed(new Exception(failureMessage)));
                }
            }
        }

        private boolean hasFailures() {
            return !this.resolveFailures.isEmpty() || !this.provisioningFailures.isEmpty();
        }

        private String failureMessage() {
            StringBuilder sb = new StringBuilder();
            if (!this.resolveFailures.isEmpty()) {
                sb.append("Some toolchain resolvers had internal failures: ").append(ToolchainDownloadFailureTracker.failureMessage(this.resolveFailures)).append(".");
            }
            if (!this.provisioningFailures.isEmpty()) {
                sb.append(this.resolveFailures.isEmpty() ? "" : " ");
                sb.append("Some toolchain resolvers had provisioning failures: ").append(ToolchainDownloadFailureTracker.failureMessage(this.provisioningFailures)).append(".");
            }
            return sb.toString();
        }

        private static String failureMessage(Map<String, Exception> failures) {
            return failures.entrySet().stream().map(e -> (String)e.getKey() + " (" + ((Exception)e.getValue()).getMessage() + ")").collect(Collectors.joining(", "));
        }
    }

    private static class ToolchainProvisioningBuildOperation<T>
    implements CallableBuildOperation<T> {
        private final String displayName;
        private final Callable<T> provisioningStep;

        public ToolchainProvisioningBuildOperation(String displayName, Callable<T> provisioningStep) {
            this.displayName = displayName;
            this.provisioningStep = provisioningStep;
        }

        public T call(BuildOperationContext context) throws Exception {
            return this.provisioningStep.call();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.displayName).progressDisplayName(this.displayName);
        }
    }

    private static class MissingToolchainException
    extends GradleException {
        public MissingToolchainException(JavaToolchainSpec spec, URI uri, @Nullable Throwable cause) {
            super("Unable to download toolchain matching the requirements (" + spec.getDisplayName() + ") from '" + uri + "'" + (cause != null ? ", due to: " + cause.getMessage() : "."));
        }
    }
}

