/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import com.google.common.base.Preconditions;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.problems.internal.DocLink;

public abstract class Documentation
implements DocLink {
    public static final String RECOMMENDATION = "For more %s, please refer to %s in the Gradle documentation.";
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();

    public static Documentation userManual(String id, String section) {
        return new UserGuide(id, section);
    }

    public static Documentation userManual(String id) {
        return new UserGuide(id, null);
    }

    static Documentation upgradeGuide(int majorVersion, String upgradeGuideSection) {
        return new UpgradeGuide(majorVersion, upgradeGuideSection);
    }

    public static Documentation dslReference(Class<?> targetClass, String property) {
        return new DslReference(targetClass, property);
    }

    public static Documentation kotlinDslExtensionReference(String extensionName) {
        return new KotlinDslExtensionReference(extensionName);
    }

    public String getConsultDocumentationMessage() {
        return String.format(RECOMMENDATION, "information", this.getUrl());
    }

    private static class KotlinDslExtensionReference
    extends SerializableDocumentation {
        private final String extensionName;

        public KotlinDslExtensionReference(String extensionName) {
            this.extensionName = extensionName;
        }

        public String getUrl() {
            return DOCUMENTATION_REGISTRY.getKotlinDslRefForExtension(this.extensionName);
        }
    }

    private static class DslReference
    extends SerializableDocumentation {
        private final Class<?> targetClass;
        private final String property;

        public DslReference(Class<?> targetClass, String property) {
            this.targetClass = (Class)Preconditions.checkNotNull(targetClass);
            this.property = (String)Preconditions.checkNotNull((Object)property);
        }

        public String getUrl() {
            return DOCUMENTATION_REGISTRY.getDslRefForProperty(this.targetClass, this.property);
        }
    }

    private static class UpgradeGuide
    extends UserGuide {
        private UpgradeGuide(int majorVersion, String section) {
            super("upgrading_version_" + majorVersion, section);
        }

        @Override
        public String getConsultDocumentationMessage() {
            return "Consult the upgrading guide for further information: " + this.getUrl();
        }
    }

    private static class UserGuide
    extends SerializableDocumentation {
        private final String page;
        private final String section;
        private final String topic;

        private UserGuide(String id, @Nullable String section) {
            this.page = (String)Preconditions.checkNotNull((Object)id);
            this.section = section;
            this.topic = null;
        }

        public String getUrl() {
            if (this.section == null) {
                return DOCUMENTATION_REGISTRY.getDocumentationFor(this.page);
            }
            if (this.topic == null) {
                return DOCUMENTATION_REGISTRY.getDocumentationFor(this.page, this.section);
            }
            return DOCUMENTATION_REGISTRY.getDocumentationRecommendationFor(this.topic, this.page, this.section);
        }
    }

    public static abstract class AbstractBuilder<T> {
        public abstract T withDocumentation(@Nullable DocLink var1);

        @CheckReturnValue
        public T undocumented() {
            return this.withDocumentation(null);
        }

        @CheckReturnValue
        public T withUserManual(String documentationId) {
            return this.withDocumentation(Documentation.userManual(documentationId));
        }

        @CheckReturnValue
        public T withUserManual(String documentationId, String section) {
            return this.withDocumentation(Documentation.userManual(documentationId, section));
        }

        @CheckReturnValue
        public T withDslReference(Class<?> targetClass, String property) {
            return this.withDocumentation(Documentation.dslReference(targetClass, property));
        }

        @CheckReturnValue
        public T withUpgradeGuideSection(int majorVersion, String upgradeGuideSection) {
            return this.withDocumentation(Documentation.upgradeGuide(majorVersion, upgradeGuideSection));
        }
    }

    private static abstract class SerializableDocumentation
    extends Documentation {
        private SerializableDocumentation() {
        }
    }
}

