/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.configurations.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportArtifact;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportAttribute;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportCapability;
import org.gradle.api.tasks.diagnostics.internal.configurations.model.ReportSecondaryVariant;

public final class ReportConfiguration {
    private final String name;
    @Nullable
    private final String description;
    @Nullable
    private final Type type;
    private final List<? extends GradleException> lenientErrors;
    private final ImmutableList<ReportAttribute> attributes;
    private final ImmutableList<ReportCapability> capabilities;
    private final ImmutableList<ReportArtifact> artifacts;
    private final ImmutableList<ReportSecondaryVariant> variants;
    private final ImmutableList<ReportConfiguration> extendedConfigurations;

    ReportConfiguration(String name, @Nullable String description, @Nullable Type type, List<? extends GradleException> lenientErrors, List<ReportAttribute> attributes, List<ReportCapability> capabilities, List<ReportArtifact> artifacts, List<ReportSecondaryVariant> variants, List<ReportConfiguration> extendedConfigurations) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.lenientErrors = ImmutableList.copyOf(lenientErrors);
        this.attributes = ImmutableList.copyOf(attributes);
        this.capabilities = ImmutableList.copyOf(capabilities);
        this.artifacts = ImmutableList.copyOf(artifacts);
        this.variants = ImmutableList.copyOf(variants);
        this.extendedConfigurations = ImmutableList.copyOf(extendedConfigurations);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    public List<? extends GradleException> getLenientErrors() {
        return this.lenientErrors;
    }

    public List<ReportAttribute> getAttributes() {
        return this.attributes;
    }

    public List<ReportCapability> getCapabilities() {
        return this.capabilities;
    }

    public List<ReportArtifact> getArtifacts() {
        return this.artifacts;
    }

    public List<ReportSecondaryVariant> getSecondaryVariants() {
        return this.variants;
    }

    public List<ReportConfiguration> getExtendedConfigurations() {
        return this.extendedConfigurations;
    }

    public boolean isPurelyConsumable() {
        return Type.CONSUMABLE == this.type;
    }

    public boolean isPurelyResolvable() {
        return Type.RESOLVABLE == this.type;
    }

    public boolean isLegacy() {
        return Type.LEGACY == this.type;
    }

    public boolean hasIncubatingAttributes() {
        return this.attributes.stream().anyMatch(ReportAttribute::isIncubating);
    }

    public boolean hasVariants() {
        return !this.variants.isEmpty();
    }

    public static enum Type {
        CONSUMABLE,
        RESOLVABLE,
        LEGACY;

    }
}

