/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import com.google.common.collect.ImmutableList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.util.internal.TextUtil;

public class PluginResolutionResult {
    private final PluginResolution found;
    private final ImmutableList<NotFound> notFoundList;

    public PluginResolutionResult(@Nullable PluginResolution found, ImmutableList<NotFound> notFoundList) {
        this.found = found;
        this.notFoundList = notFoundList;
    }

    public static PluginResolutionResult notFound() {
        return new PluginResolutionResult(null, (ImmutableList<NotFound>)ImmutableList.of());
    }

    public static PluginResolutionResult notFound(String sourceDescription, String notFoundMessage) {
        return new PluginResolutionResult(null, (ImmutableList<NotFound>)ImmutableList.of((Object)new NotFound(sourceDescription, notFoundMessage, null)));
    }

    public static PluginResolutionResult notFound(String sourceDescription, String notFoundMessage, String notFoundDetail) {
        return new PluginResolutionResult(null, (ImmutableList<NotFound>)ImmutableList.of((Object)new NotFound(sourceDescription, notFoundMessage, notFoundDetail)));
    }

    public static PluginResolutionResult notFound(ImmutableList<NotFound> notFoundList) {
        return new PluginResolutionResult(null, notFoundList);
    }

    public static PluginResolutionResult found(PluginResolution pluginResolution) {
        return new PluginResolutionResult(pluginResolution, (ImmutableList<NotFound>)ImmutableList.of());
    }

    public boolean isFound() {
        return this.found != null;
    }

    public PluginResolution getFound(PluginRequestInternal request) {
        if (this.found != null) {
            return this.found;
        }
        Formatter sb = new Formatter();
        sb.format("Plugin %s was not found in any of the following sources:%n", request.getDisplayName());
        for (NotFound notFound : this.notFoundList) {
            sb.format("%n- %s (%s)", notFound.source, notFound.message);
            if (notFound.detail == null) continue;
            sb.format("%n%s", TextUtil.indent((String)notFound.detail, (String)"  "));
        }
        String message = sb.toString();
        UnknownPluginException exception = new UnknownPluginException(message);
        throw new LocationAwareException((Throwable)exception, request.getScriptDisplayName(), request.getLineNumber());
    }

    public List<NotFound> getNotFound() {
        assert (!this.isFound());
        return this.notFoundList;
    }

    public static class NotFound {
        private final String source;
        private final String message;
        private final String detail;

        private NotFound(String source, String message, @Nullable String detail) {
            this.source = source;
            this.message = message;
            this.detail = detail;
        }
    }
}

