/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.DefaultCacheCleanupStrategy;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.streams.DefaultValueStore;
import org.gradle.cache.internal.streams.ValueStore;
import org.gradle.cache.scopes.BuildTreeScopedCacheBuilderFactory;
import org.gradle.internal.cc.impl.ConfigurationCacheRepository;
import org.gradle.internal.cc.impl.ConfigurationCacheStateFile;
import org.gradle.internal.cc.impl.ConfigurationCacheStateStore;
import org.gradle.internal.cc.impl.StateType;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.extensions.stdlib.StringExtensionsKt;
import org.gradle.internal.extensions.stdlib.UnsafeLazyKt;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.time.TimestampSuppliers;
import org.jetbrains.annotations.NotNull;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001:\u0006234567B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001cH\u0002J\b\u0010'\u001a\u00020\u001aH\u0016J/\u0010(\u001a\u0002H)\"\u0004\b\u0000\u0010)2\u0006\u0010*\u001a\u00020\u001c2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u0002H)0,H\u0002\u00a2\u0006\u0002\u0010-J\u0014\u0010.\u001a\u00020\u001c*\u00020\n2\u0006\u0010 \u001a\u00020\u0015H\u0002J\u0014\u0010&\u001a\u00020\u001c*\u00020\u001c2\u0006\u0010/\u001a\u00020\u0016H\u0002J\f\u00100\u001a\u000201*\u000201H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00068"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository;", "Lorg/gradle/internal/concurrent/Stoppable;", "cacheBuilderFactory", "Lorg/gradle/cache/scopes/BuildTreeScopedCacheBuilderFactory;", "fileAccessTimeJournal", "Lorg/gradle/internal/file/FileAccessTimeJournal;", "fileSystem", "Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;", "(Lorg/gradle/cache/scopes/BuildTreeScopedCacheBuilderFactory;Lorg/gradle/internal/file/FileAccessTimeJournal;Lorg/gradle/internal/nativeintegration/filesystem/FileSystem;)V", "cache", "Lorg/gradle/cache/PersistentCache;", "cleanupDepth", "", "cleanupMaxAgeDays", "fileAccessTracker", "Lorg/gradle/internal/file/impl/SingleDepthFileAccessTracker;", "getFileAccessTracker", "()Lorg/gradle/internal/file/impl/SingleDepthFileAccessTracker;", "fileAccessTracker$delegate", "Lkotlin/Lazy;", "fileBaseName", "", "Lorg/gradle/internal/cc/impl/StateType;", "getFileBaseName", "(Lorg/gradle/internal/cc/impl/StateType;)Ljava/lang/String;", "chmod", "", "file", "Ljava/io/File;", "mode", "forKey", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore;", "cacheKey", "includedBuildFileFor", "parentStateFile", "build", "Lorg/gradle/api/internal/BuildDefinition;", "markAccessed", "stateFile", "stop", "withExclusiveAccessToCache", "T", "baseDir", "action", "Lkotlin/Function1;", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "baseDirFor", "stateType", "withLruCacheCleanup", "Lorg/gradle/cache/CacheBuilder;", "Layout", "ReadableConfigurationCacheStateFile", "ReadableLayout", "StoreImpl", "WriteableConfigurationCacheStateFile", "WriteableLayout", "configuration-cache"})
public final class ConfigurationCacheRepository
implements Stoppable {
    @NotNull
    private final FileAccessTimeJournal fileAccessTimeJournal;
    @NotNull
    private final FileSystem fileSystem;
    private final int cleanupDepth;
    private final int cleanupMaxAgeDays;
    @NotNull
    private final PersistentCache cache;
    @NotNull
    private final Lazy fileAccessTracker$delegate;

    public ConfigurationCacheRepository(@NotNull BuildTreeScopedCacheBuilderFactory cacheBuilderFactory, @NotNull FileAccessTimeJournal fileAccessTimeJournal, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)cacheBuilderFactory, (String)"cacheBuilderFactory");
        Intrinsics.checkNotNullParameter((Object)fileAccessTimeJournal, (String)"fileAccessTimeJournal");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileAccessTimeJournal = fileAccessTimeJournal;
        this.fileSystem = fileSystem;
        this.cleanupDepth = 1;
        this.cleanupMaxAgeDays = 7;
        CacheBuilder cacheBuilder = cacheBuilderFactory.createCrossVersionCacheBuilder("configuration-cache").withDisplayName("Configuration Cache").withInitialLockMode(FileLockManager.LockMode.OnDemand);
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"cacheBuilderFactory\n    \u2026anager.LockMode.OnDemand)");
        PersistentCache persistentCache = this.withLruCacheCleanup(cacheBuilder).open();
        Intrinsics.checkNotNullExpressionValue((Object)persistentCache, (String)"cacheBuilderFactory\n    \u2026Cleanup()\n        .open()");
        this.cache = persistentCache;
        this.fileAccessTracker$delegate = UnsafeLazyKt.unsafeLazy((Function0)((Function0)new Function0<SingleDepthFileAccessTracker>(this){
            final /* synthetic */ ConfigurationCacheRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SingleDepthFileAccessTracker invoke() {
                return new SingleDepthFileAccessTracker(ConfigurationCacheRepository.access$getFileAccessTimeJournal$p(this.this$0), ConfigurationCacheRepository.access$getCache$p(this.this$0).getBaseDir(), ConfigurationCacheRepository.access$getCleanupDepth$p(this.this$0));
            }
        }));
    }

    @NotNull
    public final ConfigurationCacheStateStore forKey(@NotNull String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return new StoreImpl(this.baseDirFor(this.cache, cacheKey));
    }

    public void stop() {
        this.cache.close();
    }

    private final File includedBuildFileFor(File parentStateFile, BuildDefinition build) {
        File $this$includedBuildFileFor_u24lambda_u240 = parentStateFile;
        boolean bl = false;
        return FilesKt.resolveSibling((File)$this$includedBuildFileFor_u24lambda_u240, (String)($this$includedBuildFileFor_u24lambda_u240.getName() + '.' + build.getName()));
    }

    private final CacheBuilder withLruCacheCleanup(CacheBuilder $this$withLruCacheCleanup) {
        CacheBuilder cacheBuilder = $this$withLruCacheCleanup.withCleanupStrategy((CacheCleanupStrategy)DefaultCacheCleanupStrategy.from((CleanupAction)((CleanupAction)new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(this.cleanupDepth), this.fileAccessTimeJournal, TimestampSuppliers.daysAgo((int)this.cleanupMaxAgeDays)))));
        Intrinsics.checkNotNullExpressionValue((Object)cacheBuilder, (String)"withCleanupStrategy(\n   \u2026)\n            )\n        )");
        return cacheBuilder;
    }

    private final SingleDepthFileAccessTracker getFileAccessTracker() {
        Lazy lazy = this.fileAccessTracker$delegate;
        return (SingleDepthFileAccessTracker)lazy.getValue();
    }

    private final void chmod(File file, int mode) {
        this.fileSystem.chmod(file, mode);
    }

    private final void markAccessed(File stateFile) {
        this.getFileAccessTracker().markAccessed(stateFile);
    }

    private final <T> T withExclusiveAccessToCache(File baseDir, Function1<? super File, ? extends T> action) {
        return (T)this.cache.withFileLock(new Supplier(action, baseDir){
            final /* synthetic */ Function1<File, T> $action;
            final /* synthetic */ File $baseDir;
            {
                this.$action = $action;
                this.$baseDir = $baseDir;
            }

            public final T get() {
                return (T)this.$action.invoke((Object)this.$baseDir);
            }
        });
    }

    private final File baseDirFor(PersistentCache $this$baseDirFor, String cacheKey) {
        File file = $this$baseDirFor.getBaseDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"baseDir");
        return FilesKt.resolve((File)file, (String)cacheKey);
    }

    private final String getFileBaseName(StateType $this$fileBaseName) {
        return StringExtensionsKt.toDefaultLowerCase((String)$this$fileBaseName.name());
    }

    private final File stateFile(File $this$stateFile, StateType stateType) {
        return FilesKt.resolve((File)$this$stateFile, (String)(this.getFileBaseName(stateType) + ".bin"));
    }

    public static final /* synthetic */ void access$chmod(ConfigurationCacheRepository $this, File file, int mode) {
        $this.chmod(file, mode);
    }

    public static final /* synthetic */ FileAccessTimeJournal access$getFileAccessTimeJournal$p(ConfigurationCacheRepository $this) {
        return $this.fileAccessTimeJournal;
    }

    public static final /* synthetic */ PersistentCache access$getCache$p(ConfigurationCacheRepository $this) {
        return $this.cache;
    }

    public static final /* synthetic */ int access$getCleanupDepth$p(ConfigurationCacheRepository $this) {
        return $this.cleanupDepth;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\b"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$Layout;", "", "()V", "fileFor", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "fileForRead", "configuration-cache"})
    public static abstract class Layout {
        @NotNull
        public abstract ConfigurationCacheStateFile fileForRead(@NotNull StateType var1);

        @NotNull
        public abstract ConfigurationCacheStateFile fileFor(@NotNull StateType var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$ReadableConfigurationCacheStateFile;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "file", "Ljava/io/File;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "(Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository;Ljava/io/File;Lorg/gradle/internal/cc/impl/StateType;)V", "exists", "", "getExists", "()Z", "stateFile", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "getStateFile", "()Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "getStateType", "()Lorg/gradle/internal/cc/impl/StateType;", "delete", "", "inputStream", "Ljava/io/InputStream;", "moveFrom", "outputStream", "Ljava/io/OutputStream;", "stateFileForIncludedBuild", "build", "Lorg/gradle/api/internal/BuildDefinition;", "configuration-cache"})
    @SourceDebugExtension(value={"SMAP\nConfigurationCacheRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheRepository.kt\norg/gradle/internal/cc/impl/ConfigurationCacheRepository$ReadableConfigurationCacheStateFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
    private final class ReadableConfigurationCacheStateFile
    implements ConfigurationCacheStateFile {
        @NotNull
        private final File file;
        @NotNull
        private final StateType stateType;

        public ReadableConfigurationCacheStateFile(@NotNull File file, StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            this.file = file;
            this.stateType = stateType;
        }

        @Override
        @NotNull
        public StateType getStateType() {
            return this.stateType;
        }

        @Override
        public boolean getExists() {
            return this.file.isFile();
        }

        @Override
        @NotNull
        public ConfigurationCacheStateStore.StateFile getStateFile() {
            return new ConfigurationCacheStateStore.StateFile(this.getStateType(), this.file);
        }

        @Override
        @NotNull
        public OutputStream outputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public InputStream inputStream() {
            File file = this.file;
            ConfigurationCacheRepository configurationCacheRepository = ConfigurationCacheRepository.this;
            File p0 = file;
            boolean bl = false;
            configurationCacheRepository.markAccessed(p0);
            return new FileInputStream(file);
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void moveFrom(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile stateFileForIncludedBuild(@NotNull BuildDefinition build) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            return new ReadableConfigurationCacheStateFile(ConfigurationCacheRepository.this.includedBuildFileFor(this.file, build), this.getStateType());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$ReadableLayout;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$Layout;", "cacheDir", "Ljava/io/File;", "(Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository;Ljava/io/File;)V", "fileFor", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "fileForRead", "configuration-cache"})
    private final class ReadableLayout
    extends Layout {
        @NotNull
        private final File cacheDir;

        public ReadableLayout(File cacheDir) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            this.cacheDir = cacheDir;
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile fileForRead(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return this.fileFor(stateType);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile fileFor(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return new ReadableConfigurationCacheStateFile(ConfigurationCacheRepository.this.stateFile(this.cacheDir, stateType), stateType);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J8\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000fH\u0016J+\u0010\u0010\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\u000b0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015J3\u0010\u0010\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\u000b0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0018\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u0002H\u000b0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$StoreImpl;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore;", "baseDir", "Ljava/io/File;", "(Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository;Ljava/io/File;)V", "assignSpoolFile", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "createValueStore", "Lorg/gradle/cache/internal/streams/ValueStore;", "T", "writer", "Lorg/gradle/cache/internal/streams/ValueStore$Writer;", "reader", "Lorg/gradle/cache/internal/streams/ValueStore$Reader;", "useForStateLoad", "", "action", "Lkotlin/Function1;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$Layout;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "(Lorg/gradle/internal/cc/impl/StateType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "useForStore", "configuration-cache"})
    private final class StoreImpl
    implements ConfigurationCacheStateStore {
        @NotNull
        private final File baseDir;

        public StoreImpl(File baseDir) {
            Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
            this.baseDir = baseDir;
        }

        @Override
        @NotNull
        public ConfigurationCacheStateStore.StateFile assignSpoolFile(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Files.createDirectories(this.baseDir.toPath(), new FileAttribute[0]);
            Path tempFile = Files.createTempFile(this.baseDir.toPath(), ConfigurationCacheRepository.this.getFileBaseName(stateType), ".tmp", new FileAttribute[0]);
            File file = tempFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tempFile.toFile()");
            return new ConfigurationCacheStateStore.StateFile(stateType, file);
        }

        @Override
        @NotNull
        public <T> ValueStore<T> createValueStore(@NotNull StateType stateType, @NotNull ValueStore.Writer<T> writer2, @NotNull ValueStore.Reader<T> reader2) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Intrinsics.checkNotNullParameter(writer2, (String)"writer");
            Intrinsics.checkNotNullParameter(reader2, (String)"reader");
            return (ValueStore)new DefaultValueStore(this.baseDir, ConfigurationCacheRepository.this.getFileBaseName(stateType), writer2, reader2);
        }

        @Override
        @NotNull
        public <T> T useForStateLoad(@NotNull StateType stateType, @NotNull Function1<? super ConfigurationCacheStateFile, ? extends T> action) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return this.useForStateLoad((Function1)new Function1<Layout, T>(action, stateType){
                final /* synthetic */ Function1<ConfigurationCacheStateFile, T> $action;
                final /* synthetic */ StateType $stateType;
                {
                    this.$action = $action;
                    this.$stateType = $stateType;
                    super(1);
                }

                @NotNull
                public final T invoke(@NotNull Layout layout2) {
                    Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
                    return (T)this.$action.invoke((Object)layout2.fileFor(this.$stateType));
                }
            });
        }

        @Override
        @NotNull
        public <T> T useForStateLoad(@NotNull Function1<? super Layout, ? extends T> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return (T)ConfigurationCacheRepository.this.withExclusiveAccessToCache(this.baseDir, new Function1<File, T>(action, ConfigurationCacheRepository.this){
                final /* synthetic */ Function1<Layout, T> $action;
                final /* synthetic */ ConfigurationCacheRepository this$0;
                {
                    this.$action = $action;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final T invoke(@NotNull File cacheDir) {
                    Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
                    return (T)this.$action.invoke((Object)this.this$0.new ReadableLayout(cacheDir));
                }
            });
        }

        @Override
        public <T> T useForStore(@NotNull Function1<? super Layout, ? extends T> action) {
            Intrinsics.checkNotNullParameter(action, (String)"action");
            return (T)ConfigurationCacheRepository.this.withExclusiveAccessToCache(this.baseDir, new Function1<File, T>(ConfigurationCacheRepository.this, action){
                final /* synthetic */ ConfigurationCacheRepository this$0;
                final /* synthetic */ Function1<Layout, T> $action;
                {
                    this.this$0 = $receiver;
                    this.$action = $action;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final T invoke(@NotNull File cacheDir) {
                    void $this$forEach$iv;
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
                    Files.createDirectories(cacheDir.toPath(), new FileAttribute[0]);
                    ConfigurationCacheRepository.access$chmod(this.this$0, cacheDir, 448);
                    ConfigurationCacheRepository.access$markAccessed(this.this$0, cacheDir);
                    List stateFiles = new ArrayList<E>();
                    WriteableLayout layout2 = this.this$0.new WriteableLayout(cacheDir, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>((Object)stateFiles){

                        public final void invoke(@NotNull File p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            ((List)this.receiver).add(p0);
                        }
                    }));
                    try {
                        object = this.$action.invoke((Object)layout2);
                    }
                    catch (Throwable throwable) {
                        void $this$forEach$iv2;
                        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)stateFiles), (Function1)useForStore.1.INSTANCE);
                        ConfigurationCacheRepository configurationCacheRepository = this.this$0;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv2) {
                            File it = (File)element$iv;
                            boolean bl = false;
                            ConfigurationCacheRepository.access$chmod(configurationCacheRepository, it, 384);
                        }
                        throw throwable;
                    }
                    Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)stateFiles), (Function1)useForStore.1.INSTANCE);
                    ConfigurationCacheRepository configurationCacheRepository = this.this$0;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        File it = (File)element$iv;
                        boolean bl = false;
                        ConfigurationCacheRepository.access$chmod(configurationCacheRepository, it, 384);
                    }
                    return (T)object;
                }
            });
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$WriteableConfigurationCacheStateFile;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "file", "Ljava/io/File;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "onFileAccess", "Lkotlin/Function1;", "", "(Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository;Ljava/io/File;Lorg/gradle/internal/cc/impl/StateType;Lkotlin/jvm/functions/Function1;)V", "exists", "", "getExists", "()Z", "stateFile", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "getStateFile", "()Lorg/gradle/internal/cc/impl/ConfigurationCacheStateStore$StateFile;", "getStateType", "()Lorg/gradle/internal/cc/impl/StateType;", "delete", "inputStream", "Ljava/io/InputStream;", "moveFrom", "outputStream", "Ljava/io/OutputStream;", "stateFileForIncludedBuild", "build", "Lorg/gradle/api/internal/BuildDefinition;", "configuration-cache"})
    private final class WriteableConfigurationCacheStateFile
    implements ConfigurationCacheStateFile {
        @NotNull
        private final File file;
        @NotNull
        private final StateType stateType;
        @NotNull
        private final Function1<File, Unit> onFileAccess;

        public WriteableConfigurationCacheStateFile(@NotNull File file, @NotNull StateType stateType, Function1<? super File, Unit> onFileAccess) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            Intrinsics.checkNotNullParameter(onFileAccess, (String)"onFileAccess");
            this.file = file;
            this.stateType = stateType;
            this.onFileAccess = onFileAccess;
        }

        @Override
        @NotNull
        public StateType getStateType() {
            return this.stateType;
        }

        @Override
        public boolean getExists() {
            return false;
        }

        @Override
        @NotNull
        public ConfigurationCacheStateStore.StateFile getStateFile() {
            return new ConfigurationCacheStateStore.StateFile(this.getStateType(), this.file);
        }

        @Override
        @NotNull
        public OutputStream outputStream() {
            File file = this.file;
            this.onFileAccess.invoke((Object)file);
            return new FileOutputStream(file);
        }

        @Override
        @NotNull
        public InputStream inputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete() {
            if (this.file.exists()) {
                Files.delete(this.file.toPath());
            }
        }

        @Override
        public void moveFrom(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(file.toPath(), this.file.toPath(), copyOptionArray);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile stateFileForIncludedBuild(@NotNull BuildDefinition build) {
            Intrinsics.checkNotNullParameter((Object)build, (String)"build");
            return new WriteableConfigurationCacheStateFile(ConfigurationCacheRepository.this.includedBuildFileFor(this.file, build), this.getStateType(), this.onFileAccess);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00060\rR\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$WriteableLayout;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$Layout;", "cacheDir", "Ljava/io/File;", "onFileAccess", "Lkotlin/Function1;", "", "(Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository;Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "fileFor", "Lorg/gradle/internal/cc/impl/ConfigurationCacheStateFile;", "stateType", "Lorg/gradle/internal/cc/impl/StateType;", "fileForRead", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository$ReadableConfigurationCacheStateFile;", "Lorg/gradle/internal/cc/impl/ConfigurationCacheRepository;", "configuration-cache"})
    private final class WriteableLayout
    extends Layout {
        @NotNull
        private final File cacheDir;
        @NotNull
        private final Function1<File, Unit> onFileAccess;

        public WriteableLayout(@NotNull File cacheDir, Function1<? super File, Unit> onFileAccess) {
            Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
            Intrinsics.checkNotNullParameter(onFileAccess, (String)"onFileAccess");
            this.cacheDir = cacheDir;
            this.onFileAccess = onFileAccess;
        }

        @Override
        @NotNull
        public ReadableConfigurationCacheStateFile fileForRead(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return new ReadableConfigurationCacheStateFile(ConfigurationCacheRepository.this.stateFile(this.cacheDir, stateType), stateType);
        }

        @Override
        @NotNull
        public ConfigurationCacheStateFile fileFor(@NotNull StateType stateType) {
            Intrinsics.checkNotNullParameter((Object)((Object)stateType), (String)"stateType");
            return new WriteableConfigurationCacheStateFile(ConfigurationCacheRepository.this.stateFile(this.cacheDir, stateType), stateType, this.onFileAccess);
        }
    }
}

