/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.value.StringValue;

public final class TinyTextImpl
extends TinyNodeImpl {
    public TinyTextImpl(TinyTree tree, int nodeNr) {
        super(tree, nodeNr);
    }

    public static UnicodeString getStringValue(TinyTree tree, int nodeNr) {
        int start = tree.alpha[nodeNr];
        int len = tree.beta[nodeNr];
        return tree.textBuffer.substring(start, start + len);
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        return TinyTextImpl.getStringValue(this.tree, this.nodeNr);
    }

    @Override
    public final int getNodeKind() {
        return 3;
    }

    @Override
    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        out.characters(this.getUnicodeStringValue(), locationId, 0);
    }

    @Override
    public AtomicSequence atomize() {
        return StringValue.makeUntypedAtomic(this.getUnicodeStringValue());
    }
}

