/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import java.awt.Rectangle;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class Sprite
extends Layer {
    int refX;
    int refY;
    int[] sequence;
    int frameIndex;
    int transformation;
    int refXTransformed;
    int refYTransformed;
    int collX;
    int collY;
    int collW;
    int collH;
    Rectangle currentCollRect = new Rectangle();
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;

    public Sprite(Image image) {
        this(image, image.getWidth(), image.getHeight());
    }

    public Sprite(Image image, int frameWidth, int frameHeight) {
        this.image = image;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.w = this.collW = frameWidth;
        this.h = this.collH = frameHeight;
        this.currentCollRect.width = this.collW;
        this.currentCollRect.height = this.collH;
        this.setTransform(0);
    }

    public Sprite(Sprite sprite) {
        this(sprite.image, sprite.frameWidth, sprite.frameHeight);
        this.sequence = sprite.sequence;
        this.frameIndex = sprite.frameIndex;
        this.refX = sprite.refX;
        this.refY = sprite.refY;
        this.x = sprite.x;
        this.y = sprite.y;
        this.collX = sprite.collX;
        this.collY = sprite.collY;
        this.collW = sprite.collW;
        this.collH = sprite.collH;
        this.transformation = sprite.transformation;
        this.setTransform(sprite.transformation);
    }

    public void defineReferencePixel(int x, int y) {
        int saveTransform = this.transformation;
        this.setTransform(0);
        this.refX = x;
        this.refY = y;
        this.setTransform(saveTransform);
    }

    public void setRefPixelPosition(int x, int y) {
        this.setPosition(x - this.refXTransformed, y - this.refYTransformed);
    }

    public int getRefPixelX() {
        return this.refX;
    }

    public int getRefPixelY() {
        return this.refY;
    }

    public void setFrame(int sequenceIndex) {
        this.frameIndex = sequenceIndex;
    }

    public final int getFrame() {
        return this.frameIndex;
    }

    public int getRawFrameCount() {
        return this.getFrameCount();
    }

    public int getFrameSequenceLength() {
        return this.sequence == null ? this.getFrameCount() : this.sequence.length;
    }

    public void nextFrame() {
        ++this.frameIndex;
        if (this.frameIndex >= this.getFrameSequenceLength()) {
            this.frameIndex = 0;
        }
    }

    public void prevFrame() {
        --this.frameIndex;
        if (this.frameIndex < 0) {
            this.frameIndex = this.getFrameSequenceLength() - 1;
        }
    }

    public final void paint(Graphics g) {
        this.drawImage(g, 0, 0, this.sequence == null ? this.frameIndex : this.sequence[this.frameIndex], this.transformation);
    }

    public void setPosition(int x, int y) {
        this.currentCollRect.x += x - this.x;
        this.currentCollRect.y += y - this.y;
        super.setPosition(x, y);
    }

    public void setFrameSequence(int[] sequence) {
        if (sequence == null) {
            this.sequence = null;
        } else {
            this.sequence = new int[sequence.length];
            System.arraycopy(sequence, 0, this.sequence, 0, sequence.length);
        }
        this.frameIndex = 0;
    }

    public void setImage(Image image, int frameWidth, int frameHeight) {
        int oldFrameCount = this.getRawFrameCount();
        this.image = image;
        if (frameWidth != this.frameWidth || frameHeight != this.frameHeight) {
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.collX = 0;
            this.collY = 0;
            this.collW = frameWidth;
            this.collH = frameHeight;
        }
        if (this.getRawFrameCount() < oldFrameCount) {
            this.setFrameSequence(null);
        }
        this.setTransform(this.transformation);
    }

    public void defineCollisionRectangle(int cx, int cy, int cw, int ch) {
        this.collX = cx;
        this.collY = cy;
        this.collW = cw;
        this.collH = ch;
        this.setTransform(this.transformation);
    }

    public void setTransform(int transform) {
        int oldRefX = this.refXTransformed;
        int oldRefY = this.refYTransformed;
        switch (this.transformation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.currentCollRect.width = this.collW;
                this.currentCollRect.height = this.collH;
                break;
            }
            default: {
                this.currentCollRect.width = this.collH;
                this.currentCollRect.height = this.collW;
            }
        }
        switch (this.transformation) {
            case 0: {
                this.refXTransformed = this.refX;
                this.refYTransformed = this.refY;
                break;
            }
            case 5: {
                this.refXTransformed = this.refY;
                this.refYTransformed = this.refX;
                break;
            }
            case 3: {
                this.refXTransformed = this.frameWidth - this.refX;
                this.refYTransformed = this.frameHeight - this.refY;
                break;
            }
            case 6: {
                this.refXTransformed = this.frameHeight - this.refY;
                this.refYTransformed = this.frameWidth - this.refX;
            }
            case 2: {
                this.refXTransformed = this.frameWidth - this.refX;
                this.refYTransformed = this.refY;
                break;
            }
            case 7: {
                this.refXTransformed = this.refY;
                this.refYTransformed = this.frameWidth - this.refX;
                break;
            }
            case 1: {
                this.refXTransformed = this.refX;
                this.refYTransformed = this.frameHeight - this.refY;
                break;
            }
            case 4: {
                this.refXTransformed = this.frameHeight - this.refY;
                this.refYTransformed = this.refX;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.transformation = transform;
        this.x += oldRefX - this.refXTransformed;
        this.y += oldRefY - this.refYTransformed;
    }

    public final boolean collidesWith(Sprite s, boolean pixelLevel) {
        return this.visible && s.visible && this.currentCollRect.intersects(s.currentCollRect);
    }

    public final boolean collidesWith(TiledLayer t, boolean pixelLevel) {
        System.out.println("Sprite.collidesWithTitle(TitledLayer, boolean) called with no effect!");
        return false;
    }

    public final boolean collidesWith(Image image, int x, int y, boolean pixelLevel) {
        if (!this.visible) {
            return false;
        }
        Rectangle cr2 = new Rectangle(x, y, image.getWidth(), image.getHeight());
        return cr2.intersects(this.currentCollRect);
    }
}

