/*
 * Decompiled with CFR 0.152.
 */
package collisionphysics;

public class CollisionResponse {
    public float t;
    private static final float T_EPSILON = 0.005f;
    public float newSpeedX;
    public float newSpeedY;

    public CollisionResponse() {
        this.reset();
    }

    public void reset() {
        this.t = Float.MAX_VALUE;
    }

    public void copy(CollisionResponse another) {
        this.t = another.t;
        this.newSpeedX = another.newSpeedX;
        this.newSpeedY = another.newSpeedY;
    }

    public float getNewX(float currentX, float speedX) {
        if (this.t > 0.005f) {
            return currentX + speedX * (this.t - 0.005f);
        }
        return currentX;
    }

    public float getNewY(float currentY, float speedY) {
        if (this.t > 0.005f) {
            return currentY + speedY * (this.t - 0.005f);
        }
        return currentY;
    }

    public double getImpactX(float currentX, float speedX) {
        return currentX + speedX * this.t;
    }

    public double getImpactY(float currentY, float speedY) {
        return currentY + speedY * this.t;
    }
}

